/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public final class IntKeyedCollection
implements Cloneable,
Collection {
    private static final int DFT_CAPACITY = 16;
    private int nUsed = 0;
    private Element[] data = null;

    public IntKeyedCollection() {
    }

    public IntKeyedCollection(int initCapacity) {
        this.reserve(initCapacity);
    }

    public Object clone() {
        IntKeyedCollection doppleganger = null;
        try {
            doppleganger = (IntKeyedCollection)super.clone();
            if (this.data != null) {
                int newLen = this.data.length;
                if (newLen < this.nUsed + 1) {
                    newLen = this.nUsed + 1;
                }
                doppleganger.reserve(newLen);
                System.arraycopy(this.data, 0, doppleganger.data, 0, this.nUsed);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return doppleganger;
    }

    @Override
    public int size() {
        return this.nUsed;
    }

    @Override
    public boolean isEmpty() {
        return this.nUsed == 0;
    }

    public int capacity() {
        return this.data == null ? 0 : this.data.length;
    }

    public Object elementAt(int ix) {
        return this.data[ix];
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            private int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < IntKeyedCollection.this.nUsed;
            }

            public Object next() {
                if (this.pos >= IntKeyedCollection.this.nUsed) {
                    throw new RuntimeException("Element " + this.pos + " / " + IntKeyedCollection.this.nUsed);
                }
                return IntKeyedCollection.this.data[this.pos++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void reserve(int capacity) {
        if (this.data == null || capacity > this.data.length) {
            Element[] tmp = new Element[capacity];
            if (this.data != null) {
                System.arraycopy(this.data, 0, tmp, 0, this.nUsed);
            }
            this.data = tmp;
        }
    }

    public Object get(int key) {
        int pos = this.locate(key);
        if (pos >= this.nUsed) {
            return null;
        }
        Element e = this.data[pos];
        if (e.getKey() == key) {
            return e;
        }
        return null;
    }

    @Override
    public boolean contains(Object obj) {
        int key = ((Element)obj).getKey();
        int pos = this.locate(key);
        if (pos >= this.nUsed) {
            return false;
        }
        return this.data[pos].getKey() == key;
    }

    public boolean containsAll(Collection col) {
        if (col == null) {
            return true;
        }
        Iterator it = col.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    public boolean add(Object obj) {
        int pos;
        Element e = (Element)obj;
        if (this.data == null) {
            this.reserve(16);
        }
        if ((pos = this.locate(e.getKey())) < this.nUsed && this.data[pos].getKey() == e.getKey()) {
            if (this.data[pos] == e) {
                return false;
            }
            this.data[pos] = e;
            return true;
        }
        if (this.nUsed >= this.data.length) {
            this.reserve(this.nUsed * 2);
        }
        if (pos < this.nUsed) {
            System.arraycopy(this.data, pos, this.data, pos + 1, this.nUsed - pos);
        }
        this.data[pos] = e;
        ++this.nUsed;
        return true;
    }

    public boolean addAll(Collection col) {
        if (col == null) {
            return false;
        }
        boolean changed = false;
        for (Object cur : col) {
            if (cur == null || !this.add(cur)) continue;
            changed = true;
        }
        return changed;
    }

    public boolean remove(int key) {
        int pos = this.locate(key);
        if (pos >= this.nUsed) {
            return false;
        }
        if (this.data[pos].getKey() != key) {
            return false;
        }
        this.removeAt(pos);
        return true;
    }

    @Override
    public boolean remove(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.remove(((Element)obj).getKey());
    }

    @Override
    public void clear() {
        for (int ix = 0; ix < this.nUsed; ++ix) {
            this.data[ix] = null;
        }
        this.nUsed = 0;
    }

    public boolean removeAll(Collection col) {
        if (col == null) {
            return false;
        }
        boolean changed = false;
        for (Object cur : col) {
            if (cur == null || !this.remove(cur)) continue;
            changed = true;
        }
        return changed;
    }

    public boolean retainAll(Collection col) {
        if (col == null) {
            boolean wasEmpty = this.nUsed == 0;
            this.clear();
            return !wasEmpty;
        }
        boolean changed = false;
        for (int ix = this.nUsed - 1; ix >= 0; --ix) {
            if (col.contains(this.data[ix])) continue;
            this.removeAt(ix);
            changed = true;
        }
        return changed;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Element[this.nUsed];
        System.arraycopy(this.data, 0, result, 0, this.nUsed);
        return result;
    }

    public Object[] toArray(Object[] output) {
        Object[] result;
        if (output.length >= this.nUsed) {
            result = output;
            if (result.length > this.nUsed) {
                result[this.nUsed] = null;
            }
        } else {
            result = (Object[])Array.newInstance(output.getClass(), this.nUsed);
        }
        System.arraycopy(this.data, 0, result, 0, this.nUsed);
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(1024);
        for (int ix = 0; ix < this.nUsed; ++ix) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(this.data[ix].getKey() + "=" + this.data[ix].toString());
        }
        return "[" + result.toString() + "]";
    }

    protected void removeAt(int pos) {
        --this.nUsed;
        this.data[pos] = null;
        if (pos < this.nUsed) {
            System.arraycopy(this.data, pos + 1, this.data, pos, this.nUsed - pos);
            this.data[this.nUsed] = null;
        }
    }

    private int locate(int key) {
        int hi = this.nUsed - 1;
        int lo = 0;
        while (hi >= lo) {
            int mid = lo + (hi - lo) / 2;
            int cur = this.data[mid].getKey();
            if (cur == key) {
                return mid;
            }
            if (cur < key) {
                lo = mid + 1;
                continue;
            }
            hi = mid - 1;
        }
        return lo;
    }

    public static interface Element {
        public int getKey();
    }
}

