/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.IndirectPoolProxy;
import com.elluminate.util.IndirectPooledObject;
import com.elluminate.util.ObjectPool;
import com.elluminate.util.UtilTuning;
import com.elluminate.util.log.LogSupport;

public class IndirectObjectPool {
    private ObjectPool pool = null;
    private Class type = null;

    public IndirectObjectPool(Class cls) {
        this(cls, UtilTuning.ObjectPoolScavengeInterval.getIntValue());
    }

    public IndirectObjectPool(Class cls, long scavenge) {
        if (!IndirectPooledObject.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("Class " + cls.getName() + " does not implement IndirectPooledObject.");
        }
        this.pool = ObjectPool.getInstance(IndirectPoolProxy.class, scavenge);
        this.type = cls;
        try {
            Object o = cls.newInstance();
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Unable to instantiate class " + cls.getName());
        }
    }

    public IndirectPooledObject alloc() {
        IndirectPoolProxy p = (IndirectPoolProxy)this.pool.alloc();
        IndirectPooledObject o = p.getTarget();
        if (o == null) {
            try {
                o = (IndirectPooledObject)this.type.newInstance();
            }
            catch (Throwable t) {
                LogSupport.exception(this, "alloc", t, true, " while allocating " + this.type.getName());
                return null;
            }
            o.poSetProxy(p);
            p.setTarget(o);
        }
        o.poInit();
        return o;
    }
}

