/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.I18nMessage;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.Resource;
import com.elluminate.util.UtilDebug;
import com.elluminate.util.image.ImageSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;

public class I18n {
    protected static final int READ_BLOCK_SIZE = 8192;
    private static final Object LOCK;
    private static final String UI_CLASS_NAME = "com.elluminate.gui.I18nUI";
    private static final Constructor UI_CTOR;
    private static HashMap<String, List<ResourceBundle>> rsrcMap;
    private static HashMap<String, LinkedList<ResourceBundle>> listMap;
    private HashMap overrides = new HashMap();
    private LinkedList resources = new LinkedList();
    private String fullName = null;
    protected Class cls = null;
    protected final boolean HAS_JAR_URL_BUG = !Platform.checkJavaVersion("1.5.0_19+");

    public static I18n create(Object obj) {
        return I18n.create(obj, true);
    }

    public static I18n create(Object obj, boolean uiRequested) {
        if (uiRequested && UI_CTOR != null) {
            try {
                return (I18n)UI_CTOR.newInstance(obj);
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to create com.elluminate.gui.I18nUI instance for: " + obj, t);
            }
        }
        return new I18n(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedList getResourceList(Class cls) {
        LinkedList<ResourceBundle> rsrcList;
        Class scan = cls;
        String cName = scan.getName();
        Object object = LOCK;
        synchronized (object) {
            if (listMap.containsKey(cName)) {
                LinkedList<ResourceBundle> result = listMap.get(cName);
                if (UtilDebug.RESOURCE_LOAD.show()) {
                    LogSupport.message(this, "getResourceList", this.fullName + ": reusing resources for " + cName + ": " + result.hashCode());
                }
                return result;
            }
            rsrcList = new LinkedList<ResourceBundle>();
            LinkedList<String> pkgList = new LinkedList<String>();
            String sName = cName;
            while (!sName.startsWith("java")) {
                int lastDot = sName.lastIndexOf(46);
                String pkg = lastDot < 0 ? "" : sName.substring(0, lastDot);
                if (!pkgList.contains(pkg)) {
                    pkgList.addLast(pkg);
                }
                scan = scan.getSuperclass();
                sName = scan.getName();
            }
            for (String pkg : pkgList) {
                List<ResourceBundle> rsrc = I18n.getRsrcFor(pkg, cls);
                if (rsrc == null) continue;
                if (UtilDebug.RESOURCE_LOAD.show()) {
                    LogSupport.message(this, "getResourceList", this.fullName + ": including package " + pkg);
                }
                for (ResourceBundle bundle : rsrc) {
                    rsrcList.addLast(bundle);
                }
            }
            listMap.put(cName, rsrcList);
        }
        if (UtilDebug.RESOURCE_LOAD.show()) {
            LogSupport.message(this, "getResourceList", this.fullName + ": created resource list for " + cName + ": " + rsrcList.hashCode());
        }
        if (rsrcList.isEmpty()) {
            LogSupport.message(this, "getResourceList", "No resources available for " + cls.getName());
        }
        return rsrcList;
    }

    private static List<ResourceBundle> getRsrcFor(String pkg, Class cls) {
        ResourceBundle resources;
        if (rsrcMap.containsKey(pkg)) {
            return rsrcMap.get(pkg);
        }
        ArrayList<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
        ResourceBundle strings = Resource.getResourceFor(pkg, "Strings", cls);
        if (strings != null) {
            bundles.add(strings);
        }
        if ((resources = Resource.getResourceFor(pkg, "Resources", cls)) != null) {
            bundles.add(resources);
        }
        rsrcMap.put(pkg, bundles);
        return new ArrayList<ResourceBundle>(bundles);
    }

    protected I18n(Object obj) {
        this.cls = obj instanceof Class ? (Class)obj : obj.getClass();
        this.fullName = this.cls.getName();
        this.resources = this.getResourceList(this.cls);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(4096);
        result.append("# Resources for: " + this.fullName);
        Iterator i = this.resources.iterator();
        while (i.hasNext()) {
            try {
                ResourceBundle rsrc = (ResourceBundle)i.next();
                result.append("# " + rsrc.getClass().getName() + " @ " + rsrc.hashCode() + ": " + rsrc.toString());
                Enumeration<String> keys = rsrc.getKeys();
                while (keys.hasMoreElements()) {
                    String key = null;
                    Object val = null;
                    try {
                        key = keys.nextElement();
                        val = rsrc.getObject(key.toString());
                    }
                    catch (Throwable t) {
                        val = t.toString();
                    }
                    if (key == null) continue;
                    result.append(key.toString() + " = " + this.escapeNewlines(val.toString()) + "\n");
                }
            }
            catch (Throwable throwable) {
            }
        }
        return result.toString();
    }

    public void override(String key, String value) {
        this.overrides.put(key, value);
    }

    public void checkDefined(String key) {
        String value = (String)this.overrides.get(key);
        if (value != null) {
            return;
        }
        Iterator i = this.resources.iterator();
        while (i.hasNext()) {
            try {
                ResourceBundle rsrc = (ResourceBundle)i.next();
                rsrc.getString(key);
                return;
            }
            catch (MissingResourceException ex) {
            }
        }
        throw new MissingResourceException("Can't find resource for class " + this.fullName + ", key " + key, this.fullName, key);
    }

    public Resource getResource(PropertiesEnum propKey) {
        return this.getResource(propKey.propName());
    }

    public Resource getResource(String key) {
        String path = this.getString(key);
        if (path == null) {
            return null;
        }
        return new Resource(this.cls, path);
    }

    public byte[] getBytes(String key) throws IOException {
        String path = this.getString(key);
        if (path == null) {
            return null;
        }
        Class<?> cls = this.getClass();
        InputStream str = cls.getResourceAsStream(path);
        if (str == null) {
            throw new IllegalArgumentException("Failed to open resource file " + path + " for " + key);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(8192);
        int read = 0;
        byte[] buf = new byte[8192];
        int count = 0;
        int len = 0;
        int min = buf.length + 1;
        int max = -1;
        do {
            if ((read = str.read(buf)) <= 0) continue;
            os.write(buf, 0, read);
            ++count;
            len += read;
            if (read < min) {
                min = read;
            }
            if (read <= max) continue;
            max = read;
        } while (read >= 0);
        if (UtilDebug.RESOURCE_READ.show()) {
            LogSupport.message(this, "getBytes", path + ":\t" + len + "\t" + min + "\t" + max + "\t" + count + "\t" + (len + count / 2) / count);
        }
        os.flush();
        return os.toByteArray();
    }

    public String getString(PropertiesEnum propKey) {
        return this.getString(propKey.propName());
    }

    public String getString(PropertiesEnum propKey, Object ... params) {
        return this.getString(propKey.propName(), params);
    }

    public String getStringLegacy(String key) {
        return this.getString(key);
    }

    public String getStringLegacy(String key, Object ... params) {
        return this.getString(key, params);
    }

    public String getFormattedString(PropertiesEnum propKey, Object[] params) {
        return this.getFormattedString(propKey.propName(), params);
    }

    public int getInt(PropertiesEnum propKey) {
        return this.getInt(propKey.propName());
    }

    public I18nMessage getMessage(PropertiesEnum propKey) {
        return this.getMessage(propKey.propName());
    }

    public I18nMessage getMessage(PropertiesEnum propKey, Object ... params) {
        return this.getMessage(propKey.propName(), params);
    }

    public I18nMessage getMessageLegacy(String key) {
        return this.getMessage(key);
    }

    public I18nMessage getMessageLegacy(String key, Object ... params) {
        return this.getMessage(key, params);
    }

    public URL getImageUrl(PropertiesEnum propKey) {
        return this.getImageUrl(propKey.propName());
    }

    public URL getURLforPath(PropertiesEnum propKey) {
        return this.getURLforPath(propKey.propName());
    }

    public URL getURLforPath(String path) {
        URL url;
        if (path.startsWith("/")) {
            url = this.cls.getResource(path);
        } else {
            try {
                url = new URL(path);
            }
            catch (MalformedURLException mux) {
                url = this.cls.getResource(path);
            }
        }
        if (this.HAS_JAR_URL_BUG) {
            url = this.fixJarURL(url);
        }
        return url;
    }

    public Image getImage(String key) {
        String path = this.getString(key);
        if (path == null) {
            return null;
        }
        return this.loadImage(path, key);
    }

    public Image getImage(PropertiesEnum propKey) {
        return this.getImage(propKey.propName());
    }

    public boolean isDummyImage(Image img) {
        return img instanceof DummyImage;
    }

    public ImageIcon getIcon(String key) {
        throw new UnsupportedOperationException("Icon resources not supported: " + key);
    }

    public ImageIcon getIcon(PropertiesEnum propKey) {
        throw new UnsupportedOperationException("Icon resources not supported: " + propKey);
    }

    protected String getString(String key) {
        String value = (String)this.overrides.get(key);
        if (value != null) {
            return value;
        }
        Iterator i = this.resources.iterator();
        while (i.hasNext()) {
            try {
                ResourceBundle rsrc = (ResourceBundle)i.next();
                return rsrc.getString(key);
            }
            catch (MissingResourceException ex) {
            }
        }
        throw new MissingResourceException("Can't find resource for class " + this.fullName + ", key " + key, this.fullName, key);
    }

    protected String getString(String key, Object ... params) {
        return this.getFormattedString(key, params);
    }

    protected int getInt(String key) {
        String value = this.getString(key);
        if (value.startsWith("0x") || value.startsWith("0X")) {
            return Integer.parseInt(value.substring(2), 16);
        }
        if (value.startsWith("#")) {
            return Integer.parseInt(value.substring(1), 16);
        }
        return Integer.parseInt(value);
    }

    protected String getFormattedString(String key, Object[] params) {
        return MessageFormat.format(this.getString(key), params);
    }

    protected I18nMessage getMessage(String key) {
        this.checkDefined(key);
        return new I18nMessage((Object)this.fullName, key);
    }

    protected I18nMessage getMessage(String key, Object ... params) {
        this.checkDefined(key);
        String[] sParams = new String[params.length];
        for (int i = 0; i < sParams.length; ++i) {
            sParams[i] = params[i].toString();
        }
        return new I18nMessage(this.fullName, key, sParams);
    }

    protected Image loadImage(String path, String key) {
        URL url = this.getURLforPath(path);
        if (url == null) {
            throw new IllegalArgumentException("Image resource " + path + " not found for " + key);
        }
        Image result = null;
        try {
            result = ImageSupport.loadImage(url);
        }
        catch (Throwable t) {
            LogSupport.exception(I18n.class, "loadImage", t, true);
        }
        if (result == null) {
            LogSupport.message(I18n.class, "loadImage", "Failed to load image '" + path + "' for key " + key + ", using default image.");
            result = new DummyImage();
        }
        return result;
    }

    protected URL getImageUrl(String key) {
        String path = this.getString(key);
        return this.getURLforPath(path);
    }

    protected static Class getMessageContext(I18nMessage msg) {
        if (msg != null) {
            return msg.getContext();
        }
        return null;
    }

    protected static String getMessageName(I18nMessage msg) {
        return msg.getMessageName();
    }

    protected URL fixJarURL(URL url) {
        if (url == null) {
            return url;
        }
        if (!this.HAS_JAR_URL_BUG) {
            return url;
        }
        if (!"jar".equals(url.getProtocol())) {
            return url;
        }
        if (url.toString().indexOf("!/") >= 0) {
            return url;
        }
        String path = url.getPath();
        URL result = url;
        try {
            URLConnection con = url.openConnection();
            String permitName = con.getPermission().getName();
            if (permitName == null) {
                return url;
            }
            File f = new File(permitName);
            if (!f.exists()) {
                return url;
            }
            result = new URL("jar:" + f.toURL().toExternalForm() + "!/" + path);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return url;
        }
        if (UtilDebug.RESOURCE_URL.show()) {
            LogSupport.message(I18n.class, "fixJarURL", "Fixing " + url + " => " + result);
        }
        return result;
    }

    private String escapeNewlines(String s) {
        StringBuffer result = new StringBuffer(s.length() * 3 / 2);
        StringTokenizer parser = new StringTokenizer(s, "\n\r", true);
        while (parser.hasMoreTokens()) {
            String token = parser.nextToken();
            if ("\n".equals(token)) {
                result.append("\\n");
                continue;
            }
            if ("\r".equals(token)) {
                result.append("\\r");
                continue;
            }
            result.append(token);
        }
        return result.toString();
    }

    static {
        Constructor<?> uiCtor;
        block3: {
            LOCK = new Object(){};
            uiCtor = null;
            if (!GraphicsEnvironment.isHeadless()) {
                try {
                    Class<?> uiClass = Class.forName(UI_CLASS_NAME);
                    uiCtor = uiClass.getConstructor(Object.class);
                }
                catch (Throwable t) {
                    uiCtor = null;
                    if (!UtilDebug.I18N.show()) break block3;
                    LogSupport.message(I18n.class, "<clinit>", "Error loading com.elluminate.gui.I18nUI: " + Debug.getStackTrace(t));
                }
            }
        }
        UI_CTOR = uiCtor;
        rsrcMap = new HashMap();
        listMap = new HashMap();
    }

    protected static class DummyImage
    extends BufferedImage {
        protected DummyImage() {
            super(13, 13, 1);
            this.paintImageData();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintImageData() {
            int w = this.getWidth();
            int h = this.getHeight();
            Graphics2D g = null;
            try {
                g = this.createGraphics();
                g.setColor(Color.YELLOW);
                g.fillRect(0, 0, w - 1, h - 1);
                g.setColor(Color.BLACK);
                g.drawRect(0, 0, w - 1, h - 1);
                g.setStroke(new BasicStroke(1.3f));
                g.setColor(Color.RED);
                g.drawLine(0, 0, w - 1, h - 1);
                g.drawLine(0, h - 1, w - 1, 0);
            }
            finally {
                if (g != null) {
                    g.dispose();
                }
            }
        }
    }
}

