/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.CPropertyChangeSupport;
import com.elluminate.util.Debug;
import com.elluminate.util.log.LogSupport;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;

public final class DebugFlag {
    public static final String SHOW_PROPERTY = "debugEnabled";
    private static final HashMap<String, DebugFlag> flags = new HashMap();
    private boolean enabled = false;
    private String name = null;
    private CPropertyChangeSupport pcs = null;

    public static DebugFlag get(String name) {
        return DebugFlag.get(name, false, null);
    }

    public static DebugFlag get(String name, PropertyChangeListener lst) {
        return DebugFlag.get(name, false, lst);
    }

    private static DebugFlag get(String name, boolean initState) {
        return DebugFlag.get(name, initState, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DebugFlag get(String name, boolean initState, PropertyChangeListener lst) {
        DebugFlag flag = null;
        HashMap<String, DebugFlag> hashMap = flags;
        synchronized (hashMap) {
            if (flags.containsKey(name)) {
                flag = flags.get(name);
            } else {
                boolean override = Boolean.getBoolean("com.elluminate.debugFlag." + name);
                flag = new DebugFlag(name);
                if (initState || override != flag.isEnabled()) {
                    flag.setEnabled(initState || override);
                }
                flags.put(name, flag);
            }
        }
        if (lst != null) {
            flag.addPropertyChangeListener(lst);
        }
        if (initState) {
            LogSupport.message(DebugFlag.class, "get", "Flag '" + name + "' is initialized to " + initState + "\n" + Debug.getStackTrace(new Exception()));
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getList(boolean all) {
        StringBuilder flagInfo = new StringBuilder();
        HashMap<String, DebugFlag> hashMap = flags;
        synchronized (hashMap) {
            for (String key : flags.keySet()) {
                DebugFlag flag = flags.get(key);
                if (!all && !flag.show()) continue;
                if (flagInfo.length() > 0) {
                    flagInfo.append(",");
                }
                flagInfo.append(key);
                flagInfo.append(flag.show() ? (char)'+' : '-');
            }
        }
        return flagInfo.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(String name) {
        boolean exists = false;
        HashMap<String, DebugFlag> hashMap = flags;
        synchronized (hashMap) {
            exists = flags.containsKey(name);
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAll() {
        HashMap<String, DebugFlag> hashMap = flags;
        synchronized (hashMap) {
            for (DebugFlag flag : flags.values()) {
                flag.setEnabled(false);
            }
        }
    }

    public static Iterator<DebugFlag> iterator() {
        return flags.values().iterator();
    }

    private DebugFlag(String nm) {
        this.name = nm;
        this.pcs = new CPropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener lst) {
        this.pcs.addPropertyChangeListener(lst);
    }

    public void addPropertyChangeListener(String prop, PropertyChangeListener lst) {
        this.pcs.addPropertyChangeListener(prop, lst);
    }

    public void removePropertyChangeListener(PropertyChangeListener lst) {
        this.pcs.removePropertyChangeListener(lst);
    }

    public void removePropertyChangeListener(String prop, PropertyChangeListener lst) {
        this.pcs.removePropertyChangeListener(prop, lst);
    }

    public String getName() {
        return this.name;
    }

    public boolean show() {
        return this.enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean state) {
        boolean prev = this.enabled;
        this.enabled = state;
        if (prev != this.enabled) {
            this.pcs.firePropertyChange(SHOW_PROPERTY, prev, this.enabled);
            LogSupport.message(this, "setEnabled", this.toString());
        }
    }

    public boolean equals(Object o) {
        if (o instanceof DebugFlag) {
            return this.name.equals(((DebugFlag)o).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name + "=" + (this.enabled ? "ON" : "OFF");
    }
}

