/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import java.io.PrintWriter;
import java.io.StringWriter;

public final class Debug {
    public static void lockEnter(Object src, String method, String lockNm, Object lock) {
    }

    public static void lockLeave(Object src, String method, String lockNm, Object lock) {
    }

    public static String getStackTrace(Throwable t) {
        StringWriter writer = null;
        PrintWriter printer = null;
        try {
            writer = new StringWriter(2048);
            printer = new PrintWriter(writer);
            String err = Debug.getStackTrace(t, printer);
            if (err != null) {
                try {
                    printer.flush();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                try {
                    writer.flush();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                return err;
            }
            printer.flush();
            return writer.toString();
        }
        catch (OutOfMemoryError oome) {
            if (t instanceof OutOfMemoryError) {
                return "Out-of-memory";
            }
            return "Out-of-memory: processing " + t;
        }
        catch (Throwable t2) {
            return "Exception (" + t2 + ") encountered while processing: " + t;
        }
    }

    public static String getStackTrace(Throwable t, PrintWriter print) {
        try {
            print.print("Exception Trace - ");
            try {
                t.printStackTrace(print);
            }
            catch (Throwable t2) {
                print.println("Exception (" + t2 + ") encountered while tracing " + t);
            }
            for (Throwable w = t.getCause(); w != null; w = w.getCause()) {
                print.print("Target Exception Trace - ");
                try {
                    w.printStackTrace(print);
                    continue;
                }
                catch (Throwable t2) {
                    print.println("Exception (" + t2 + ") encountered tracing wrapped exception " + w);
                }
            }
        }
        catch (OutOfMemoryError oome) {
            if (t instanceof OutOfMemoryError) {
                return "Out-of-memory(PrintWriter)";
            }
            return "Out-of-memory: printing " + t;
        }
        catch (Throwable t2) {
            return "Exception (" + t2 + ") encountered while printing: " + t;
        }
        return null;
    }
}

