/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class ArraySet<T>
extends AbstractSet<T> {
    private List<T> members;

    public ArraySet() {
        this.members = new ArrayList<T>();
    }

    public ArraySet(int initialCapacity) {
        this.members = new ArrayList<T>(initialCapacity);
    }

    public ArraySet(Collection<? extends T> c) {
        this.members = new ArrayList<T>(c.size());
        this.addAll(c);
    }

    public ArraySet(Set<? extends T> set) {
        this.members = new ArrayList<T>(set);
    }

    private ArraySet(ArraySet<T> src, int fromIdx, int toIdx) {
        if (fromIdx < 0 || toIdx > src.size()) {
            throw new IllegalArgumentException();
        }
        this.members = src.members.subList(fromIdx, toIdx);
    }

    @Override
    public boolean add(T o) {
        if (this.members.contains(o)) {
            return false;
        }
        this.members.add(o);
        return true;
    }

    @Override
    public int size() {
        return this.members.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.members.iterator();
    }

    public T first() {
        if (this.members.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.members.get(0);
    }

    public T last() {
        if (this.members.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.members.get(this.members.size() - 1);
    }

    public ArraySet<T> subSet(T fromElement, T toElement) {
        int fromIdx = this.members.indexOf(fromElement);
        int toIdx = this.members.indexOf(toElement);
        return new ArraySet<T>(this, fromIdx, toIdx);
    }

    public ArraySet<T> headSet(T toElement) {
        int toIdx = this.members.indexOf(toElement);
        return new ArraySet<T>(this, 0, toIdx);
    }

    public ArraySet<T> tailSet(T fromElement) {
        int fromIdx = this.members.indexOf(fromElement);
        return new ArraySet<T>(this, fromIdx, this.members.size());
    }
}

