/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.platform.windows;

import com.elluminate.platform.AppLookupAPI;
import com.elluminate.platform.windows.WinRegistry;
import java.io.File;
import java.util.StringTokenizer;

public class WinAppLookup
implements AppLookupAPI {
    @Override
    public File findAppByMIME(String mimeType) {
        throw new UnsupportedOperationException("Method findAppByMIME() not implemented.");
    }

    @Override
    public File findAppByExtension(String extension) {
        String appId = WinRegistry.getRegKeySZValue("HKEY_CLASSES_ROOT", "." + extension, "");
        File execFile = null;
        String executable = "";
        if (appId != null) {
            String shellOpenCmdKey = appId + "\\shell\\open\\command";
            String shellOpenCmd = WinRegistry.getRegKeySZValue("HKEY_CLASSES_ROOT", shellOpenCmdKey, "");
            if (shellOpenCmd == null) {
                shellOpenCmd = WinRegistry.getRegKeyExpandSZValue("HKEY_CLASSES_ROOT", shellOpenCmdKey, "", true);
            }
            if (shellOpenCmd != null) {
                StringTokenizer tokens = new StringTokenizer(shellOpenCmd, "\" ", true);
                boolean quoted = false;
                while (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken();
                    if (token.equals("\"")) {
                        if (quoted) break;
                        quoted = true;
                        continue;
                    }
                    if (token.equals(" ")) {
                        if (!quoted) continue;
                        executable = executable + token;
                        continue;
                    }
                    executable = executable + token;
                    if (quoted) continue;
                    break;
                }
                if (!(execFile = new File(executable)).isFile()) {
                    return null;
                }
            }
        }
        return execFile;
    }
}

