/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.platform.macos;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.OpenURIHandler;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import com.google.inject.Singleton;
import java.lang.reflect.Method;
import java.net.URI;

@Singleton
public final class MacAppUtils {
    private Method aboutMethod = null;
    private Object aboutHandler = null;
    private Method preferencesMethod = null;
    private Object preferencesHandler = null;
    private Method quitMethod = null;
    private Object quitHandler = null;
    private Method uriMethod = null;
    private Object uriHandler = null;

    public void setAboutHandler(Object handler, Method method) {
        boolean shouldRegister = this.aboutHandler == null;
        this.aboutHandler = handler;
        this.aboutMethod = method;
        if (!shouldRegister) {
            return;
        }
        Application.getApplication().setAboutHandler(new AboutHandler(){

            public void handleAbout(AppEvent.AboutEvent e) {
                MacAppUtils.this.doAbout();
            }
        });
    }

    public void setPreferencesHandler(Object handler, Method method) {
        boolean shouldRegister = this.preferencesHandler == null;
        this.preferencesHandler = handler;
        this.preferencesMethod = method;
        if (!shouldRegister) {
            return;
        }
        Application.getApplication().setPreferencesHandler(new PreferencesHandler(){

            public void handlePreferences(AppEvent.PreferencesEvent e) {
                MacAppUtils.this.doPreferences();
            }
        });
    }

    public void setQuitHandler(Object handler, Method method) {
        boolean shouldRegister = this.quitHandler == null;
        this.quitHandler = handler;
        this.quitMethod = method;
        if (!shouldRegister) {
            return;
        }
        Application.getApplication().setQuitHandler(new QuitHandler(){

            public void handleQuitRequestWith(AppEvent.QuitEvent e, QuitResponse r) {
                MacAppUtils.this.doQuit();
            }
        });
    }

    public void setOpenURIHandler(Object handler, Method method) {
        boolean shouldRegister = this.uriHandler == null;
        this.uriHandler = handler;
        this.uriMethod = method;
        if (!shouldRegister) {
            return;
        }
        Application.getApplication().setOpenURIHandler(new OpenURIHandler(){

            public void openURI(AppEvent.OpenURIEvent e) {
                MacAppUtils.this.doOpenURI(e.getURI());
            }
        });
    }

    private void doAbout() {
        if (this.aboutMethod != null) {
            try {
                this.aboutMethod.invoke(this.aboutHandler, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void doPreferences() {
        if (this.preferencesMethod != null) {
            try {
                this.preferencesMethod.invoke(this.preferencesHandler, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void doQuit() {
        if (this.quitMethod != null) {
            try {
                this.quitMethod.invoke(this.quitHandler, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void doOpenURI(URI uri) {
        if (this.uriMethod != null) {
            try {
                this.uriMethod.invoke(this.uriHandler, uri);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

