/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.nio;

import com.elluminate.net.AsyncConnectionHandler;
import com.elluminate.net.AsyncServerEndpoint;
import com.elluminate.net.nio.AsyncIOManager;
import com.elluminate.net.nio.AsyncIOState;
import com.elluminate.net.nio.SelectorAsyncEndpoint;
import com.elluminate.util.log.LogSupport;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Locale;
import java.util.StringTokenizer;

public class SelectorAsyncServerEndpoint
extends AsyncServerEndpoint {
    private ServerSocketChannel chnl;
    private Runnable acceptProc;
    private AsyncConnectionHandler handlerHead = null;
    private AsyncConnectionHandler handlerTail = null;
    private AsyncIOState ioState = null;

    public SelectorAsyncServerEndpoint() throws IOException {
        if (!AsyncIOManager.isAvailable()) {
            throw new IOException("no AsyncIO manager available.");
        }
        this.acceptProc = new Runnable(){

            @Override
            public void run() {
                SelectorAsyncServerEndpoint.this.doAccept();
            }
        };
    }

    @Override
    public void parseProtocols(String protocols) throws IOException {
        StringTokenizer parser = new StringTokenizer(protocols, ",");
        AsyncConnectionHandler universal = null;
        this.handlerTail = null;
        this.handlerHead = null;
        while (parser.hasMoreTokens()) {
            String token = parser.nextToken();
            AsyncConnectionHandler handler = this.getConnectionHandler(token);
            if (handler == null) {
                throw new IOException("Unsupported protocol '" + token + "'");
            }
            if (handler.isUniversal()) {
                if (universal != null) {
                    throw new IOException("Multiple universal protocols specified - " + token);
                }
                universal = handler;
                continue;
            }
            if (this.handlerTail != null) {
                this.handlerTail.setNext(handler);
            } else {
                this.handlerHead = handler;
            }
            this.handlerTail = handler;
        }
        if (universal != null) {
            if (this.handlerTail != null) {
                this.handlerTail.setNext(universal);
            } else {
                this.handlerHead = universal;
            }
            this.handlerTail = universal;
        }
        InetSocketAddress isa = this.bindAddr != null ? new InetSocketAddress(this.bindAddr, this.port) : new InetSocketAddress(this.port);
        this.chnl = ServerSocketChannel.open();
        this.chnl.socket().bind(isa, this.backlog);
        this.chnl.configureBlocking(false);
        this.ioState = new ServerIOState(this.chnl);
        this.ioState.addOp(16);
    }

    @Override
    public void beginClose() {
        new AsyncCloser(this).start();
    }

    private void doAccept() {
        try {
            SocketChannel c;
            while ((c = this.chnl.accept()) != null) {
                this.ioState.run(new AsyncConnector(c));
            }
            this.ioState.addOp(16);
        }
        catch (ClosedChannelException ccx) {
        }
        catch (IOException iox) {
            try {
                this.listener.asyncException(this, iox);
            }
            catch (Throwable t) {
                LogSupport.exception(this, "doAccept", t, true);
            }
        }
    }

    private AsyncConnectionHandler getConnectionHandler(String method) {
        AsyncConnectionHandler handler = null;
        try {
            String name = method.substring(0, 1).toUpperCase(Locale.ENGLISH) + method.substring(1).toLowerCase(Locale.ENGLISH);
            Class<?> cls = Class.forName("com.elluminate.net." + name.toLowerCase(Locale.ENGLISH) + "." + name + "AsyncConnectionHandler");
            handler = (AsyncConnectionHandler)cls.newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return handler;
    }

    private class AsyncCloser
    extends Thread {
        SelectorAsyncServerEndpoint sep;

        public AsyncCloser(SelectorAsyncServerEndpoint sep) {
            super("AsyncCloser-" + sep.getLocalPort());
            this.sep = sep;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.sep.chnl.close();
                if (this.sep.listener == null) {
                    return;
                }
                try {
                    this.sep.listener.asyncClose(this.sep);
                }
                catch (Throwable t) {
                    LogSupport.exception(this, "run", t, true);
                }
            }
            catch (IOException iox) {
                if (this.sep.listener == null) {
                    return;
                }
                try {
                    this.sep.listener.asyncException(this.sep, iox);
                }
                catch (Throwable t) {
                    LogSupport.exception(this, "run", t, true);
                }
            }
        }
    }

    private class AsyncConnector
    implements Runnable {
        SocketChannel chnl;

        public AsyncConnector(SocketChannel c) {
            this.chnl = c;
        }

        @Override
        public void run() {
            try {
                SelectorAsyncEndpoint aep = new SelectorAsyncEndpoint(this.chnl);
                SelectorAsyncServerEndpoint.this.handlerHead.process(aep, SelectorAsyncServerEndpoint.this.listener);
            }
            catch (IOException iox) {
                LogSupport.error(this, "run", "I/O Exception setting up endpoint " + iox);
            }
        }
    }

    private class ServerIOState
    extends AsyncIOState {
        public ServerIOState(ServerSocketChannel chnl) throws IOException {
            super(chnl);
        }

        @Override
        public Runnable getAcceptProc() {
            return SelectorAsyncServerEndpoint.this.acceptProc;
        }
    }
}

