/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.httpCommon;

import com.elluminate.net.AsyncEndpoint;
import com.elluminate.net.AsyncIOListener;
import com.elluminate.net.AsyncIORequest;
import com.elluminate.net.httpCommon.HttpResponseRecvListener;
import com.elluminate.net.httpCommon.HttpResponseSendListener;
import com.elluminate.util.log.LogSupport;
import com.elluminate.util.net.HttpResponse;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;

public class AsyncHttpResponse
extends HttpResponse
implements AsyncIOListener {
    private static final int BUFFER_SIZE = 256;
    protected AsyncEndpoint endpoint;
    protected HttpResponseSendListener sendListener;
    protected HttpResponseRecvListener recvListener;
    private byte[] buffer = null;
    private StringBuffer lineBuf = null;
    private boolean crSeen = false;
    private String lastHeader = null;

    public AsyncHttpResponse() {
    }

    public AsyncHttpResponse(int code, String msg, int length, boolean close, int ver, boolean debug) {
        this.init(code, msg, length, close, ver, debug);
    }

    public AsyncHttpResponse(DataInputStream istr, boolean debug) throws IOException {
        this.init(istr, debug);
    }

    public AsyncHttpResponse(AsyncEndpoint ep, boolean debug, HttpResponseRecvListener lst) {
        this.init(ep, debug, lst);
    }

    public void init(AsyncEndpoint ep, boolean debug, HttpResponseRecvListener lst) {
        this.debug = debug;
        this.recvListener = lst;
        this.code = -1;
        this.endpoint = ep;
        this.lastHeader = null;
        this.getLine();
    }

    public void send(AsyncEndpoint ep, HttpResponseSendListener lst) {
        byte[] buf;
        if (!this.writable) {
            throw new IllegalStateException("Attempt to send a write-protected response.");
        }
        this.writable = false;
        this.sendListener = lst;
        this.endpoint = ep;
        String reqStr = this.toString();
        if (this.debug) {
            StringTokenizer lines = new StringTokenizer(reqStr, "\n");
            while (lines.hasMoreTokens()) {
                String token = lines.nextToken();
                if (this.context != null) {
                    LogSupport.message(this, this.context, token);
                    continue;
                }
                LogSupport.message(this, "send", token);
            }
        }
        try {
            buf = reqStr.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException uex) {
            buf = reqStr.getBytes();
        }
        try {
            if (ep.beginWriteFully(buf, this)) {
                this.sendDone();
            }
        }
        catch (IOException iox) {
            this.sendFail(iox);
        }
    }

    protected void getLine() {
        this.crSeen = false;
        if (this.buffer == null) {
            this.buffer = new byte[256];
            this.lineBuf = new StringBuffer();
        }
        try {
            int nRead;
            while (this.processBytes(nRead = this.endpoint.beginRead(this.buffer, 0, this.buffer.length, this))) {
            }
        }
        catch (IOException iox) {
            this.recvFail(iox);
        }
    }

    private boolean processBytes(int len) {
        int off = 0;
        if (len <= 0) {
            return false;
        }
        while (len > 0) {
            char c = (char)(this.buffer[off] & 0x7F);
            ++off;
            --len;
            if (c == '\n') {
                String line = this.lineBuf.toString();
                this.lineBuf.setLength(0);
                if (len > 0) {
                    this.endpoint.unread(this.buffer, off, len);
                }
                this.processLine(line);
                return false;
            }
            if (c == '\r') {
                this.crSeen = true;
                continue;
            }
            if (this.crSeen) {
                this.lineBuf.append('\r');
                this.crSeen = false;
            }
            this.lineBuf.append(c);
        }
        return true;
    }

    protected void processLine(String line) {
        try {
            if (line.length() == 0) {
                this.evaluateHeaders();
                this.recvDone();
            } else if (this.code == -1) {
                if (this.parseResponseLine(line)) {
                    this.getLine();
                }
            } else {
                this.lastHeader = this.parseHeaderLine(line, this.lastHeader, this.debug);
                this.getLine();
            }
        }
        catch (IOException iox) {
            this.recvFail(iox);
        }
    }

    @Override
    public void readComplete(AsyncIORequest req) {
        try {
            int nRead = req.finishRequest();
            while (this.processBytes(nRead)) {
                nRead = this.endpoint.beginRead(this.buffer, 0, this.buffer.length, this);
            }
        }
        catch (IOException iox) {
            this.recvFail(iox);
        }
    }

    @Override
    public void writeComplete(AsyncIORequest req) {
        try {
            req.finishRequest();
            this.sendDone();
        }
        catch (IOException iox) {
            this.sendFail(iox);
        }
    }

    @Override
    public void closeComplete(AsyncIORequest req) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connectComplete(AsyncIORequest req) {
        throw new UnsupportedOperationException();
    }

    protected void recvFail(IOException iox) {
        HttpResponseRecvListener l = this.recvListener;
        this.recvListener = null;
        this.endpoint = null;
        if (l != null) {
            l.responseRecvFailed(this, iox);
        }
    }

    protected void recvDone() {
        HttpResponseRecvListener l = this.recvListener;
        this.recvListener = null;
        this.endpoint = null;
        if (l != null) {
            l.responseReceived(this);
        }
    }

    protected void sendFail(IOException iox) {
        HttpResponseSendListener l = this.sendListener;
        this.sendListener = null;
        this.endpoint = null;
        if (l != null) {
            l.responseSendFailed(this, iox);
        }
    }

    protected void sendDone() {
        HttpResponseSendListener l = this.sendListener;
        this.sendListener = null;
        this.endpoint = null;
        if (l != null) {
            l.responseSent(this);
        }
    }
}

