/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.http;

import com.elluminate.net.DOSWatchdog;
import com.elluminate.net.Endpoint;
import com.elluminate.net.NetDebug;
import com.elluminate.net.http.HttpConnection;
import com.elluminate.net.http.HttpSession;
import com.elluminate.net.httpCommon.NetHttpRequest;
import com.elluminate.net.httpCommon.NetHttpResponse;
import com.elluminate.util.crypto.DiffieHellman;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.LinkedList;

public class HttpServerConnection
extends HttpConnection {
    private static Object seqLock = new Object();
    private static int seqLast = 0;
    private LinkedList<Endpoint> queue = null;
    private byte[] key = new byte[DiffieHellman.getKeyLength()];
    private boolean readEmpty = true;

    public HttpServerConnection(LinkedList<Endpoint> queue, Endpoint ep, DataInputStream in, DataOutputStream out) {
        super("HttpServerConnection-" + HttpServerConnection.nextSequence(), ep, in, out);
        if (NetDebug.CONNECTIONS.show()) {
            LogSupport.message(this, "<init>", "Create HTTP connection " + this.getName() + " from " + ep.getInetAddress() + ":" + ep.getPort() + " to port " + ep.getLocalPort());
        }
        this.queue = queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int nextSequence() {
        int seq;
        Object object = seqLock;
        synchronized (object) {
            seq = ++seqLast;
        }
        return seq;
    }

    @Override
    protected void init(Endpoint ep, DataInputStream in, DataOutputStream out) {
        try {
            ep.setSoLinger(true, 5);
            ep.setSoTimeout(5000);
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int idle(Endpoint ep, DataInputStream in, DataOutputStream out) {
        byte[] dhRaw = null;
        block35: while (true) {
            NetHttpRequest req;
            DOSWatchdog watchdog = new DOSWatchdog(ep);
            try {
                req = new NetHttpRequest(in);
                watchdog.leash();
            }
            catch (IOException ex) {
                watchdog.leash();
                Thread.interrupted();
                this.close();
                return -1;
            }
            this.httpVer = req.getHttpVersion();
            if (req.getMethod() != 0) {
                if (NetDebug.HTTP.show()) {
                    LogSupport.error(this, "idle", "Protocol error - " + req);
                }
                this.errorResponse(out, 400, "Invalid method - expected POST", req.getSession());
                return 0;
            }
            switch (req.getRequest()) {
                case 0: {
                    NetHttpResponse resp;
                    if (req.getLength() > 0) {
                        int nRead;
                        byte[] buffer = new byte[Math.min(req.getLength(), 256)];
                        for (int len = req.getLength(); len > 0; len -= nRead) {
                            int nToRead = Math.min(len, buffer.length);
                            nRead = 0;
                            try {
                                nRead = in.read(buffer, 0, nToRead);
                                if (nRead >= 0) continue;
                                throw new EOFException();
                            }
                            catch (IOException ex) {
                                this.close();
                                return -1;
                            }
                        }
                    }
                    try {
                        resp = new NetHttpResponse(200, "OK", 4, false, this.httpVer);
                        resp.send(out);
                        out.write("OK\r\n".getBytes());
                        continue block35;
                    }
                    catch (IOException ex) {
                        this.close();
                        return -1;
                    }
                }
                case 1: {
                    HttpSession session;
                    NetHttpResponse resp;
                    if (req.getLength() != DiffieHellman.getChallengeLength()) {
                        if (NetDebug.HTTP.show()) {
                            LogSupport.error(this, "run", "Invalid request lengtb " + req.getLength() + ", expected " + DiffieHellman.getChallengeLength());
                        }
                        this.errorResponse(out, 400, "Invalid validation token.", req.getSession());
                        return 0;
                    }
                    try {
                        dhRaw = new byte[DiffieHellman.getChallengeLength()];
                        in.readFully(dhRaw);
                        String dhStr = new String(dhRaw);
                        session = HttpSession.newSession(ep, this.queue);
                        resp = new NetHttpResponse(200, "OK", 8 + DiffieHellman.getChallengeLength(), false, this.httpVer);
                        resp.send(out);
                        out.writeInt(session.getID());
                        dhRaw = session.getChallenge().getBytes();
                        session.setResponse(dhStr);
                        out.write(dhRaw);
                        int mode = session.waitMode(15000L);
                        out.writeInt(mode);
                        if (mode <= 0) continue block35;
                        LinkedList<Endpoint> linkedList = this.queue;
                        synchronized (linkedList) {
                            this.queue.addLast(session);
                            this.queue.notifyAll();
                            continue block35;
                        }
                    }
                    catch (IOException ex) {
                        this.close();
                        return -1;
                    }
                }
                case 2: {
                    NetHttpResponse resp;
                    HttpSession session = HttpSession.findSession(req.getSession());
                    if (session == null) {
                        if (NetDebug.HTTP.show()) {
                            LogSupport.error(this, "run", "Session " + req.getSession() + " not found.");
                        }
                        this.errorResponse(out, 404, "No such session", req.getSession());
                        return -1;
                    }
                    this.handler = session;
                    if (req.getLength() != session.getKeyLength() + 4) {
                        if (NetDebug.HTTP.show()) {
                            LogSupport.error(this, "run", "Join content length " + req.getLength() + " invalid.");
                        }
                        this.errorResponse(out, 400, "Invalid validation token length.", req.getSession());
                        this.handler = null;
                        return -1;
                    }
                    try {
                        byte[] prefix = new byte[4];
                        in.readFully(prefix);
                    }
                    catch (IOException iox) {
                        this.errorResponse(out, 400, "Unable to read join prefix", req.getSession());
                        this.handler = null;
                        return -1;
                    }
                    session.join(this.getEndpoint());
                    byte[] key = new byte[session.getKeyLength()];
                    try {
                        in.readFully(key);
                        if (!session.authenticateJoin(this.getEndpoint(), req.getPath(), key)) {
                            if (NetDebug.HTTP.show()) {
                                LogSupport.error(this, "run", "Authentication failed on port " + this.getEndpoint().getPort());
                            }
                            this.errorResponse(out, 403, "Invalid validation token.", req.getSession());
                            this.handler = null;
                            return -1;
                        }
                        resp = new NetHttpResponse(200, "OK", 4, false, this.httpVer);
                        resp.send(out);
                        out.writeInt(req.getSession());
                        continue block35;
                    }
                    catch (IOException ex) {
                        return -1;
                    }
                }
                case 5: {
                    try {
                        if (!this.authenticate(req, in, out)) {
                            return -1;
                        }
                    }
                    catch (IOException ex) {
                        return -1;
                    }
                    this.nLeft = req.getLength() - DiffieHellman.getKeyLength();
                    this.readEmpty = this.nLeft == 0;
                    if (!req.isDone()) return 1;
                    return -1;
                }
                case 3: {
                    NetHttpResponse resp;
                    try {
                        if (!this.authenticate(req, in, out)) {
                            return -1;
                        }
                    }
                    catch (IOException ex) {
                        return -1;
                    }
                    this.nLeft = 65536;
                    try {
                        resp = new NetHttpResponse(200, "OK", this.nLeft, false, this.httpVer);
                        resp.send(out);
                        return 3;
                    }
                    catch (IOException ex) {
                        return -1;
                    }
                }
                case 4: {
                    try {
                        if (!this.authenticate(req, in, out)) {
                            return -1;
                        }
                    }
                    catch (IOException ex) {
                        return -1;
                    }
                    this.nLeft = req.getLength() - DiffieHellman.getKeyLength();
                    return 2;
                }
                case 6: {
                    try {
                        if (!this.authenticate(req, in, out)) {
                            return -1;
                        }
                    }
                    catch (IOException ex) {
                        return -1;
                    }
                    NetHttpResponse resp = new NetHttpResponse(200, "Goodbye", 0, true, this.httpVer);
                    try {
                        resp.send(out);
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    HttpSession session = (HttpSession)this.handler;
                    session.closeForce();
                    return -1;
                }
            }
            LogSupport.error(this, "idle", "Protocol error - " + req);
            return -1;
        }
    }

    @Override
    protected boolean intermission(DataOutputStream out, int len) {
        if (len == 0) {
            try {
                if (this.readEmpty) {
                    Thread.sleep(100L);
                } else {
                    Thread.sleep(20L);
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        NetHttpResponse resp = len > 0 ? new NetHttpResponse(200, "OK", len, false, this.httpVer) : new NetHttpResponse(204, "EMPTY", 0, false, this.httpVer);
        try {
            resp.send(out);
            this.nLeft = len;
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    protected void epilogue(DataInputStream in, DataOutputStream out) {
        if (this.mode == 2) {
            NetHttpResponse resp = new NetHttpResponse(204, "OK", 0, false, this.httpVer);
            try {
                resp.send(out);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        this.handler = null;
    }

    @Override
    protected void shutdown(DataInputStream in, DataOutputStream out) {
    }

    private boolean authenticate(NetHttpRequest req, DataInputStream in, DataOutputStream out) throws IOException {
        HttpSession session = HttpSession.findSession(req.getSession());
        if (session == null) {
            this.errorResponse(out, 404, "No such session", req.getSession());
            return false;
        }
        in.readFully(this.key);
        if (!session.authenticateData(req.getPath(), this.key)) {
            this.errorResponse(out, 403, "Invalid authentication token.", req.getSession());
            return false;
        }
        this.handler = session;
        return true;
    }

    private void errorResponse(DataOutputStream out, int code, String msg, int session) {
        try {
            NetHttpResponse resp = new NetHttpResponse(code, msg, 4, true, this.httpVer);
            resp.send(out);
            out.writeInt(session);
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        return this.getName() + "(" + HttpConnection.getModeName(this.mode) + ")";
    }
}

