/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.http;

import com.elluminate.net.AbstractEndpoint;
import com.elluminate.net.Endpoint;
import com.elluminate.net.EndpointCaller;
import com.elluminate.net.EndpointOptions;
import com.elluminate.net.NetDebug;
import com.elluminate.net.ProxySocket;
import com.elluminate.net.http.CircularBuffer;
import com.elluminate.net.http.ConnectionInputStream;
import com.elluminate.net.http.ConnectionOutputStream;
import com.elluminate.net.http.HttpAltCaller;
import com.elluminate.net.http.HttpClientConnection;
import com.elluminate.net.http.HttpConnection;
import com.elluminate.net.http.HttpDataHandler;
import com.elluminate.net.http.QueuedInputStream;
import com.elluminate.net.http.QueuedOutputStream;
import com.elluminate.net.httpCommon.HttpSequenceProvider;
import com.elluminate.net.httpCommon.NetHttpRequest;
import com.elluminate.net.httpCommon.NetHttpResponse;
import com.elluminate.net.httpCommon.ProxyAuthenticator;
import com.elluminate.util.crypto.DiffieHellman;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;

public class HttpEndpoint
extends AbstractEndpoint
implements Endpoint,
HttpDataHandler,
HttpSequenceProvider {
    private static final int BUFFER_SIZE = 65536;
    private static final byte OPT_AUTO_DUPLEX = 0;
    private static final byte OPT_HALF_DUPLEX = 1;
    private static final byte OPT_FULL_DUPLEX = 2;
    public static final String OPT_DUPLEX = "duplex";
    public static final String[] OPT_DUPLEX_VALUES = new String[]{"auto", "half", "full"};
    private static final byte OPT_ROUTE_PROXY = 0;
    private static final byte OPT_ROUTE_DIRECT = 1;
    public static final String OPT_ROUTE = "route";
    public static final String[] OPT_ROUTE_VALUES = new String[]{"proxy", "direct"};
    private static final int[] ALT_PORTS = new int[]{80, 443, 8080};
    private static final long CONNECT_TIMEOUT = 20000L;
    private static Object seqLock = new Object();
    private static int connectSeq = 1;
    private HttpConnection cBoth = null;
    private HttpConnection cRead = null;
    private HttpConnection cWrite = null;
    private CircularBuffer inBuf = null;
    private CircularBuffer outBuf = null;
    private byte[] copyBuf = null;
    private DiffieHellman auth = new DiffieHellman();
    private Object rLock = new Object();
    private Object wLock = new Object();
    private HttpConnection aRead = null;
    private HttpConnection aWrite = null;
    private EndpointOptions rOpts = new EndpointOptions();
    private EndpointOptions wOpts = new EndpointOptions();
    private EndpointOptions opts = new EndpointOptions();
    private InetAddress localAddr = null;
    private int localPort = -1;
    private String targetHost = null;
    private int targetPort = 80;
    private InetAddress proxyAddr = null;
    private int proxyPort = 80;
    private int session = -1;
    private int sequence = 1;
    private HashSet callers = new HashSet();
    private ProxyAuthenticator proxy = new ProxyAuthenticator();
    private int mode = 0;
    private byte optDuplex = 0;
    private byte optRoute = 0;
    private OutputStream ostr = null;
    private InputStream istr = null;
    private PushbackInputStream userIstr = null;
    private int httpVer = 11;

    public HttpEndpoint(String targetHost, int targetPort, String proxyHost, int proxyPort, HashMap options) throws UnknownHostException, IOException {
        this.parseOptions(options);
        this.targetHost = targetHost;
        this.targetPort = targetPort;
        if (this.optRoute == 0) {
            this.proxyAddr = InetAddress.getByName(proxyHost);
            this.proxyPort = proxyPort;
        } else {
            this.proxyAddr = InetAddress.getByName(targetHost);
            this.proxyPort = targetPort;
        }
        this.init();
    }

    public HttpEndpoint(InetAddress targetAddr, int targetPort, InetAddress proxyAddr, int proxyPort, HashMap options) throws IOException {
        this.parseOptions(options);
        this.targetHost = targetAddr.getHostAddress();
        this.targetPort = targetPort;
        if (this.optRoute == 0) {
            this.proxyAddr = proxyAddr;
            this.proxyPort = proxyPort;
        } else {
            this.proxyAddr = targetAddr;
            this.proxyPort = targetPort;
        }
        this.init();
    }

    private void parseOptions(HashMap opts) {
        int i;
        String value;
        if (opts == null) {
            return;
        }
        if (opts.containsKey(OPT_DUPLEX)) {
            value = (String)opts.get(OPT_DUPLEX);
            for (i = 0; i < OPT_DUPLEX_VALUES.length; i = (int)((byte)(i + 1))) {
                if (!value.equalsIgnoreCase(OPT_DUPLEX_VALUES[i])) continue;
                this.optDuplex = (byte)i;
                break;
            }
        }
        if (opts.containsKey(OPT_ROUTE)) {
            value = (String)opts.get(OPT_ROUTE);
            for (i = 0; i < OPT_ROUTE_VALUES.length; i = (int)((byte)(i + 1))) {
                if (!value.equalsIgnoreCase(OPT_ROUTE_VALUES[i])) continue;
                this.optRoute = (byte)i;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IOException {
        Endpoint ep = null;
        NetHttpRequest req = null;
        DataInputStream istr = null;
        DataOutputStream ostr = null;
        if (this.proxyPort < 1 || this.proxyPort > 65535) {
            throw new IOException("Invalid proxy port - " + this.proxyPort);
        }
        ep = this.connect(this.targetHost, this.targetPort, this.proxyAddr, this.proxyPort, this.proxy);
        istr = new DataInputStream(ep.getInputStream());
        ostr = new DataOutputStream(ep.getOutputStream());
        req = new NetHttpRequest(this.targetHost, this.targetPort, 0, 1, 0, 0, DiffieHellman.getChallengeLength(), false, this.httpVer);
        this.proxy.authenticate(req);
        req.send(ostr);
        ostr.write(this.auth.getChallenge().getBytes());
        NetHttpResponse resp = new NetHttpResponse(istr);
        this.proxy.checkResponse(resp);
        if (resp.getCode() != 200) {
            throw new IOException("Connection failed - invalid response from server.\n" + resp.toString());
        }
        if (resp.getLength() != 8 + DiffieHellman.getChallengeLength()) {
            throw new IOException("Connection failed - Invalid response from server.");
        }
        this.session = istr.readInt();
        if (this.optDuplex != 1) {
            HttpEndpoint httpEndpoint = this;
            synchronized (httpEndpoint) {
                HttpAltCaller caller = new HttpAltCaller(this.targetHost, this.targetPort, this.proxyAddr, this.proxyPort, this.auth, this);
                this.callers.add(caller);
                caller.start();
                for (int i = 0; i < ALT_PORTS.length; ++i) {
                    if (ALT_PORTS[i] == this.targetPort) continue;
                    caller = this.optRoute == 1 ? new HttpAltCaller(this.targetHost, ALT_PORTS[i], this.proxyAddr, ALT_PORTS[i], this.auth, this) : new HttpAltCaller(this.targetHost, ALT_PORTS[i], this.proxyAddr, this.proxyPort, this.auth, this);
                    this.callers.add(caller);
                    caller.start();
                }
            }
        }
        byte[] authRaw = new byte[DiffieHellman.getChallengeLength()];
        istr.readFully(authRaw);
        String authStr = new String(authRaw);
        this.auth.setResponse(authStr);
        HttpEndpoint httpEndpoint = this;
        synchronized (httpEndpoint) {
            for (HttpAltCaller caller : this.callers) {
                caller.authenticate(this.auth);
            }
        }
        this.mode = istr.readInt();
        switch (this.mode) {
            case 1: {
                if (this.optDuplex == 2) {
                    ep.closeForce();
                    throw new IOException("Unable to establish Full Duplex tunnel.");
                }
                this.inBuf = new CircularBuffer(65536);
                this.inBuf.setExceptionMode(1);
                this.inBuf.setReadTimeout(this.opts.getSoTimeout());
                this.outBuf = new CircularBuffer(65536);
                this.outBuf.setExceptionMode(2);
                this.copyBuf = new byte[4096];
                this.cBoth = new HttpClientConnection(ep, istr, ostr, this.proxy, this.targetHost, this.targetPort, this.session, this.auth, this, this, 1, this.httpVer);
                break;
            }
            case 2: {
                this.cWrite = new HttpClientConnection(ep, istr, ostr, this.proxy, this.targetHost, this.targetPort, this.session, this.auth, this, this, 3, this.httpVer);
                httpEndpoint = this;
                synchronized (httpEndpoint) {
                    long delay;
                    long timeout = System.currentTimeMillis() + 20000L;
                    while ((delay = timeout - System.currentTimeMillis()) > 0L && this.cRead == null) {
                        try {
                            this.wait(delay);
                        }
                        catch (InterruptedException ex) {}
                    }
                    if (this.cRead == null) {
                        throw new InterruptedIOException();
                    }
                    break;
                }
            }
            case -1: {
                ep.closeForce();
                throw new IOException("Connection failed - server error.");
            }
            case -2: {
                ep.closeForce();
                throw new IOException("Connection refused by server.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Endpoint connect(String tHost, int tPort, InetAddress pAddr, int pPort, ProxyAuthenticator auth) throws IOException {
        Endpoint ep = null;
        DataInputStream istr = null;
        DataOutputStream ostr = null;
        boolean connect = true;
        boolean retry = true;
        NetHttpRequest req = null;
        NetHttpResponse resp = null;
        int seq = 0;
        Object object = seqLock;
        synchronized (object) {
            seq = connectSeq++;
        }
        while (retry) {
            int nRead;
            int len;
            if (connect) {
                if (ep != null) {
                    if (NetDebug.HTTP_AUTH.show()) {
                        LogSupport.message(this, "connect", seq + ": disconnecting.");
                    }
                    ep.closeForce();
                }
                if (NetDebug.HTTP_AUTH.show()) {
                    LogSupport.message(this, "connect", seq + ": connecting to " + pAddr + ":" + pPort);
                }
                ep = EndpointCaller.direct(pAddr, pPort);
                istr = new DataInputStream(ep.getInputStream());
                ostr = new DataOutputStream(ep.getOutputStream());
                this.localAddr = ep.getLocalAddress();
                this.localPort = ep.getLocalPort();
                connect = false;
            }
            req = new NetHttpRequest(tHost, tPort, 0, 0, 0, 0, 6, false, this.httpVer);
            auth.authenticate(req);
            if (NetDebug.HTTP_AUTH.show()) {
                LogSupport.message(this, "connect", seq + ": sending ping with auth " + req.getHeader("Proxy-Authorization"));
            }
            req.send(ostr);
            ostr.write("PING\r\n".getBytes());
            resp = new NetHttpResponse(istr);
            if (this.httpVer == 11) {
                if (resp.getCode() == 505) {
                    this.httpVer = 10;
                    retry = true;
                    connect = resp.isDone();
                    continue;
                }
                if (resp.getHTTPVersion() == 10) {
                    this.httpVer = 10;
                }
            }
            retry = auth.checkResponse(resp);
            connect = auth.disconnectRequired();
            if (NetDebug.HTTP_AUTH.show()) {
                LogSupport.message(this, "connect", seq + ": received " + resp.getCode() + " response with auth " + resp.getHeader("Proxy-Authenticate"));
            }
            if (!retry && resp.getCode() != 200) {
                throw new IOException("Connection refused - " + resp.getMessage());
            }
            byte[] buffer = new byte[Math.min(len, 256)];
            for (len = resp.getLength(); len > 0; len -= nRead) {
                int nToRead = Math.min(len, buffer.length);
                nRead = istr.read(buffer, 0, nToRead);
                if (nRead >= 0) continue;
                throw new EOFException();
            }
        }
        return ep;
    }

    int getHttpVersion() {
        return this.httpVer;
    }

    @Override
    public InetAddress getInetAddress() {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        try {
            return InetAddress.getByName(this.targetHost);
        }
        catch (Throwable t) {
            return this.getProxyAddress();
        }
    }

    @Override
    public int getPort() {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        return this.targetPort;
    }

    @Override
    public InetAddress getProxyAddress() {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        return this.proxyAddr;
    }

    @Override
    public int getProxyPort() {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        return this.proxyPort;
    }

    @Override
    public InetAddress getLocalAddress() {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        return this.localAddr;
    }

    @Override
    public int getLocalPort() {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        return this.localPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream() {
        HttpEndpoint httpEndpoint = this;
        synchronized (httpEndpoint) {
            if (this.istr == null) {
                switch (this.mode) {
                    case 1: {
                        this.istr = new QueuedInputStream(this.inBuf);
                        break;
                    }
                    case 2: {
                        this.istr = new ConnectionInputStream(this, this);
                        break;
                    }
                    case -2: {
                        this.istr = new ClosedInputStream();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid endpoint mode " + this.mode);
                    }
                }
                this.userIstr = new PushbackInputStream(this.istr, 64);
            }
        }
        return this.userIstr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStream() {
        HttpEndpoint httpEndpoint = this;
        synchronized (httpEndpoint) {
            if (this.ostr == null) {
                switch (this.mode) {
                    case 1: {
                        this.ostr = new QueuedOutputStream(this.outBuf);
                        break;
                    }
                    case 2: {
                        this.ostr = new ConnectionOutputStream(this);
                        break;
                    }
                    case -2: {
                        this.ostr = new ClosedOutputStream();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid endpoint mode " + this.mode);
                    }
                }
            }
        }
        return this.ostr;
    }

    @Override
    public void setTcpNoDelay(boolean on) {
        this.opts.setTcpNoDelay(on);
    }

    @Override
    public boolean getTcpNoDelay() {
        return this.opts.getTcpNoDelay();
    }

    @Override
    public void setSoLinger(boolean on, int linger) {
        this.opts.setSoLinger(on, linger);
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.opts.getSoLinger();
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.opts.setSoTimeout(timeout);
        if (this.inBuf != null) {
            this.inBuf.setReadTimeout(timeout);
        }
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.opts.getSoTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        HttpEndpoint httpEndpoint = this;
        synchronized (httpEndpoint) {
            HttpConnection c;
            if (this.cBoth != null) {
                this.cBoth.close();
            }
            if (this.cRead != null) {
                c = this.cRead;
                this.readDetach(c, "Connection closed");
                c.close();
            }
            if (this.cWrite != null) {
                c = this.cWrite;
                this.writeDetach(c, "Connection closed");
                c.close();
            }
            if (this.inBuf != null) {
                this.inBuf.close();
            }
            if (this.outBuf != null) {
                this.outBuf.close();
            }
            this.cBoth = null;
            this.cRead = null;
            this.cWrite = null;
            this.inBuf = null;
            this.outBuf = null;
            this.mode = -2;
        }
        this.sendHangup();
    }

    @Override
    public void closeForce() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        boolean closed;
        HttpEndpoint httpEndpoint = this;
        synchronized (httpEndpoint) {
            closed = this.mode == -2;
        }
        return closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        boolean connected;
        HttpEndpoint httpEndpoint = this;
        synchronized (httpEndpoint) {
            connected = this.mode != 0 && this.mode != -1;
        }
        return connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFullDuplex() {
        boolean fd;
        HttpEndpoint httpEndpoint = this;
        synchronized (httpEndpoint) {
            fd = this.mode == 2;
        }
        return fd;
    }

    @Override
    public Socket getSocket() {
        return ProxySocket.getInstance(this);
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return -1;
    }

    @Override
    public void setRecvBufferSize(int size) throws SocketException {
    }

    @Override
    public int getRecvBufferSize() throws SocketException {
        return -1;
    }

    private void sendHangup() throws IOException {
        Endpoint ep = EndpointCaller.direct(this.proxyAddr, this.proxyPort);
        DataInputStream istr = new DataInputStream(ep.getInputStream());
        DataOutputStream ostr = new DataOutputStream(ep.getOutputStream());
        NetHttpRequest req = new NetHttpRequest(this.targetHost, this.targetPort, 0, 6, this.session, this.nextSequenceNo(), DiffieHellman.getKeyLength(), true, this.httpVer);
        ep.setSoTimeout(2000);
        ep.setSoLinger(true, 5);
        this.proxy.authenticate(req);
        req.send(ostr);
        ostr.write(this.auth.getKey(req.getPath()));
        new NetHttpResponse(istr);
        ep.closeForce();
    }

    @Override
    public Object getReadLock() {
        return this.rLock;
    }

    @Override
    public Object getWriteLock() {
        return this.wLock;
    }

    @Override
    public HttpConnection getReadConnection() {
        return this.aRead;
    }

    @Override
    public HttpConnection getWriteConnection() {
        return this.aWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readAttach(HttpConnection c) {
        Endpoint ep = c.getEndpoint();
        Object object = this.rLock;
        synchronized (object) {
            if (this.aRead != null) {
                throw new IllegalStateException();
            }
            this.aRead = c;
            switch (this.mode) {
                case 1: {
                    int nRead;
                    try {
                    }
                    catch (IOException ex) {
                        this.inBuf.post(ex);
                        this.readDetach(c, "Exception " + ex + " in call to available.");
                        return;
                    }
                    for (int len = c.available(); len > 0; len -= nRead) {
                        int nBytes = Math.min(len, this.copyBuf.length);
                        try {
                            nRead = c.read(this.copyBuf, 0, nBytes, 0);
                        }
                        catch (IOException ex) {
                            this.inBuf.post(ex);
                            this.readDetach(c, "Exception " + ex + " in call to read.");
                            return;
                        }
                        if (nRead < 0) {
                            if (this.inBuf != null) {
                                this.inBuf.post(new EOFException());
                            }
                            this.readDetach(c, "EOF returned by call to read.");
                            return;
                        }
                        try {
                            this.inBuf.write(this.copyBuf, 0, nRead);
                            continue;
                        }
                        catch (IOException ex) {
                            LogSupport.exception(this, "readAttach", ex, true);
                            this.readDetach(c, "Exception " + ex + " in call to write.");
                            return;
                        }
                    }
                    if (this.aRead == null) break;
                    this.readDetach(c, "read complete");
                    break;
                }
                case 2: {
                    if (!this.saveOptions(ep, this.rOpts, this.opts)) {
                        this.readDetach(c, "Unable to set endpoint options.");
                        return;
                    }
                    this.getInputStream();
                    this.rLock.notifyAll();
                    while (this.aRead != null) {
                        try {
                            this.rLock.wait();
                        }
                        catch (InterruptedException ex) {
                            this.readDetach(c, "Interrupted while waiting for " + c);
                        }
                    }
                    this.restoreOptions(ep, this.rOpts);
                    break;
                }
                default: {
                    this.readDetach(c, "Invalid state for data transfer.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAttach(HttpConnection c) {
        Endpoint ep = c.getEndpoint();
        Object object = this.wLock;
        synchronized (object) {
            if (this.aWrite != null) {
                throw new IllegalStateException();
            }
            this.aWrite = c;
            switch (this.mode) {
                case 1: {
                    int nRead;
                    try {
                    }
                    catch (IOException ex) {
                        this.outBuf.post(ex);
                        this.writeDetach(c, "Exception " + ex + " during call to available.");
                        return;
                    }
                    for (int len = c.available(); len > 0; len -= nRead) {
                        int nBytes = Math.min(len, this.copyBuf.length);
                        try {
                            nRead = this.outBuf.read(this.copyBuf, 0, nBytes);
                        }
                        catch (IOException ex) {
                            LogSupport.exception(this, "writeAttach", ex, true);
                            this.writeDetach(c, "Exception " + ex + " during call to read.");
                            return;
                        }
                        if (nRead < 0) {
                            this.outBuf.post(new EOFException());
                            this.writeDetach(c, "EOF Returned by read.");
                            return;
                        }
                        try {
                            c.write(this.copyBuf, 0, nRead);
                            continue;
                        }
                        catch (IOException ex) {
                            this.outBuf.post(ex);
                            this.writeDetach(c, "Exception " + ex + " during call to write.");
                            return;
                        }
                    }
                    if (this.aWrite == null) break;
                    this.writeDetach(c, "write complete");
                    break;
                }
                case 2: {
                    if (!this.saveOptions(ep, this.wOpts, this.opts)) {
                        this.writeDetach(c, "Unable to set endpoint options.");
                        return;
                    }
                    this.getOutputStream();
                    this.wLock.notifyAll();
                    while (this.aWrite != null) {
                        try {
                            this.wLock.wait();
                        }
                        catch (InterruptedException ex) {
                            this.writeDetach(c, "Interrupted while waiting for " + c);
                        }
                    }
                    this.restoreOptions(ep, this.wOpts);
                    break;
                }
                default: {
                    this.writeDetach(c, "Invalid state for data transfer.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readDetach(HttpConnection c, String why) {
        Object object = this.rLock;
        synchronized (object) {
            if (c == this.aRead) {
                if (NetDebug.HTTP.show()) {
                    LogSupport.message(this, "detach", "Detached read connection " + c + ": " + why);
                }
                this.aRead = null;
                this.rLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeDetach(HttpConnection c, String why) {
        Object object = this.wLock;
        synchronized (object) {
            if (c == this.aWrite) {
                if (NetDebug.HTTP.show()) {
                    LogSupport.message(this, "detach", "Detached write connection " + c + ": " + why);
                }
                this.aWrite = null;
                this.wLock.notifyAll();
            }
        }
    }

    @Override
    public int writeAvailable() {
        if (this.outBuf == null) {
            return 0;
        }
        return this.outBuf.nBytesReadable();
    }

    @Override
    public void postException(HttpConnection c, IOException ex) {
        if (c == this.aWrite) {
            if (this.outBuf != null) {
                this.outBuf.post(ex);
            }
        } else if (this.inBuf != null) {
            this.inBuf.post(ex);
        }
        this.closeForce();
    }

    public boolean saveOptions(Endpoint ep, EndpointOptions from, EndpointOptions to) {
        try {
            from.get(ep);
            to.set(ep);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean restoreOptions(Endpoint ep, EndpointOptions opt) {
        try {
            opt.set(ep);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    int getSessionID() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void altFailed(HttpAltCaller alt) {
        HttpEndpoint httpEndpoint = this;
        synchronized (httpEndpoint) {
            if (this.callers.remove(alt) && NetDebug.HTTP.show()) {
                LogSupport.message(this, "altFailed", "AltCaller " + alt.getPort() + " failed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void altConnected(HttpAltCaller alt, Endpoint ep, DataInputStream istr, DataOutputStream ostr, ProxyAuthenticator proxy) {
        HttpEndpoint httpEndpoint = this;
        synchronized (httpEndpoint) {
            if (this.cRead == null) {
                this.callers.remove(alt);
                this.cRead = new HttpClientConnection(ep, istr, ostr, proxy, this.targetHost, alt.getPort(), this.session, this.auth, this, this, 2, this.httpVer);
                for (HttpAltCaller caller : this.callers) {
                    caller.abort();
                }
                this.notifyAll();
            } else {
                alt.abort();
            }
        }
    }

    @Override
    public synchronized int nextSequenceNo() {
        return this.sequence++;
    }

    class ClosedInputStream
    extends InputStream {
        ClosedInputStream() {
        }

        @Override
        public int read() throws IOException {
            return -1;
        }
    }

    class ClosedOutputStream
    extends OutputStream {
        ClosedOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            throw new IOException("Stream is closed");
        }
    }
}

