/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.http;

import com.elluminate.net.Endpoint;
import com.elluminate.net.http.HttpConnection;
import com.elluminate.net.http.HttpDataHandler;
import com.elluminate.net.httpCommon.HttpSequenceProvider;
import com.elluminate.net.httpCommon.NetHttpRequest;
import com.elluminate.net.httpCommon.NetHttpResponse;
import com.elluminate.net.httpCommon.ProxyAuthenticator;
import com.elluminate.util.crypto.DiffieHellman;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;

public class HttpClientConnection
extends HttpConnection {
    private String target;
    private int port;
    private int id;
    private DiffieHellman auth;
    private HttpSequenceProvider seq;
    private ProxyAuthenticator proxy;
    private int httpVer;
    private int cMode;
    private boolean readEmpty = true;

    public HttpClientConnection(Endpoint ep, DataInputStream in, DataOutputStream out, ProxyAuthenticator proxy, String target, int port, int id, DiffieHellman auth, HttpDataHandler handler, HttpSequenceProvider seq, int mode, int httpVer) {
        super("HttpClientConnection(" + HttpConnection.getModeName(mode) + ")", ep, in, out);
        this.target = target;
        this.port = port;
        this.id = id;
        this.auth = auth;
        this.handler = handler;
        this.seq = seq;
        this.cMode = mode;
        this.proxy = proxy;
        this.httpVer = httpVer;
        this.setDaemon(true);
        this.start();
    }

    @Override
    protected void init(Endpoint ep, DataInputStream in, DataOutputStream out) {
        try {
            ep.setSoLinger(true, 5);
            ep.setSoTimeout(5000);
            if (this.cMode == 1) {
                NetHttpRequest req = new NetHttpRequest(this.target, this.port, 0, 5, this.id, this.seq.nextSequenceNo(), DiffieHellman.getKeyLength(), false, this.httpVer);
                this.proxy.authenticate(req);
                req.send(out);
                out.write(this.auth.getKey(req.getPath()));
            }
        }
        catch (IOException ex) {
            this.exception = ex;
        }
    }

    @Override
    protected int idle(Endpoint ep, DataInputStream in, DataOutputStream out) {
        switch (this.cMode) {
            case 1: {
                NetHttpResponse resp;
                try {
                    resp = new NetHttpResponse(in);
                    this.proxy.checkResponse(resp);
                }
                catch (IOException ex) {
                    this.handler.postException(this, ex);
                    return -1;
                }
                int code = resp.getCode();
                if (code == 204) {
                    this.nLeft = 0;
                    this.readEmpty = true;
                    if (resp.isDone()) {
                        this.handler.postException(this, new EOFException());
                        return -1;
                    }
                    return this.cMode;
                }
                if (code == 200) {
                    this.readEmpty = false;
                    this.nLeft = resp.getLength();
                    return this.cMode;
                }
                if (code == 404) {
                    this.handler.postException(this, new EOFException());
                    return -1;
                }
                this.handler.postException(this, new IOException("Protocol error - " + resp));
                return -1;
            }
            case 2: {
                NetHttpResponse resp;
                try {
                    NetHttpRequest req = new NetHttpRequest(this.target, this.port, 0, 3, this.id, this.seq.nextSequenceNo(), DiffieHellman.getKeyLength(), false, this.httpVer);
                    this.proxy.authenticate(req);
                    req.send(out);
                    out.write(this.auth.getKey(req.getPath()));
                    resp = new NetHttpResponse(in);
                    this.proxy.checkResponse(resp);
                }
                catch (IOException ex) {
                    this.handler.postException(this, ex);
                    return -1;
                }
                int code = resp.getCode();
                if (code == 204) {
                    this.nLeft = 0;
                    if (resp.isDone()) {
                        this.handler.postException(this, new EOFException());
                        return -1;
                    }
                    return this.cMode;
                }
                if (code == 200) {
                    this.nLeft = resp.getLength();
                    return this.cMode;
                }
                this.handler.postException(this, new IOException("Protocol error - " + resp));
                return -1;
            }
            case 3: {
                try {
                    NetHttpRequest req = new NetHttpRequest(this.target, this.port, 0, 4, this.id, this.seq.nextSequenceNo(), 65536 + DiffieHellman.getKeyLength(), false, this.httpVer);
                    this.proxy.authenticate(req);
                    req.send(out);
                    out.write(this.auth.getKey(req.getPath()));
                    this.nLeft = 65536;
                    return this.cMode;
                }
                catch (IOException ex) {
                    this.handler.postException(this, ex);
                    return -1;
                }
            }
        }
        this.handler.postException(this, new IOException("Illegal state - " + this.cMode));
        return -1;
    }

    @Override
    protected boolean intermission(DataOutputStream out, int len) {
        try {
            if (len == 0) {
                try {
                    if (this.readEmpty) {
                        Thread.sleep(100L);
                    } else {
                        Thread.sleep(20L);
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            NetHttpRequest req = new NetHttpRequest(this.target, this.port, 0, 5, this.id, this.seq.nextSequenceNo(), len + DiffieHellman.getKeyLength(), false, this.httpVer);
            this.proxy.authenticate(req);
            req.send(out);
            out.write(this.auth.getKey(req.getPath()));
            this.nLeft = len;
            return true;
        }
        catch (IOException ex) {
            this.handler.postException(this, ex);
            return false;
        }
    }

    @Override
    protected void epilogue(DataInputStream in, DataOutputStream out) {
        if (this.handler.isClosed()) {
            return;
        }
        if (this.cMode == 3) {
            NetHttpResponse resp;
            try {
                resp = new NetHttpResponse(in);
                this.proxy.checkResponse(resp);
            }
            catch (IOException ex) {
                this.exception = ex;
                this.running = false;
                return;
            }
            int code = resp.getCode();
            if (code != 204) {
                this.handler.postException(this, new IOException("Protocol error - " + resp));
                this.running = false;
            } else if (resp.isDone()) {
                this.handler.postException(this, new EOFException());
                this.running = false;
            }
        }
    }

    @Override
    protected void shutdown(DataInputStream in, DataOutputStream out) {
    }
}

