/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.http;

import com.elluminate.util.log.LogSupport;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.util.LinkedList;

public class CircularBuffer {
    public static final int DONT_THROW = 0;
    public static final int THROW_ON_READ = 1;
    public static final int THROW_ON_WRITE = 2;
    private byte[] buffer = null;
    private int size;
    private int head;
    private int tail;
    private int avail;
    private int timeout;
    private Object lock = new Object();
    private int exceptionMode = 0;
    private LinkedList exceptionQueue = new LinkedList();
    private boolean closeOnDrain = false;
    private BlockedReadHook readHook = null;
    private BlockedWriteHook writeHook = null;
    private String name = "";

    public CircularBuffer(int length) {
        this.size = length;
        this.buffer = new byte[this.size];
        this.head = 0;
        this.tail = 0;
        this.avail = 0;
        this.timeout = 0;
    }

    public void setDiagnosticName(String nm) {
        this.name = nm;
    }

    public void setReadTimeout(int msec) {
        this.timeout = msec;
    }

    public int getReadTimeout() {
        return this.timeout;
    }

    public int getExceptionMode() {
        return this.exceptionMode;
    }

    public void setExceptionMode(int mode) {
        this.exceptionMode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        int value;
        Object object = this.lock;
        synchronized (object) {
            try {
                this.waitNotEmpty();
            }
            catch (EOFException ex) {
                return -1;
            }
            value = this.buffer[this.head++] & 0xFF;
            if (this.head == this.size) {
                this.head = 0;
            }
            if (this.avail-- == this.size) {
                this.lock.notify();
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buf, int off, int len) throws IOException {
        int nRead = 0;
        Object object = this.lock;
        synchronized (object) {
            boolean wasFull = this.avail == this.size;
            try {
                this.waitNotEmpty();
            }
            catch (EOFException ex) {
                return -1;
            }
            nRead = this.copyOut(buf, off, len);
            if (wasFull) {
                this.lock.notify();
            }
        }
        return nRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buf, int off, int len, BlockedReadHook hook) throws IOException {
        BlockedWriteHook writeNotify = null;
        Object iox = null;
        int nRead = 0;
        Object object = this.lock;
        synchronized (object) {
            this.exceptionCheck();
            if (this.avail == 0) {
                this.readHook = hook;
            } else {
                nRead = this.copyOut(buf, off, len);
                writeNotify = this.writeHook;
                this.writeHook = null;
                this.lock.notify();
            }
        }
        if (writeNotify != null) {
            writeNotify.writeAvailable();
        }
        return nRead;
    }

    private int copyOut(byte[] buf, int off, int len) {
        int nRead = 0;
        int nBytes = Math.min(this.avail, len);
        nBytes = Math.min(nBytes, this.size - this.head);
        System.arraycopy(this.buffer, this.head, buf, off, nBytes);
        off += nBytes;
        len -= nBytes;
        this.head += nBytes;
        this.avail -= nBytes;
        nRead += nBytes;
        if (this.head == this.size) {
            this.head = 0;
        }
        if ((nBytes = Math.min(len, this.avail)) > 0) {
            System.arraycopy(this.buffer, this.head, buf, off, nBytes);
            this.head += nBytes;
            this.avail -= nBytes;
            nRead += nBytes;
        }
        return nRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int value) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.waitNotFull();
            this.buffer[this.tail++] = (byte)value;
            if (this.tail == this.size) {
                this.tail = 0;
            }
            if (this.avail++ == 0) {
                this.lock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] buf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            boolean wasEmpty;
            boolean bl = wasEmpty = this.avail == 0;
            while (len > 0 && this.buffer != null) {
                boolean nBytes = false;
                this.waitNotFull();
                int n = this.copyIn(buf, off, len);
                off += n;
                len -= n;
                if (!wasEmpty) continue;
                this.lock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(byte[] buf, int off, int len, BlockedWriteHook hook) throws IOException {
        int nWritten = 0;
        BlockedReadHook readNotify = null;
        Object object = this.lock;
        synchronized (object) {
            this.exceptionCheck();
            if (this.avail == this.size) {
                this.writeHook = hook;
            } else {
                nWritten = this.copyIn(buf, off, len);
                readNotify = this.readHook;
                this.readHook = null;
            }
        }
        if (readNotify != null) {
            readNotify.readAvailable();
        }
        return nWritten;
    }

    private int copyIn(byte[] buf, int off, int len) {
        int nWritten = 0;
        int nBytes = Math.min(this.size - this.avail, len);
        nBytes = Math.min(this.size - this.tail, nBytes);
        System.arraycopy(buf, off, this.buffer, this.tail, nBytes);
        off += nBytes;
        len -= nBytes;
        nWritten += nBytes;
        this.tail += nBytes;
        this.avail += nBytes;
        if (this.tail == this.size) {
            this.tail = 0;
        }
        if ((nBytes = Math.min(this.size - this.avail, len)) > 0) {
            System.arraycopy(buf, off, this.buffer, this.tail, nBytes);
            this.tail += nBytes;
            this.avail += nBytes;
            nWritten += nBytes;
        }
        return nWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nBytesReadable() {
        Object object = this.lock;
        synchronized (object) {
            return this.avail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nBytesWritable() {
        Object object = this.lock;
        synchronized (object) {
            return this.size - this.avail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.exceptionQueue.isEmpty()) {
                this.buffer = null;
                this.lock.notifyAll();
            } else if (this.avail == 0) {
                this.buffer = null;
                this.lock.notifyAll();
            } else {
                this.closeOnDrain = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.lock;
        synchronized (object) {
            return this.buffer == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(IOException ex) {
        BlockedReadHook rhook = null;
        BlockedWriteHook whook = null;
        Object object = this.lock;
        synchronized (object) {
            this.exceptionQueue.addLast(ex);
            this.lock.notifyAll();
            switch (this.exceptionMode) {
                case 1: {
                    rhook = this.readHook;
                    break;
                }
                case 2: {
                    whook = this.writeHook;
                    break;
                }
            }
        }
        try {
            if (rhook != null) {
                rhook.readAvailable();
            }
            if (whook != null) {
                whook.writeAvailable();
            }
        }
        catch (Throwable t) {
            LogSupport.exception(this, "post", t, true);
        }
    }

    private void exceptionCheck() throws IOException {
        if (this.exceptionQueue.isEmpty()) {
            return;
        }
        switch (this.exceptionMode) {
            case 1: {
                if (this.avail != 0) break;
                IOException ex = (IOException)this.exceptionQueue.removeFirst();
                if (this.closeOnDrain) {
                    this.buffer = null;
                    this.closeOnDrain = false;
                }
                throw ex;
            }
            case 2: {
                IOException ex = (IOException)this.exceptionQueue.removeFirst();
                throw ex;
            }
        }
    }

    private void waitNotEmpty() throws IOException {
        this.exceptionCheck();
        if (this.timeout > 0) {
            long now = System.currentTimeMillis();
            long t = now + (long)this.timeout;
            long delay = this.timeout;
            while (this.avail == 0 && delay > 0L && this.buffer != null) {
                try {
                    this.lock.wait(delay);
                    this.exceptionCheck();
                }
                catch (InterruptedException ex) {
                    throw new InterruptedIOException();
                }
                now = System.currentTimeMillis();
                delay = t - now;
            }
        } else {
            while (this.avail == 0 && this.buffer != null) {
                try {
                    this.lock.wait();
                    this.exceptionCheck();
                }
                catch (InterruptedException ex) {
                    throw new InterruptedIOException();
                }
            }
        }
        this.exceptionCheck();
        if (this.buffer == null) {
            throw new EOFException();
        }
        if (this.avail == 0) {
            throw new InterruptedIOException();
        }
    }

    private void waitNotFull() throws IOException {
        this.exceptionCheck();
        while (this.avail == this.size && this.buffer != null && !this.closeOnDrain) {
            try {
                this.lock.wait();
            }
            catch (InterruptedException ex) {
                throw new InterruptedIOException();
            }
        }
        if (!this.exceptionQueue.isEmpty()) {
            IOException ex = (IOException)this.exceptionQueue.removeFirst();
            throw ex;
        }
        if (this.buffer == null || this.closeOnDrain) {
            throw new SocketException("Connection closed");
        }
    }

    public static interface BlockedReadHook {
        public void readAvailable();
    }

    public static interface BlockedWriteHook {
        public void writeAvailable();
    }
}

