/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.direct;

import com.elluminate.net.NetDebug;
import com.elluminate.net.NetTuning;
import com.elluminate.net.ProxyEndpoint;
import com.elluminate.util.log.LogSupport;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class DirectEndpoint
extends ProxyEndpoint {
    public DirectEndpoint(String host, int port) throws UnknownHostException, IOException {
        super(new Socket(Proxy.NO_PROXY));
        this.init(null, new InetSocketAddress(host, port));
    }

    public DirectEndpoint(InetAddress address, int port) throws IOException {
        super(new Socket(Proxy.NO_PROXY));
        this.init(null, new InetSocketAddress(address, port));
    }

    public DirectEndpoint(String host, int port, InetAddress localAddr, int localPort) throws IOException {
        super(new Socket(Proxy.NO_PROXY));
        this.init(new InetSocketAddress(localAddr, localPort), new InetSocketAddress(host, port));
    }

    public DirectEndpoint(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        super(new Socket(Proxy.NO_PROXY));
        this.init(new InetSocketAddress(localAddr, localPort), new InetSocketAddress(address, port));
    }

    private void init(InetSocketAddress bind, InetSocketAddress connect) throws IOException {
        if (NetDebug.CONNECTIONS.show()) {
            LogSupport.message(this, "init", "Connecting to " + connect);
        }
        Socket s = this.getRealSocket();
        if (bind != null) {
            s.bind(bind);
        }
        s.connect(connect);
        this.SYNAuthCheck(bind, connect);
    }

    private void SYNAuthCheck(InetSocketAddress bind, InetSocketAddress connect) throws IOException {
        if (!NetTuning.SynAuth.getBooleanValue()) {
            return;
        }
        int attempts = NetTuning.SynAuthRetries.getIntValue();
        long delay = NetTuning.SynAuthDelay.getLongValue();
        int resetWait = NetTuning.SynAuthRstWait.getIntValue();
        int delayInc = NetTuning.SynAuthDelayInc.getIntValue();
        Socket s = this.getRealSocket();
        int timeout = s.getSoTimeout();
        while (attempts-- > 0) {
            try {
                s.setSoTimeout(resetWait);
                PushbackInputStream istr = (PushbackInputStream)this.getInputStream();
                int data = istr.read();
                if (data >= 0) {
                    istr.unread(data);
                }
                if (NetDebug.CONNECTIONS.show()) {
                    LogSupport.message(this, "SynAuthCheck", connect + ": Data available - continuing.");
                }
                s.setSoTimeout(timeout);
                return;
            }
            catch (SocketTimeoutException stx) {
                if (NetDebug.CONNECTIONS.show()) {
                    LogSupport.message(this, "SynAuthCheck", connect + ": No RST continuing...");
                }
                s.setSoTimeout(timeout);
                return;
            }
            catch (SocketException rst) {
                if (NetDebug.CONNECTIONS.show()) {
                    LogSupport.message(this, "SynAuthCheck", connect + ": " + rst.getMessage() + " - Auth?");
                }
                try {
                    s.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                s = new Socket(Proxy.NO_PROXY);
                this.setSocket(s);
                if (delay > 0L) {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException ix) {
                        // empty catch block
                    }
                    delay += (long)delayInc;
                }
                if (NetDebug.CONNECTIONS.show()) {
                    LogSupport.message(this, "SynAuthCheck", connect + ": Retrying...");
                }
                if (bind != null) {
                    s.bind(bind);
                }
                s.connect(connect);
            }
            catch (IOException iox) {
                return;
            }
        }
    }
}

