/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net;

import com.elluminate.net.ConnectionHandler;
import com.elluminate.net.Endpoint;
import com.elluminate.net.EndpointException;
import com.elluminate.net.NetTuning;
import com.elluminate.net.ProxyEndpoint;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.LinkedList;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class EndpointListener
implements Runnable {
    private int port = 0;
    private InetAddress bindAddr = null;
    private int backlog = 50;
    private int soTimeout = 0;
    private Object lock = new Object();
    private ServerSocket socket = null;
    private LinkedList queue = null;
    private Thread thread = null;
    private LinkedList<ConnectionHandler> handlers = new LinkedList();
    private Executor acceptExec = null;

    public EndpointListener(String protocols, int port) throws IOException {
        this(protocols, port, 50, null);
    }

    public EndpointListener(String protocols, int port, int backlog) throws IOException {
        this(protocols, port, backlog, null);
    }

    public EndpointListener(String protocols, int port, int backlog, InetAddress bindAddr) throws IOException {
        this.port = port;
        this.bindAddr = bindAddr;
        this.backlog = backlog;
        this.parseProtocols(protocols);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint accept() throws IOException {
        ServerSocket direct = this.socket;
        LinkedList indirect = this.queue;
        if (indirect != null) {
            Object obj = null;
            LinkedList linkedList = indirect;
            synchronized (linkedList) {
                long timeoutAt = this.soTimeout <= 0 ? -1L : System.currentTimeMillis() + (long)(this.soTimeout * 1000);
                while (indirect.isEmpty()) {
                    if (timeoutAt > 0L) {
                        long now = System.currentTimeMillis();
                        long delay = timeoutAt - now;
                        if (delay <= 0L) {
                            throw new InterruptedIOException();
                        }
                        try {
                            indirect.wait(delay);
                            continue;
                        }
                        catch (InterruptedException ex) {
                            throw new InterruptedIOException();
                        }
                    }
                    try {
                        indirect.wait();
                    }
                    catch (InterruptedException ex) {
                        throw new InterruptedIOException();
                    }
                }
                obj = indirect.removeFirst();
            }
            if (obj instanceof IOException) {
                throw (IOException)obj;
            }
            if (obj instanceof Endpoint) {
                return obj;
            }
            throw new IllegalStateException("Invalid object in EndpointListener queue.");
        }
        if (direct != null) {
            Socket s = direct.accept();
            return new ProxyEndpoint(s);
        }
        throw new SocketException("Socket is closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        boolean closed = false;
        Object object = this.lock;
        synchronized (object) {
            closed = this.socket == null && this.queue == null;
        }
        return closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.socket = null;
            }
            if (this.queue != null) {
                LinkedList linkedList = this.queue;
                synchronized (linkedList) {
                    this.queue.addFirst(new SocketException("Socket is closed"));
                    this.queue.notifyAll();
                    this.queue = null;
                }
            }
            if (this.thread != null) {
                this.thread.interrupt();
                this.thread = null;
            }
        }
    }

    public void closeForce() {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSoTimeout(int timeout) throws SocketException {
        Object object = this.lock;
        synchronized (object) {
            this.soTimeout = timeout;
            if (this.socket != null) {
                this.socket.setSoTimeout(timeout);
            }
        }
    }

    public int getLocalPort() {
        return this.port;
    }

    public InetAddress getInetAddress() {
        return this.bindAddr;
    }

    public static boolean isTunnelMethodAvailable(String name) {
        return EndpointListener.getConnectionHandler(name) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseProtocols(String protocols) throws IOException {
        StringTokenizer parser = new StringTokenizer(protocols, ",");
        boolean direct = true;
        String universalName = null;
        ConnectionHandler universalHandler = null;
        while (parser.hasMoreTokens()) {
            ConnectionHandler handler;
            String token = parser.nextToken().trim();
            if (!token.equalsIgnoreCase("Direct")) {
                direct = false;
            }
            if ((handler = EndpointListener.getConnectionHandler(token)) == null) {
                throw new EndpointException("Handler for protocol '" + token + "' not found.");
            }
            if (handler.isUniversal()) {
                if (universalHandler != null) {
                    throw new EndpointException("Only one of '" + token + "' and '" + universalName + "' may be specified as " + "tunneling methods, as both " + "will accept ANY connection.");
                }
                universalHandler = handler;
                universalName = token;
                continue;
            }
            this.handlers.addLast(handler);
        }
        if (universalHandler != null) {
            this.handlers.addLast(universalHandler);
        }
        Object object = this.lock;
        synchronized (object) {
            this.socket = new ServerSocket(this.port, this.backlog, this.bindAddr);
            this.bindAddr = this.socket.getInetAddress();
            this.port = this.socket.getLocalPort();
            if (!direct) {
                this.acceptExec = new ThreadPoolExecutor(1, NetTuning.DOSAcceptPoolMax.getIntValue(), NetTuning.DOSAcceptPoolTimeout.getLongValue(), TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(NetTuning.DOSAcceptBacklog.getIntValue()));
                this.queue = new LinkedList();
                this.thread = new Thread(this);
                this.thread.setDaemon(true);
                this.thread.setPriority(5);
                this.thread.start();
            }
        }
    }

    private static ConnectionHandler getConnectionHandler(String method) {
        ConnectionHandler handler;
        Class<?> hClass;
        String name = method.substring(0, 1).toUpperCase(Locale.ENGLISH) + method.substring(1).toLowerCase(Locale.ENGLISH);
        String hPath = "com.elluminate.net." + name.toLowerCase(Locale.ENGLISH) + "." + name + "ConnectionHandler";
        try {
            hClass = Class.forName(hPath);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        try {
            handler = (ConnectionHandler)hClass.newInstance();
        }
        catch (Exception ex) {
            return null;
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ServerSocket mySocket = this.socket;
        final LinkedList myQueue = this.queue;
        if (myQueue == null) {
            return;
        }
        while (!this.isClosed()) {
            Object object;
            Socket s = null;
            try {
                s = mySocket.accept();
            }
            catch (InterruptedIOException stx) {
                object = myQueue;
                synchronized (object) {
                    myQueue.addLast(stx);
                    myQueue.notifyAll();
                    continue;
                }
            }
            catch (IOException ex) {
                object = myQueue;
                synchronized (object) {
                    myQueue.addLast(ex);
                    myQueue.notifyAll();
                }
                object = this.lock;
                synchronized (object) {
                    this.queue = null;
                    this.thread = null;
                }
                return;
            }
            final ProxyEndpoint ep = new ProxyEndpoint(s);
            try {
                this.acceptExec.execute(new Runnable(){

                    @Override
                    public void run() {
                        Endpoint endpoint = ep;
                        LinkedList queue = myQueue;
                        for (ConnectionHandler h : EndpointListener.this.handlers) {
                            if (!h.check(endpoint)) continue;
                            h.accept(endpoint, queue);
                            endpoint = null;
                            break;
                        }
                        if (endpoint != null) {
                            endpoint.closeForce();
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                ep.closeForce();
            }
        }
    }
}

