/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net;

import com.elluminate.net.Endpoint;
import com.elluminate.net.NetDebug;
import com.elluminate.net.NetTuning;
import com.elluminate.util.CircularWorkQueue;
import com.elluminate.util.WorkerPool;
import com.elluminate.util.log.LogSupport;
import java.net.SocketException;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;

public class DOSWatchdog
implements Runnable {
    private static Object lock;
    private static TreeMap<Long, Set<DOSWatchdog>> byTime;
    private static WDThread watchdog;
    private static long timeout;
    private static int count;
    private static CircularWorkQueue attackQueue;
    private static WorkerPool attackPool;
    private static long nextID;
    private final Endpoint endpoint;
    private final long startTime;
    private final long id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DOSWatchdog(Endpoint ep) {
        this.endpoint = ep;
        this.startTime = System.currentTimeMillis();
        Object object = lock;
        synchronized (object) {
            this.id = nextID++;
        }
        if (NetDebug.DOS_WATCHDOG.show()) {
            LogSupport.message("Watching connection " + this.id + " from " + ep.getInetAddress());
        }
        this.insert();
    }

    public void leash() {
        this.remove();
    }

    static void shutdown() {
        attackPool.shutdown();
    }

    @Override
    public void run() {
        LogSupport.error(this, "run", "Terminating connection " + this.id + " from " + this.endpoint.getInetAddress() + " on watchdog timeout (" + (System.currentTimeMillis() - this.startTime) + "ms).");
        try {
            this.endpoint.setSoLinger(false, 0);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        this.endpoint.closeForce();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert() {
        Object object = lock;
        synchronized (object) {
            Set<DOSWatchdog> slot = byTime.get(this.startTime);
            if (slot == null) {
                slot = new HashSet<DOSWatchdog>();
                byTime.put(this.startTime, slot);
            }
            slot.add(this);
            DOSWatchdog.updateTimeout(++count == 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove() {
        Object object = lock;
        synchronized (object) {
            boolean update = false;
            Set<DOSWatchdog> slot = byTime.get(this.startTime);
            if (slot != null) {
                update = slot.remove(this);
                if (slot.isEmpty()) {
                    byTime.remove(this.startTime);
                }
            }
            if (update) {
                DOSWatchdog.updateTimeout(--count == 0);
            }
        }
    }

    private static void updateTimeout(boolean force) {
        if (watchdog == null) {
            watchdog = new WDThread();
            watchdog.start();
        }
        long computed = timeout;
        boolean update = false;
        boolean notify = force;
        int min = NetTuning.DOSTimeoutMin.getIntValue();
        int max = NetTuning.DOSTimeoutMax.getIntValue();
        int step = NetTuning.DOSTimeoutStep.getIntValue();
        int threshold = NetTuning.DOSTimeoutThreshold.getIntValue();
        int limit = NetTuning.DOSTimeoutLimit.getIntValue();
        if (count < threshold) {
            computed = max;
            update = true;
        } else if (count >= limit) {
            computed = min;
            update = true;
        } else {
            long n = count - threshold;
            long tRange = max - min;
            long nRange = limit - threshold;
            computed = (long)max - n * tRange / nRange;
            if (Math.abs(computed - timeout) >= (long)step) {
                update = true;
            }
        }
        if (update) {
            if (NetDebug.DOS_WATCHDOG.show()) {
                LogSupport.log("Changing DOS watchdog timeout from " + timeout + "ms to " + computed + "ms with " + count + " connections.");
            }
            timeout = computed;
            notify = true;
        }
        if (notify) {
            lock.notify();
        }
    }

    static /* synthetic */ Object access$000() {
        return lock;
    }

    static /* synthetic */ TreeMap access$100() {
        return byTime;
    }

    static /* synthetic */ long access$200() {
        return timeout;
    }

    static /* synthetic */ int access$320(int x0) {
        return count -= x0;
    }

    static /* synthetic */ CircularWorkQueue access$400() {
        return attackQueue;
    }

    static {
        watchdog = null;
        count = 0;
        nextID = 1L;
        lock = new Object();
        byTime = new TreeMap();
        timeout = NetTuning.DOSTimeoutMax.getIntValue();
        attackQueue = new CircularWorkQueue(32);
        attackPool = new WorkerPool("DOS hangup pool", attackQueue);
    }

    static class WDThread
    extends Thread {
        public WDThread() {
            super("DOS Watchdog Thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block5: while (true) {
                now = System.currentTimeMillis();
                slot = null;
                var4_3 = DOSWatchdog.access$000();
                synchronized (var4_3) {
                    try {
                        if (DOSWatchdog.access$100().isEmpty()) {
                            DOSWatchdog.access$000().wait();
                        } else {
                            start = (Long)DOSWatchdog.access$100().firstKey();
                            limit = start + DOSWatchdog.access$200();
                            delay = limit - now;
                            if (delay > 0L) {
                                DOSWatchdog.access$000().wait(delay);
                            } else {
                                slot = (Set)DOSWatchdog.access$100().remove(start);
                                if (slot != null) {
                                    DOSWatchdog.access$320(slot.size());
                                }
                            }
                        }
                    }
                    catch (InterruptedException ix) {
                        LogSupport.exception(this, "run", ix, true, "Unexpected interrupted exception in DOS timeout thread.");
                    }
                }
                if (slot == null) continue;
                i$ = slot.iterator();
                while (true) {
                    if (i$.hasNext()) ** break;
                    continue block5;
                    dog = (DOSWatchdog)i$.next();
                    DOSWatchdog.access$400().execute(dog);
                }
                break;
            }
        }
    }
}

