/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net;

import com.elluminate.net.AsyncConnectionListener;
import com.elluminate.net.AsyncEndpointSecurity;
import com.elluminate.net.NetDebug;
import com.elluminate.net.ThreadedAsyncServerEndpoint;
import com.elluminate.platform.Platform;
import java.io.IOException;
import java.net.InetAddress;

public abstract class AsyncServerEndpoint {
    private static final String NIO_IMPL = "com.elluminate.net.nio.SelectorAsyncServerEndpoint";
    protected int port = -1;
    protected InetAddress bindAddr = null;
    protected int backlog = -1;
    protected AsyncConnectionListener listener = null;

    public static AsyncServerEndpoint getInstance() {
        AsyncServerEndpoint asep = null;
        try {
            if (NetDebug.ASYNC_NO_NIO.isEnabled()) {
                throw new RuntimeException("NIO Async IO disabled");
            }
            if (Platform.checkJavaVersion("1.4*") && AsyncEndpointSecurity.isEnabled()) {
                throw new RuntimeException("NIO/SSL unavailable in 1.4");
            }
            Class<?> selAsep = Class.forName(NIO_IMPL);
            asep = (AsyncServerEndpoint)selAsep.newInstance();
            return asep;
        }
        catch (Throwable t) {
            if (NetDebug.ASYNC_NO_THREAD.isEnabled()) {
                throw new RuntimeException("Thread Async IO disabled");
            }
            asep = new ThreadedAsyncServerEndpoint();
            return asep;
        }
    }

    public void bind(String methods, int port, AsyncConnectionListener acl) throws IOException {
        this.bind(methods, port, 50, null, acl);
    }

    public void bind(String methods, int port, int backlog, AsyncConnectionListener acl) throws IOException {
        this.bind(methods, port, backlog, null, acl);
    }

    public void bind(String methods, int port, int backlog, InetAddress bindAddr, AsyncConnectionListener acl) throws IOException {
        if (backlog < 1) {
            throw new IllegalArgumentException("Negative backlog");
        }
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("invalid port.");
        }
        this.port = port;
        this.bindAddr = bindAddr;
        this.backlog = backlog;
        this.listener = acl;
        this.parseProtocols(methods);
    }

    public boolean isOpen() {
        return this.port > 0;
    }

    public abstract void beginClose();

    public int getLocalPort() {
        return this.port;
    }

    public InetAddress getInetAddress() {
        return this.bindAddr;
    }

    protected abstract void parseProtocols(String var1) throws IOException;
}

