/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.browser.proxy;

import com.elluminate.browser.BrowserPaneImpl;
import com.elluminate.browser.BrowserPaneImplAdapter;
import com.elluminate.browser.proxy.Message;
import com.elluminate.browser.proxy.ProxyDebug;
import com.elluminate.browser.proxy.ProxyManager;
import com.elluminate.browser.proxy.ProxyMsgHandler;
import com.elluminate.gui.GuiUtils;
import com.elluminate.platform.Platform;
import com.elluminate.util.Resource;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

public class ProxyBrowserPaneImpl
extends BrowserPaneImplAdapter
implements BrowserPaneImpl,
ProxyMsgHandler {
    static ProxyManager mgr;
    static boolean available;
    private static final String HELPER = "eLiveBrowser.exe";
    private Canvas canvas;
    private Object handle;
    private short slot = (short)-1;
    private boolean popupSuppression = true;
    private Object stateLock = new Object();
    private String stCurrent = null;
    private String stNavigatingTo = null;
    private LinkedList stFrameContents = new LinkedList();
    private LinkedList stPending = new LinkedList();
    private boolean stIsNavigating = false;
    private final Runnable repaintAction;

    public ProxyBrowserPaneImpl() {
        if (!available || !GuiUtils.hasWindowHandles()) {
            throw new RuntimeException("ProxyBrowserPane is not available.");
        }
        this.repaintAction = new Runnable(){

            @Override
            public void run() {
                if (ProxyBrowserPaneImpl.this.canvas != null) {
                    ProxyBrowserPaneImpl.this.canvas.invalidate();
                }
            }
        };
        this.canvas = new Canvas(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addNotify() {
                super.addNotify();
                Object object = ProxyBrowserPaneImpl.this.stateLock;
                synchronized (object) {
                    ProxyBrowserPaneImpl.this.slot = mgr.acquireSlot(ProxyBrowserPaneImpl.this);
                    ProxyBrowserPaneImpl.this.handle = GuiUtils.getWindowHandle((Component)ProxyBrowserPaneImpl.this.canvas);
                    if (ProxyDebug.POPUPS.show()) {
                        LogSupport.message((Object)this, (String)"canvas.addNotify", (String)("popupSuppression: " + ProxyBrowserPaneImpl.this.popupSuppression));
                    }
                    Message msg = new Message(257, ProxyBrowserPaneImpl.this.slot, ProxyBrowserPaneImpl.this.handle, ProxyBrowserPaneImpl.this.popupSuppression);
                    mgr.transmit(msg);
                    ProxyBrowserPaneImpl.this.sendPending();
                }
            }
        };
        this.canvas.addComponentListener(new ComponentListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void componentResized(ComponentEvent e) {
                Object object = ProxyBrowserPaneImpl.this.stateLock;
                synchronized (object) {
                    if (ProxyBrowserPaneImpl.this.slot >= 0) {
                        Message msg = new Message(260, ProxyBrowserPaneImpl.this.slot, new Integer(ProxyBrowserPaneImpl.this.canvas.getWidth()), new Integer(ProxyBrowserPaneImpl.this.canvas.getHeight()));
                        mgr.transmit(msg);
                    }
                }
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    @Override
    public Component getComponent() {
        return this.canvas;
    }

    @Override
    public boolean hasFrameSupport() {
        return true;
    }

    @Override
    public void openURL(String url) {
        this.openURL(null, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openURL(String frame, String url) {
        if (frame == null) {
            frame = "";
        }
        boolean main = frame.equals("");
        Object object = this.stateLock;
        synchronized (object) {
            if (this.stIsNavigating && !main || this.slot < 0) {
                if (main) {
                    this.stPending.clear();
                }
                if (ProxyDebug.NAVIGATION.show()) {
                    LogSupport.message((Object)this, (String)"openURL", (String)("Pending navigate to '" + url + "' in '" + frame + "'"));
                }
                this.stPending.addLast(new Pair(frame, url));
            } else {
                if (main) {
                    this.stCurrent = url;
                    this.stFrameContents.clear();
                    this.stPending.clear();
                    this.stIsNavigating = true;
                    this.stNavigatingTo = null;
                } else {
                    ProxyBrowserPaneImpl.stInsert(this.stFrameContents, frame, url);
                }
                if (ProxyDebug.NAVIGATION.show()) {
                    LogSupport.message((Object)this, (String)"openURL", (String)("Navigate to '" + url + "' in '" + frame + "'"));
                }
                Message msg = new Message(513, this.slot, frame, url);
                mgr.transmit(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void goForward() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.slot >= 0) {
                mgr.transmit(new Message(515, this.slot));
                this.stIsNavigating = true;
            }
            this.stFrameContents.clear();
            this.stPending.clear();
            this.stNavigatingTo = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void goBack() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.slot >= 0) {
                mgr.transmit(new Message(514, this.slot));
                this.stIsNavigating = true;
            }
            this.stFrameContents.clear();
            this.stPending.clear();
            this.stNavigatingTo = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.slot >= 0) {
                mgr.transmit(new Message(516, this.slot));
                mgr.transmit(new Message(513, this.slot, "", "about:blank"));
                this.stIsNavigating = true;
            }
            this.stCurrent = null;
            this.stFrameContents.clear();
            this.stNavigatingTo = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        ProxyBrowserPaneImpl.shutdown();
        Object object = this.stateLock;
        synchronized (object) {
            if (this.slot >= 0) {
                mgr.transmit(new Message(259, this.slot));
                mgr.releaseSlot(this, this.slot);
                this.slot = (short)-1;
                this.stCurrent = null;
            }
        }
    }

    @Override
    public void repaintContent() {
        SwingRunnerSupport.invokeOnEventThread((Runnable)this.repaintAction);
    }

    @Override
    public boolean isPropertySupported(String prop) {
        if ("browser.popups".equals(prop)) {
            return true;
        }
        return super.isPropertySupported(prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String prop, Object val) {
        Object object = this.propsLock;
        synchronized (object) {
            if ("browser.popups".equals(prop)) {
                Object object2 = this.stateLock;
                synchronized (object2) {
                    this.setPopupSuppression((Boolean)val);
                }
            }
            super.setProperty(prop, val);
        }
    }

    @Override
    public byte getInitState() {
        if (available) {
            return 1;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Message msg) {
        switch (msg.getMessageID()) {
            case 258: {
                if (this.stCurrent != null) {
                    Message m2 = new Message(513, this.slot, "", this.stCurrent);
                    mgr.transmit(m2);
                }
                Message bounds = new Message(260, this.slot, new Integer(this.canvas.getWidth()), new Integer(this.canvas.getHeight()));
                mgr.transmit(bounds);
                break;
            }
            case 511: {
                break;
            }
            case 767: {
                break;
            }
            case 255: {
                available = false;
                break;
            }
            case 773: {
                this.fireSetBackEnabled(msg.getBool(0));
                break;
            }
            case 774: {
                this.fireSetFwdEnabled(msg.getBool(0));
                break;
            }
            case 769: {
                String frame = msg.getString(0);
                String url = msg.getString(1);
                if (url.startsWith("res:")) {
                    int index = url.indexOf("http");
                    if (index > 0) {
                        url = url.substring(index);
                        this.fireSetCurrentURL(url);
                    } else {
                        this.fireSetCurrentURL(" ");
                    }
                    return;
                }
                if (url.startsWith("javascript:")) {
                    return;
                }
                if (frame == null || frame.equals("")) {
                    frame = null;
                }
                if (ProxyDebug.NAVIGATION.show()) {
                    LogSupport.message((Object)this, (String)"onMessage", (String)("Notify: '" + url + "' in '" + frame + "'"));
                }
                if (frame == null) {
                    this.fireOnNavigate(url);
                    this.fireSetCurrentURL(url);
                    Object object = this.stateLock;
                    synchronized (object) {
                        this.stNavigatingTo = url;
                        this.stCurrent = url;
                        break;
                    }
                }
                this.fireOnNavigate(frame, url);
                break;
            }
            case 770: {
                Object object = this.stateLock;
                synchronized (object) {
                    String url = msg.getString(0);
                    if (ProxyDebug.NAVIGATION.show()) {
                        LogSupport.message((Object)this, (String)"onMessage", (String)("Completed '" + url + "'"));
                    }
                    if (this.stIsNavigating && url.equals(this.stNavigatingTo)) {
                        this.stIsNavigating = false;
                        this.sendPending();
                    }
                    break;
                }
            }
            case 1023: {
                break;
            }
            case 771: {
                break;
            }
            case 772: {
                this.fireSetPageTitle(msg.getString(0));
                break;
            }
        }
        this.resetKeyboardFocus();
    }

    private void sendPending() {
        while (!this.stPending.isEmpty() && this.slot >= 0) {
            Pair p = (Pair)this.stPending.removeFirst();
            if (ProxyDebug.NAVIGATION.show()) {
                LogSupport.message((Object)this, (String)"sendPending", (String)("navigate to '" + p.url + "' in '" + p.frm + "'"));
            }
            Message m = new Message(513, this.slot, p.frm, p.url);
            mgr.transmit(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReconnect() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.handle == null) {
                return;
            }
            if (ProxyDebug.HELPER.show()) {
                LogSupport.message((Object)this, (String)"onReconnect", (String)("reconnecting slot " + this.slot));
            }
            Message msg = new Message(257, this.slot, this.handle);
            mgr.transmit(msg);
            msg = new Message(260, this.slot, new Integer(this.canvas.getWidth()), new Integer(this.canvas.getHeight()));
            mgr.transmit(msg);
            boolean pushContents = false;
            if (this.stPending.isEmpty()) {
                pushContents = true;
            } else {
                Pair p = (Pair)this.stPending.getFirst();
                pushContents = !p.frm.equals("");
            }
            if (pushContents &= this.stCurrent != null) {
                msg = new Message(513, this.slot, "", this.stCurrent);
                mgr.transmit(msg);
                this.stIsNavigating = true;
                this.stNavigatingTo = null;
                LinkedList newPending = (LinkedList)this.stFrameContents.clone();
                for (Pair p : this.stPending) {
                    ProxyBrowserPaneImpl.stInsert(newPending, p.frm, p.url);
                }
                this.stPending = newPending;
            }
        }
    }

    private static void stInsert(LinkedList l, String frm, String url) {
        Iterator i = l.iterator();
        while (i.hasNext()) {
            Pair p = (Pair)i.next();
            if (!frm.equals(p.frm)) continue;
            i.remove();
            p.url = url;
            l.addLast(p);
            return;
        }
        l.addLast(new Pair(frm, url));
    }

    public static void shutdown() {
        mgr.shutdown();
    }

    private void setPopupSuppression(boolean suppress) {
        if (ProxyDebug.POPUPS.show()) {
            LogSupport.message((Object)this, (String)"setPopupSuppression", (String)("suppress=" + suppress));
        }
        this.popupSuppression = suppress;
        if (this.slot >= 0) {
            Message msg = new Message(261, this.slot, suppress);
            mgr.transmit(msg);
        }
    }

    private void resetKeyboardFocus() {
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                mgr.clearGlobalFocusOwner();
                if (ProxyDebug.KEYBOARD_FOCUS.show()) {
                    Component focusOwner = mgr.getFocusOwner();
                    String focusOwnerStr = "(none)";
                    if (focusOwner != null) {
                        focusOwnerStr = focusOwner.toString();
                    }
                    Window focusActiveWindow = mgr.getActiveWindow();
                    String focusActiveWindowStr = "(none)";
                    if (focusActiveWindow != null) {
                        focusActiveWindowStr = focusActiveWindow.toString();
                    }
                    Window focusedWindow = mgr.getFocusedWindow();
                    String focusedWindowStr = "(none)";
                    if (focusedWindow != null) {
                        focusedWindowStr = focusedWindow.toString();
                    }
                    Component permanentFocusOwner = mgr.getPermanentFocusOwner();
                    String permanentFocusOwnerStr = "(none)";
                    if (permanentFocusOwner != null) {
                        permanentFocusOwnerStr = permanentFocusOwner.toString();
                    }
                    LogSupport.message((String)("RESET KEYBOARD FOCUS:  FocusOwner[" + focusOwnerStr + "]\n" + "                               ActiveWindow[" + focusActiveWindowStr + "]\n" + "                               FocusedWindow[" + focusedWindowStr + "]\n" + "                               PermanentFocusOwner[" + permanentFocusOwnerStr + "]"));
                }
            }
        });
    }

    static {
        available = false;
        try {
            File helper;
            block7: {
                Object context = new Object(){};
                Resource rsrc = new Resource(context, HELPER);
                if (!rsrc.exists()) {
                    throw new RuntimeException();
                }
                File tmpDir = Platform.getTempDir();
                helper = null;
                File exeDir = null;
                for (int i = 0; i < 9; ++i) {
                    File subdir = new File(tmpDir, "eLiveBrowser" + i + ".tmp");
                    if (subdir.exists() && subdir.isDirectory()) {
                        helper = new File(subdir, HELPER);
                        helper.delete();
                    }
                    subdir.delete();
                    if (exeDir != null || subdir.exists()) continue;
                    exeDir = subdir;
                }
                exeDir.mkdir();
                helper = new File(exeDir, HELPER);
                try {
                    rsrc.save(helper.getPath());
                    helper.deleteOnExit();
                }
                catch (IOException ex) {
                    if (helper.length() == (long)rsrc.length()) break block7;
                    throw ex;
                }
            }
            mgr = new ProxyManager(helper);
            available = mgr.isAvailable();
        }
        catch (Throwable t) {
            available = false;
        }
    }

    static class Pair {
        public String frm;
        public String url;

        public Pair(String f, String u) {
            this.frm = f;
            this.url = u;
        }
    }
}

