/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.browser.macosx;

import com.elluminate.browser.BrowserDebug;
import com.elluminate.browser.BrowserPaneImpl;
import com.elluminate.browser.NavigationListener;
import com.elluminate.browser.UIListener;
import com.elluminate.browser.macosx.WebKitComponent;
import com.elluminate.platform.Platform;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class WebKitContainer
extends JPanel
implements BrowserPaneImpl {
    private static final String OVERRIDE_PROPERTY = "com.elluminate.elive.webkit.ignorePlugins";
    private static final boolean HAS_PLUGINS;
    private volatile long webKitView = 0L;
    private final WebKitComponent browserPane;
    private JComponent wrapper = null;

    public WebKitContainer() {
        super(new BorderLayout());
        if (!WebKitComponent.isAvailable()) {
            throw new RuntimeException("Embedded WebKit browser is not available.");
        }
        if (!HAS_PLUGINS) {
            throw new RuntimeException("No plugins available, embedded WebKit browser disabled.");
        }
        this.browserPane = new WebKitComponent();
        WorkerThread creatorThread = new WorkerThread("WebKit Component Creator"){

            public void run() {
                WebKitContainer.this.webKitView = WebKitComponent.createViewOnMainThread();
                Runnable adder = new Runnable(){

                    @Override
                    public void run() {
                        WebKitContainer.this.createComponent();
                    }
                };
                SwingRunnerSupport.invokeLater((Runnable)adder);
            }
        };
        creatorThread.start();
    }

    private void createComponent() {
        if (this.webKitView == 0L) {
            throw new RuntimeException("No native WebKitView");
        }
        if (BrowserDebug.WEBKIT.show()) {
            LogSupport.message((Object)this, (String)"createComponent", (String)("Attaching WebKitComponent to view " + this.webKitView));
        }
        this.browserPane.setNativeView(this.webKitView);
        this.add((Component)((Object)this.browserPane), "Center");
        this.revalidate();
        this.repaint();
    }

    @Override
    public void addNavigationListener(NavigationListener l) {
        this.browserPane.addNavigationListener(l);
    }

    @Override
    public void removeNavigationListener(NavigationListener l) {
        this.browserPane.removeNavigationListener(l);
    }

    @Override
    public void addUIListener(UIListener l) {
        this.browserPane.addUIListener(l);
    }

    @Override
    public void removeUIListener(UIListener l) {
        this.browserPane.removeUIListener(l);
    }

    @Override
    public Component getComponent() {
        if (this.wrapper == null) {
            JScrollPane scroller = new JScrollPane(this, 21, 31);
            scroller.setBorder(null);
            this.wrapper = scroller;
            scroller.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent ev) {
                    if (WebKitContainer.this.browserPane != null) {
                        WebKitContainer.this.browserPane.repaintContent();
                    }
                }
            });
        }
        return this.wrapper;
    }

    @Override
    public void openURL(String url) {
        this.browserPane.openURL(url);
    }

    @Override
    public void goForward() {
        this.browserPane.goForward();
    }

    @Override
    public void goBack() {
        this.browserPane.goBack();
    }

    @Override
    public void stop() {
        this.browserPane.stop();
    }

    @Override
    public void dispose() {
        this.browserPane.dispose();
    }

    @Override
    public byte getInitState() {
        return this.browserPane.getInitState();
    }

    @Override
    public boolean hasFrameSupport() {
        return this.browserPane.hasFrameSupport();
    }

    @Override
    public void openURL(String frame, String url) {
        this.browserPane.openURL(frame, url);
    }

    @Override
    public void repaintContent() {
        this.browserPane.repaintContent();
    }

    @Override
    public boolean isPropertySupported(String prop) {
        return false;
    }

    @Override
    public void setProperty(String prop, Object val) {
    }

    @Override
    public Object getProperty(String prop) {
        return null;
    }

    private static boolean has64BitPlugins() {
        return Boolean.getBoolean(OVERRIDE_PROPERTY);
    }

    static {
        boolean SNOW_LEOPARD;
        HAS_PLUGINS = Platform.is64BitAddressable() ? ((SNOW_LEOPARD = Platform.checkOSVersion((int)202, (String)"10.6+")) ? true : WebKitContainer.has64BitPlugins()) : true;
    }
}

