/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.browser.macosx;

import com.elluminate.browser.BrowserDebug;
import com.elluminate.browser.BrowserPaneImplAdapter;
import com.elluminate.browser.macosx.BrowserHistory;
import com.elluminate.platform.PlatformIssues;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.SerializerThread;
import com.elluminate.util.log.LogSupport;
import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.BrowserFactory;
import com.teamdev.jxbrowser.NewWindowContainer;
import com.teamdev.jxbrowser.NewWindowManager;
import com.teamdev.jxbrowser.NewWindowParams;
import com.teamdev.jxbrowser.events.NavigationEvent;
import com.teamdev.jxbrowser.events.NavigationFinishedEvent;
import com.teamdev.jxbrowser.events.NavigationListener;
import java.awt.Component;

public class JxBrowserContainer
extends BrowserPaneImplAdapter {
    private static final int HISTORY_WAIT = 1000;
    private boolean initialized = false;
    private Browser browser = null;
    private NavigationListener jxNavListener;
    private static NewWindowManager jxWindowManager = null;
    private byte state = 0;
    private BrowserHistory history = new BrowserHistory();
    private String lastUrl = "";
    private LightweightTimer historyTimer = null;
    private SerializerThread helperThread = new SerializerThread("Web Tour Serializer");

    private void init() {
        this.jxNavListener = new NavigationListener(){

            public void navigationStarted(NavigationEvent evt) {
            }

            public void navigationFinished(NavigationFinishedEvent evt) {
                final String url = evt.getUrl();
                if (PlatformIssues.JWS_HAS_MULTIPLE_CONTEXTS) {
                    JxBrowserContainer.this.helperThread.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JxBrowserContainer.this.handleNavigateFinished(url);
                        }
                    });
                    return;
                }
                JxBrowserContainer.this.handleNavigateFinished(url);
            }
        };
        try {
            this.browser = BrowserFactory.createBrowser();
        }
        catch (Exception e) {
            LogSupport.error((Object)this, (String)"init", (String)("Unable to load browser: " + e.getMessage()));
            this.state = (byte)-1;
            return;
        }
        if (this.browser == null) {
            this.state = (byte)-1;
            return;
        }
        this.state = 1;
        this.setupNavigationListener();
        this.setupPopupListener();
        this.initialized = true;
    }

    private void setupPopupListener() {
        if (jxWindowManager == null) {
            jxWindowManager = new NewWindowManager(){

                public NewWindowContainer evaluateWindow(NewWindowParams params) {
                    return NewWindowContainer.NO_DISPLAY;
                }
            };
            this.browser.getServices().setNewWindowManager(jxWindowManager);
        }
    }

    private void setupNavigationListener() {
        this.browser.addNavigationListener(this.jxNavListener);
    }

    @Override
    public Component getComponent() {
        if (!this.initialized) {
            this.init();
        }
        return this.browser.getComponent();
    }

    @Override
    public void openURL(final String url) {
        if (url.equals(this.browser.getCurrentLocation())) {
            this.updateListeners(url);
            return;
        }
        this.helperThread.invokeLater(new Runnable(){

            @Override
            public void run() {
                JxBrowserContainer.this.browser.navigate(url);
                JxBrowserContainer.this.browser.waitReady();
            }
        });
    }

    private void updateListeners(final String url) {
        this.helperThread.invokeLater(new Runnable(){

            @Override
            public void run() {
                JxBrowserContainer.this.fireSetCurrentURL(url);
                JxBrowserContainer.this.fireSetPageTitle(url);
                if (BrowserDebug.FWD_BACK.show()) {
                    LogSupport.message((String)("History forward[" + JxBrowserContainer.this.history.canGoForward() + "] back[" + JxBrowserContainer.this.history.canGoBack() + "]"));
                }
                JxBrowserContainer.this.fireSetBackEnabled(JxBrowserContainer.this.history.canGoBack());
                JxBrowserContainer.this.fireSetFwdEnabled(JxBrowserContainer.this.history.canGoForward());
            }
        });
    }

    @Override
    public void goForward() {
        if (this.history.canGoForward()) {
            this.navigateHistory(1);
        }
    }

    @Override
    public void goBack() {
        if (this.history.canGoBack()) {
            this.navigateHistory(-1);
        }
    }

    private void navigateHistory(int count) {
        if (this.historyTimer != null) {
            this.historyTimer.cancel();
            this.historyTimer = null;
        }
        final String navigateTo = this.history.go(count);
        Runnable historyTask = new Runnable(){

            @Override
            public void run() {
                JxBrowserContainer.this.fireSetFwdEnabled(false);
                JxBrowserContainer.this.fireSetBackEnabled(false);
                JxBrowserContainer.this.openURL(navigateTo);
                if (BrowserDebug.FWD_BACK.show()) {
                    LogSupport.message((String)("History.go(" + navigateTo + ") - " + JxBrowserContainer.this.history));
                }
            }
        };
        this.historyTimer = new LightweightTimer(2, historyTask);
        this.historyTimer.scheduleIn(1000L);
    }

    @Override
    public void stop() {
        this.clearPage();
        this.clearHistory();
        this.browser.stop();
    }

    private void clearPage() {
        this.openURL("about:blank");
    }

    private void clearHistory() {
        this.history.clear();
    }

    @Override
    public void dispose() {
    }

    @Override
    public byte getInitState() {
        if (!this.initialized) {
            this.init();
        }
        return this.state;
    }

    @Override
    public boolean hasFrameSupport() {
        return false;
    }

    @Override
    public void openURL(String frame, String url) {
        this.openURL(url);
    }

    @Override
    public void repaintContent() {
    }

    @Override
    public boolean isPropertySupported(String prop) {
        return false;
    }

    @Override
    public void setProperty(String prop, Object val) {
    }

    @Override
    public Object getProperty(String prop) {
        return null;
    }

    private void handleNavigateFinished(String url) {
        if (!this.lastUrl.equals(url)) {
            this.lastUrl = url;
            this.history.add(url);
            this.fireOnNavigate(url);
            this.updateListeners(url);
        }
    }
}

