/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.browser.macosx;

import java.util.ArrayList;
import java.util.List;

public class BrowserHistory {
    private List<String> history = new ArrayList<String>();
    private int currentIdx = 0;

    public int currentIndex() {
        return this.currentIdx;
    }

    public String getCurrentUrl() {
        return this.getUrlAt(this.currentIdx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUrlAt(int index) {
        List<String> list = this.history;
        synchronized (list) {
            if (this.history.isEmpty()) {
                this.currentIdx = 0;
                return "";
            }
            int returnIdx = 0;
            returnIdx = index < 0 ? 0 : (index >= this.history.size() ? this.history.size() - 1 : index);
            this.currentIdx = returnIdx;
            return this.history.get(returnIdx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String url) {
        if (url == null || url.contains("about:blank")) {
            return;
        }
        List<String> list = this.history;
        synchronized (list) {
            if (this.history.isEmpty()) {
                this.history.add(url);
                this.currentIdx = 0;
                return;
            }
            if (this.history.get(this.currentIdx).equals(url)) {
                return;
            }
            if (this.currentIdx < this.history.size() - 1) {
                this.history.subList(this.currentIdx + 1, this.history.size()).clear();
            }
            this.history.add(url);
            this.currentIdx = this.history.size() - 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<String> list = this.history;
        synchronized (list) {
            this.history.clear();
            this.currentIdx = 0;
        }
    }

    public String goBack(int count) {
        return this.getUrlAt(this.currentIdx - count);
    }

    public String goForward(int count) {
        return this.getUrlAt(this.currentIdx + count);
    }

    public String go(int count) {
        if (count < 0) {
            return this.goBack(count * -1);
        }
        if (count > 0) {
            return this.goForward(count);
        }
        return this.getCurrentUrl();
    }

    public boolean canGoBack() {
        return this.currentIdx > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canGoForward() {
        List<String> list = this.history;
        synchronized (list) {
            return this.currentIdx < this.history.size() - 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String reply = "";
        List<String> list = this.history;
        synchronized (list) {
            reply = reply + "\n--------------------------\n";
            for (int i = 0; i < this.history.size(); ++i) {
                String padding = " ";
                if (i == this.currentIdx) {
                    padding = "*";
                }
                reply = reply + "\t" + padding + "[" + i + "] " + this.history.get(i) + "\n";
            }
            reply = reply + "--------------------------\n";
        }
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        List<String> list = this.history;
        synchronized (list) {
            return this.history.isEmpty();
        }
    }
}

