/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.tools;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.ToolPath;
import com.elluminate.groupware.whiteboard.attributes.ToolStroke;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.AbstractUI;
import com.elluminate.groupware.whiteboard.tools.PenUIInterface;
import com.elluminate.groupware.whiteboard.tools.StringsProperties;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class PenToolModel
extends AbstractToolModel
implements Cloneable {
    private static final String WBD_NAME = "PenTool";
    private static final String PEN_UI_CLASS = "com.elluminate.groupware.whiteboard.module.ui.PenUI";
    protected ToolPath path = null;
    private short[] points = new short[0];
    private int pointsIndex = 0;

    public PenToolModel(WhiteboardContext context) {
        this(context, WBD_NAME);
    }

    public PenToolModel(WhiteboardContext context, String name) {
        super(context, name);
        this.path = new ToolPath(context);
        this.toolRect.setOptional(true);
        this.stroke = new ToolStroke(context, 2.0f, 1, 1);
        this.stroke.setName("PenStroke");
        this.stroke.setAlternateName("ToolStroke");
        this.stroke.setDisplayName(I18N.getString((PropertiesEnum)StringsProperties.TOOL_STROKE));
        this.stroke.setPanelKey("shapeProperties");
        this.color.setAlternateName("BorderColor");
        this.color.setQuickAttribute(true);
        this.stroke.setQuickAttribute(true);
        this.registerIfClass("PenToolModel");
    }

    @Override
    protected void registerAttributes() {
        super.registerAttributes();
        this.addAttribute(this.path);
    }

    public PenToolModel(WhiteboardContext context, WBElement element, ProgressUpdate update) {
        this(context);
        try {
            this.elementToObject(element, update);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"JDOM constructor", (Throwable)ex, (boolean)true);
        }
    }

    public PenToolModel(WhiteboardContext context, WBInputStream istr) {
        this(context);
        try {
            this.streamToObject(istr);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"stream constructor", (Throwable)ex, (boolean)true);
        }
    }

    @Override
    public AbstractToolModel toolFactory(ScreenModel screen, WBNode container, ActionEvent e, boolean reciprocal) {
        try {
            PenToolModel penToolModel = (PenToolModel)this.clone();
            penToolModel.getPath().setPath(new short[0], 0, true);
            penToolModel.initialized = false;
            return penToolModel;
        }
        catch (CloneNotSupportedException ex) {
            LogSupport.exception((Object)this, (String)"toolFactory", (Throwable)ex, (boolean)true);
            return new PenToolModel(this.context);
        }
    }

    @Override
    public AbstractToolModel toolFactory(ScreenModel screen, WBNode container, boolean reciprocal, AbstractToolModel ancestor) {
        return null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PenToolModel penToolModel = (PenToolModel)super.clone();
        penToolModel.path = (ToolPath)this.path.clone();
        penToolModel.registerIfClass("PenToolModel");
        return penToolModel;
    }

    @Override
    public boolean createOnlyToScreen() {
        return false;
    }

    @Override
    public int creationMouseEvent(MouseEvent e) {
        int response = 0;
        switch (e.getID()) {
            case 501: {
                this.points = new short[1024];
                this.pointsIndex = 0;
                this.points[this.pointsIndex++] = (short)e.getX();
                this.points[this.pointsIndex++] = (short)e.getY();
                this.setUIInvalid(false);
                this.setUIData(((PenUIInterface)((Object)this.getUI())).makePath(null, e.getX(), e.getY(), this.stroke.getWidth(), this, this.context.getController()));
                this.evaluateBounds();
                break;
            }
            case 506: {
                if (this.pointsIndex >= this.points.length) {
                    short[] oldPoints = this.points;
                    this.points = new short[oldPoints.length + 1024];
                    System.arraycopy(oldPoints, 0, this.points, 0, oldPoints.length);
                }
                this.points[this.pointsIndex++] = (short)e.getX();
                this.points[this.pointsIndex++] = (short)e.getY();
                this.initialized = this.pointsIndex > 2;
                this.setUIInvalid(false);
                this.setUIData(((PenUIInterface)((Object)this.getUI())).makePath(this.getUIData(), e.getX(), e.getY(), this.stroke.getWidth(), this, this.context.getController()));
                this.evaluateBounds();
                break;
            }
            case 502: {
                if (this.pointsIndex == 2) {
                    this.points[this.pointsIndex++] = this.points[0];
                    this.points[this.pointsIndex++] = this.points[1];
                }
                this.setBounds(new Rectangle(0, 0, 0, 0));
                this.evaluateBounds();
                this.path.setPath(this.points, this.pointsIndex, false);
                this.setUIInvalid(true);
                this.evaluateBounds();
                this.initialized = this.pointsIndex > 2;
                this.points = null;
                this.pointsIndex = 0;
                this.context.getController().repaint(this);
                response = 2;
                break;
            }
        }
        return response;
    }

    @Override
    public int creationKeyEvent(KeyEvent event) {
        if (event.getID() == 402 && this.context.getController() != null) {
            this.context.getController().processNavKey(event);
        }
        return 0;
    }

    @Override
    public AbstractUI getUI() {
        if (this.toolUI == null && this.context.getController() != null) {
            this.toolUI = this.toolUIFactory(PEN_UI_CLASS);
        }
        return this.toolUI;
    }

    @Override
    public void delete() {
        this.path = null;
        super.delete();
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) throws Exception {
        WBElement element = new WBElement(this.getName());
        super.objectToElement(element, progress);
        return element;
    }

    @Override
    public void render(Graphics g) {
        if (this.getUIData() != null || this.path.hasPath()) {
            ((PenUIInterface)((Object)this.getUI())).draw(g, this);
        }
    }

    @Override
    public void notifySizingChange() {
        super.notifySizingChange();
        this.path.calculateScale();
    }

    @Override
    public void setColor(Object col) {
        this.color.setColor(col);
        this.notifyVisibleChange();
    }

    @Override
    public void setStroke(Object str) {
        this.notifyVisibleChange();
        this.stroke.setStroke(str);
        this.notifySizingChange();
    }

    public ToolPath getPath() {
        return this.path;
    }

    public void setPath(ToolPath pth) {
        this.notifyVisibleChange();
        this.path.setPath(pth.getPath(), pth.getPath().length, false);
        this.notifySizingChange();
    }
}

