/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.tools;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.AbstractUI;
import com.elluminate.groupware.whiteboard.tools.LineUIInterface;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.util.log.LogSupport;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;

public class LineToolModel
extends AbstractToolModel
implements Cloneable {
    static final String WBD_NAME = "LineTool";
    static final String LINE_UI_CLASS = "com.elluminate.groupware.whiteboard.module.ui.LineUI";
    protected byte orientation = 1;

    public LineToolModel(WhiteboardContext context) {
        this(context, WBD_NAME);
    }

    public LineToolModel(WhiteboardContext context, String name) {
        super(context, name);
        this.color.setAlternateName("BorderColor");
        this.color.setQuickAttribute(true);
        this.stroke.setQuickAttribute(true);
        this.registerIfClass("LineToolModel");
    }

    public LineToolModel(WhiteboardContext context, WBElement element, ProgressUpdate update) {
        this(context);
        try {
            this.elementToObject(element, update);
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"LineToolModel", (Throwable)e, (boolean)true);
        }
    }

    public LineToolModel(WhiteboardContext context, WBInputStream istr) {
        this(context);
        try {
            this.streamToObject(istr);
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"LineToolModel", (Throwable)e, (boolean)true);
        }
    }

    @Override
    public AbstractToolModel toolFactory(ScreenModel screen, WBNode container, ActionEvent e, boolean reciprocal) {
        try {
            LineToolModel lineToolModel = (LineToolModel)this.clone();
            lineToolModel.initialized = false;
            lineToolModel.toolRect.setSize(0.5, 0.5, false);
            return lineToolModel;
        }
        catch (CloneNotSupportedException ex) {
            LogSupport.exception((Object)this, (String)"toolFactory", (Throwable)ex, (boolean)true);
            return new LineToolModel(this.context);
        }
    }

    @Override
    public AbstractToolModel toolFactory(ScreenModel screen, WBNode container, boolean reciprocal, AbstractToolModel ancestor) {
        return null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        LineToolModel lineToolModel = (LineToolModel)super.clone();
        lineToolModel.registerIfClass("LineToolModel");
        return lineToolModel;
    }

    @Override
    protected void registerAttributes() {
        super.registerAttributes();
    }

    @Override
    public boolean createOnlyToScreen() {
        return false;
    }

    @Override
    public int creationMouseEvent(MouseEvent e) {
        int response = 0;
        switch (e.getID()) {
            case 501: {
                this.initialized = true;
                this.toolRect.setSize(0.5, 0.5, false);
                this.setLocation(e.getX(), e.getY());
                break;
            }
            case 506: {
                int x = e.getX() - this.getLocation().getIntLocation().x;
                int y = e.getY() - this.getLocation().getIntLocation().y;
                if (e.isShiftDown()) {
                    int absX = Math.abs(x);
                    int absY = Math.abs(y);
                    int max = Math.max(absX, absY);
                    if (2 * absY < absX) {
                        x = x <= 0 ? -max : max;
                        y = 0;
                    } else if (2 * absX < absY) {
                        y = y <= 0 ? -max : max;
                        x = 0;
                    } else {
                        x = x <= 0 ? -max : max;
                        y = y <= 0 ? -max : max;
                    }
                }
                this.setSize(x, y);
                break;
            }
            case 502: {
                response = 2;
                break;
            }
        }
        return response;
    }

    @Override
    public int creationKeyEvent(KeyEvent event) {
        if (event.getID() == 402 && this.context.getController() != null) {
            this.context.getController().processNavKey(event);
        }
        return 0;
    }

    @Override
    public AbstractUI getUI() {
        if (this.toolUI == null && this.context.getController() != null) {
            this.toolUI = this.toolUIFactory(LINE_UI_CLASS);
        }
        return this.toolUI;
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        this.orientation = istr.readByte();
        return this;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        try {
            return super.streamToString(istr) + ", Orientation=" + istr.readByte();
        }
        catch (IOException ioe) {
            return this.getName() + " IOException: " + ioe.getMessage();
        }
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ostr.writeByte(this.orientation);
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) throws Exception {
        WBElement element = new WBElement(this.getName());
        super.objectToElement(element, progress);
        return element;
    }

    public void makeShape() {
        switch (this.orientation) {
            case 1: {
                double x1 = this.toolRect.getLocation().getX();
                double x2 = this.toolRect.getSize().getWidth() + x1;
                double y1 = this.toolRect.getLocation().getY();
                double y2 = this.toolRect.getSize().getHeight() + y1;
                break;
            }
            case 2: {
                double x1 = this.toolRect.getLocation().getX();
                double x2 = this.toolRect.getSize().getWidth() + x1;
                double y2 = this.toolRect.getLocation().getY();
                double y1 = this.toolRect.getSize().getHeight() + y2;
                break;
            }
            case 3: {
                double x2 = this.toolRect.getLocation().getX();
                double x1 = this.toolRect.getSize().getWidth() + x2;
                double y1 = this.toolRect.getLocation().getY();
                double y2 = this.toolRect.getSize().getHeight() + y1;
                break;
            }
            default: {
                double x2 = this.toolRect.getLocation().getX();
                double x1 = this.toolRect.getSize().getWidth() + x2;
                double y2 = this.toolRect.getLocation().getY();
                double y1 = this.toolRect.getSize().getHeight() + y2;
            }
        }
        this.evaluateBounds();
        this.notifySizingChange();
    }

    @Override
    public void render(Graphics g) {
        ((LineUIInterface)((Object)this.getUI())).draw(g, this);
    }

    @Override
    public void setColor(Object col) {
        this.color.setColor(col);
        this.notifyVisibleChange();
    }

    @Override
    public void setStroke(Object str) {
        this.notifyVisibleChange();
        this.stroke.setStroke(str);
        this.notifySizingChange();
    }
}

