/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.tools;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.ToolColor;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.RectangleToolModel;
import com.elluminate.groupware.whiteboard.tools.StringsProperties;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.event.ActionEvent;

public class FilledRectangleToolModel
extends RectangleToolModel {
    static final String FILLED_WBD_NAME = "FilledRectangleTool";

    public FilledRectangleToolModel(WhiteboardContext context) {
        this(context, FILLED_WBD_NAME);
    }

    public FilledRectangleToolModel(WhiteboardContext context, String name) {
        super(context, name);
        this.color.setDisplayName(I18N.getString((PropertiesEnum)StringsProperties.FILLEDSHAPE_COLORNAME));
        this.color.setPanelKey("filledShapeProperties");
        this.stroke.setPanelKey(null);
        this.fillColor = null;
        this.registerIfClass("FilledRectangleToolModel");
    }

    public FilledRectangleToolModel(WhiteboardContext context, WBElement element, ProgressUpdate update) {
        this(context);
        try {
            this.elementToObject(element, update);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"JDOM constructor", (Throwable)ex, (boolean)true);
        }
    }

    public FilledRectangleToolModel(WhiteboardContext context, WBInputStream istr) {
        this(context);
        try {
            this.streamToObject(istr);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"stream constructor", (Throwable)ex, (boolean)true);
        }
    }

    @Override
    public boolean hasReciprocalAction() {
        return false;
    }

    @Override
    public AbstractToolModel toolFactory(ScreenModel screen, WBNode container, ActionEvent e, boolean reciprocal) {
        FilledRectangleToolModel newTool;
        try {
            newTool = (FilledRectangleToolModel)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            LogSupport.exception((Object)this, (String)"toolFactory", (Throwable)ex, (boolean)true);
            newTool = new FilledRectangleToolModel(this.context);
        }
        newTool.setSize(1.0, 1.0);
        newTool.setFilled(true);
        return newTool;
    }

    @Override
    public AbstractToolModel toolFactory(ScreenModel screen, WBNode container, boolean reciprocal, AbstractToolModel ancestor) {
        return null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FilledRectangleToolModel filledRectangleToolModel = (FilledRectangleToolModel)super.clone();
        if (this.fillColor != null) {
            filledRectangleToolModel.fillColor = (ToolColor)this.fillColor.clone();
        }
        filledRectangleToolModel.registerIfClass("FilledRectangleToolModel");
        filledRectangleToolModel.setFilled(true);
        return filledRectangleToolModel;
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        FilledRectangleToolModel tool = (FilledRectangleToolModel)super.streamToObject(istr);
        tool.setFilled(true);
        return tool;
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        FilledRectangleToolModel tool = (FilledRectangleToolModel)super.elementToObject(element, progress);
        this.setFilled(true);
        return tool;
    }
}

