/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.responder;

import com.elluminate.framework.imps.Imps;
import com.elluminate.groupware.whiteboard.InitializeWhiteboard;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.WhiteboardProtocol;
import com.elluminate.groupware.whiteboard.conference.ClientIdentification;
import com.elluminate.groupware.whiteboard.conference.ClientSendsScreenSynch;
import com.elluminate.groupware.whiteboard.conference.WhiteboardDataProcessor;
import com.elluminate.groupware.whiteboard.dataModel.Validator;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ChannelEvent;
import com.elluminate.jinx.ChannelListener;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ClientListener;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.DefaultProtocolResponder;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.util.ShortList;
import com.google.inject.Inject;

public class WhiteboardResponder
extends DefaultProtocolResponder
implements ChannelDataListener,
ChannelListener,
ClientListener {
    static final String RESPONDER_NAME = " Recorder ";
    WhiteboardContext context = null;
    ClientList prevClients = null;

    @Inject
    public WhiteboardResponder(WhiteboardProtocol protocol, Imps imps) {
        super((JinxProtocol)protocol);
        this.setChannelListener(this);
        this.setChannelDataListener(this);
        try {
            this.context = new WhiteboardContext(true, true);
            this.context.setImps(imps);
            this.context.setRegistryOnline(true);
            WhiteboardDataProcessor dataProcessor = new WhiteboardDataProcessor(this.context);
            dataProcessor.setChannel(null);
            this.context.setDataProcessor(dataProcessor);
            this.context.setConferenceUID(0L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setClientList(ClientList clients) {
        if (this.prevClients == clients) {
            return;
        }
        if (this.prevClients != null) {
            this.prevClients.removeClientListener((ClientListener)this);
        }
        this.prevClients = clients;
        if (clients != null) {
            this.context.setClientList(clients);
            InitializeWhiteboard.registerIntrinsicObjects(this.context);
            clients.addClientListener((ClientListener)this);
            this.context.getIDProcessor().addClient(ShortList.get((short)clients.getMyAddress()), ClientIdentification.RECORDER_ID, RESPONDER_NAME);
        }
    }

    public void join(Connection connection, String channel) {
        this.setClientList(connection.getClientList());
        super.join(connection, channel);
        this.context.setClientOnline(true);
    }

    public void leave(String channel) {
        super.leave(channel);
        this.setClientList(null);
        this.context.setClientOnline(false);
        this.context.svcStop();
    }

    public void onAddClient(ClientEvent e) {
        if (e.isMe()) {
            this.context.getIDProcessor().setMyAddress(e.getAddress());
        }
    }

    public void onRemoveClient(ClientEvent e) {
        this.context.getDataExporter().offLineParticipant(ShortList.get((short)e.getAddress()));
    }

    public void onChannelData(ChannelDataEvent e) {
        switch (e.getCommand()) {
            default: {
                this.context.getDataProcessor().onChannelData(e);
                break;
            }
            case 3: {
                ClientSendsScreenSynch synch = new ClientSendsScreenSynch(this.context);
                synch.setOnline(this.context.getIDProcessor().getMyId(), this.context.getConferenceUID(), RESPONDER_NAME);
                this.context.getDataProcessor().sendDirective((byte)6, synch);
                break;
            }
            case 8: {
                Validator.validate("WhiteboardResponder.onlineValidation", this.context);
            }
        }
    }

    public void channelStateChanged(ChannelEvent e) {
        switch (e.getState()) {
            case 1: {
                if (e.getSource() instanceof Channel) {
                    this.context.getDataProcessor().setChannel((Channel)e.getSource());
                }
                if (!this.context.getDataProcessor().areChannelsUp()) break;
                this.context.setRegistryOnline(true);
                this.context.getDataProcessor().sendDirective((byte)2, null);
                break;
            }
            case 2: {
                this.context.setRegistryOnline(false);
                if (!(e.getSource() instanceof Channel)) break;
                this.context.getDataProcessor().setChannel(null);
                break;
            }
        }
    }
}

