/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.Validator;
import com.elluminate.groupware.whiteboard.interfaces.UniqueObjectID;
import com.elluminate.util.Debug;
import com.elluminate.util.log.LogSupport;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class UniqueObjectManager {
    private HashMap objectMap = new HashMap();
    private HashMap dynamicMap = new HashMap();
    private int objectSequence = 0;
    private WhiteboardContext context = null;
    private Object lock = new Object();

    public UniqueObjectManager(WhiteboardContext context) {
        this.objectMap = new HashMap();
        this.context = context;
    }

    public short getClientId() {
        this.context.getIDProcessor();
        return 0;
    }

    public short getClientId(Long objectId) {
        return ObjectUID.decodeClientId(objectId);
    }

    public int getObjectSequence() {
        return this.objectSequence;
    }

    public int getObjectSequence(long objectId) {
        return ObjectUID.decodeSequence(objectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectFromMap(Long objectUID) throws Exception {
        Object object;
        if (objectUID == null) {
            throw new Exception("UniqueObjectManager: Request for object with null UID.");
        }
        Object object2 = this.lock;
        synchronized (object2) {
            object = this.objectMap.get(objectUID);
        }
        return object;
    }

    public Long setObjectInMap(UniqueObjectID object, Long key) {
        return this.setObjectInMap(object, key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long setObjectInMap(UniqueObjectID object, Long key, boolean replace) {
        Object oldObject = null;
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.objectMap.containsKey(key)) {
                if (!replace) {
                    Debug.lockLeave((Object)this, (String)"UniqueObjectManager.setObjectInMap", (String)"DataModel", (Object)this.context.getDataModel());
                    return new Long(-1L);
                }
                oldObject = this.objectMap.remove(key);
                if (object == null) {
                    LogSupport.message((Object)this, (String)"setObjectInMap", (String)("key not removed from commStateData: " + key));
                }
            } else if (replace) {
                Validator.logAlways("Replaced Object did not exist in map: " + WBUtils.objectName(object));
            }
            this.objectMap.put(object.getObjectID(), object);
            return object.getObjectID();
        }
    }

    public Long setObjectInMap(UniqueObjectID object) {
        if (object.getObjectID() == null) {
            this.context.getIDProcessor();
            return this.setObjectInMap(object, 0);
        }
        return this.setObjectInMap(object, object.getObjectID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObject(UniqueObjectID obj) {
        Object object = this.lock;
        synchronized (object) {
            this.removeObject(obj.getObjectID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObject(Long key) {
        Object object = this.lock;
        synchronized (object) {
            if (key != null) {
                Object object2 = this.objectMap.get(key);
                if (object2 != null) {
                    ((UniqueObjectID)object2).setObjectID(null);
                }
                if (this.objectMap.remove(key) == null) {
                    LogSupport.message((Object)this, (String)"removeObject", (String)("key not removed from objectMap: " + key));
                }
            } else {
                LogSupport.error((Object)this, (String)"removeObject", (String)"Remove Object without UID.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List returnClientsObjectIDs(Short clientId) {
        LinkedList list = new LinkedList();
        Object object = this.lock;
        synchronized (object) {
            if (clientId != null) {
                for (Object object2 : this.objectMap.values()) {
                    short owner;
                    if (!(object2 instanceof UniqueObjectID) || ((UniqueObjectID)object2).getObjectID() == null || (owner = this.getClientId(((UniqueObjectID)object2).getObjectID())) != clientId) continue;
                    list.add(object2);
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long setObjectInMap(UniqueObjectID object, int seed) {
        Long objectId;
        Object object2 = this.lock;
        synchronized (object2) {
            objectId = this.newObjectUId(seed);
            if (objectId == null) {
                Debug.lockLeave((Object)this, (String)"UniqueObjectManager.setObjectInMap", (String)"DataModel", (Object)this.context.getDataModel());
                return new Long(-1L);
            }
            if (this.objectMap.put(objectId, object) != null) {
                Debug.lockLeave((Object)this, (String)"UniqueObjectManager.setObjectInMap", (String)"DataModel", (Object)this.context.getDataModel());
                return new Long(-1L);
            }
            if (object.getObjectID() == null) {
                object.setObjectID(objectId);
            }
            this.resolveReferences(object);
        }
        return objectId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snapLink(Long targetUID, Object reference, String fieldName) throws RuntimeException {
        Object object = this.lock;
        synchronized (object) {
            Field field;
            if (!(reference instanceof UniqueObjectID)) {
                throw new RuntimeException("Cannot link to a non-ObjectUID object.");
            }
            Long objectUID = ((UniqueObjectID)reference).getObjectID();
            if (objectUID == null) {
                throw new RuntimeException("UniqueObjectManager(snapLink): reference object is not registered.");
            }
            Class<?> objectClass = reference.getClass();
            try {
                field = objectClass.getField(fieldName);
            }
            catch (NoSuchFieldException nsfe) {
                throw new RuntimeException("UniqueObjectManager(snapLink): Object(" + objectClass.getName() + ") does not have the specified field: " + fieldName);
            }
            try {
                Object target = this.getObjectFromMap(targetUID);
                field.set(reference, target);
                if (target == null) {
                    this.deferSnapLink(objectUID, fieldName, targetUID);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("UniqueObjectManager(snapLink): " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveReferences(UniqueObjectID target) {
        Object object = this.lock;
        synchronized (object) {
            LinkedList referenceList = (LinkedList)this.dynamicMap.get(target.getObjectID());
            if (referenceList == null) {
                Debug.lockLeave((Object)this, (String)"UniqueObjectManager.resolveReferences", (String)"DataModel", (Object)this.context.getDataModel());
                return;
            }
            Iterator iter = referenceList.iterator();
            while (iter.hasNext()) {
                LinkSnap ref = (LinkSnap)iter.next();
                try {
                    ref.snapLink(target);
                }
                catch (Exception ex) {
                    LogSupport.exception((Object)this, (String)"resolveReferences", (Throwable)ex, (boolean)true, (String)"In snapLink");
                }
                iter.remove();
            }
            if (this.dynamicMap.remove(target.getObjectID()) == null) {
                LogSupport.message((Object)this, (String)"resolveReferences", (String)("target not removed from dynamicMap: " + target));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deferSnapLink(Long objectUID, String fieldName, Long targetUID) {
        Object object = this.lock;
        synchronized (object) {
            LinkedList<LinkSnap> targetList = (LinkedList<LinkSnap>)this.dynamicMap.get(targetUID);
            if (targetList == null) {
                targetList = new LinkedList<LinkSnap>();
                this.dynamicMap.put(targetUID, targetList);
            }
            targetList.add(new LinkSnap(objectUID, fieldName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long newObjectUId(int seed) {
        Long key;
        long localSeed = (long)seed << 32;
        int loopLimit = 10000;
        Object object = this.lock;
        synchronized (object) {
            do {
                int objectSeq = ++this.objectSequence;
                this.objectSequence = 0x3FFFFFFF & this.objectSequence;
                key = new Long(localSeed + (long)objectSeq);
                if (loopLimit-- >= 0) continue;
                return null;
            } while (this.objectMap.containsKey(key));
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStaticString() {
        StringBuffer result;
        Object object = this.lock;
        synchronized (object) {
            StringBuilder stringBuilder = new StringBuilder().append("UniqueObjectManager: Session: ");
            this.context.getIDProcessor();
            result = new StringBuffer(stringBuilder.append(0).toString());
            result.append(", CurrentSequence: " + this.objectSequence);
            result.append(", ObjectMapSize: " + this.objectMap.size());
            Set keySet = this.objectMap.keySet();
            for (Long key : keySet) {
                UniqueObjectID obj = (UniqueObjectID)this.objectMap.get(key);
                result.append("\n  " + WBUtils.uniqueIDAsHex(key) + ", Object: " + obj + "\t\tinternal UID: " + WBUtils.uniqueIDAsHex(obj.getObjectID()));
            }
            result.append("\n");
        }
        return result.toString();
    }

    public String toString() {
        return this.toStaticString();
    }

    public class LinkSnap {
        private Long objectUID;
        private String fieldName;

        LinkSnap(Long uid, String name) {
            this.objectUID = uid;
            this.fieldName = name;
        }

        public boolean snapLink(Object target) throws Exception {
            Object referenceObject = UniqueObjectManager.this.getObjectFromMap(this.objectUID);
            if (referenceObject == null) {
                return false;
            }
            Class<?> objectClass = referenceObject.getClass();
            Field field = objectClass.getField(this.fieldName);
            field.set(referenceObject, target);
            return true;
        }
    }
}

