/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.util.SwingRunnerSupport;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public abstract class ThumbnailResolver {
    private boolean resolving = false;
    private LinkedList<TreeRef> repaintRef = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReference(Component c, int x, int y) {
        for (Container component = c.getParent(); component != null; component = component.getParent()) {
            if (!(component instanceof JTree)) continue;
            JTree tree = (JTree)component;
            Point treePoint = SwingUtilities.convertPoint(c, x, y, tree);
            int row = tree.getRowForLocation(treePoint.x, treePoint.y);
            LinkedList<TreeRef> linkedList = this.repaintRef;
            synchronized (linkedList) {
                this.repaintRef.add(new TreeRef(tree, row));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVisible() {
        TreeRef[] refArray;
        LinkedList<TreeRef> linkedList = this.repaintRef;
        synchronized (linkedList) {
            refArray = new TreeRef[this.repaintRef.size()];
            refArray = this.repaintRef.toArray(refArray);
        }
        for (int i = 0; i < refArray.length; ++i) {
            if (!refArray[i].isVisible()) continue;
            return true;
        }
        return false;
    }

    public void abandonResolving() {
        this.resolving = false;
    }

    public boolean isResolving() {
        return this.resolving;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint() {
        LinkedList<TreeRef> paintList;
        LinkedList<TreeRef> linkedList = this.repaintRef;
        synchronized (linkedList) {
            paintList = this.repaintRef;
            this.repaintRef = new LinkedList();
        }
        Iterator repaintIter = paintList.iterator();
        while (repaintIter.hasNext()) {
            ((TreeRef)repaintIter.next()).repaint();
            repaintIter.remove();
        }
    }

    public abstract void resolve();

    public void setResolving() {
        this.resolving = true;
    }

    class TreeRef {
        private JTree tree;
        private TreePath path;
        private JViewport viewPort;

        public TreeRef(JTree tree, int row) {
            this.tree = tree;
            this.path = tree.getPathForRow(row);
            this.viewPort = tree.getParent() instanceof JViewport ? (JViewport)tree.getParent() : null;
        }

        public boolean isVisible() {
            Rectangle rect = this.tree.getPathBounds(this.path);
            if (rect != null && this.viewPort != null) {
                Rectangle viewRect = this.viewPort.getViewRect();
                boolean visible = viewRect.intersects(rect);
                return visible;
            }
            return true;
        }

        public void repaint() {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Rectangle rect = TreeRef.this.tree.getPathBounds(TreeRef.this.path);
                    if (rect != null) {
                        TreeRef.this.tree.repaint(rect);
                    }
                }
            });
        }
    }
}

