/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.comm.AbstractCommContainer;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.util.log.LogSupport;
import java.io.IOException;
import java.util.ArrayList;

public class TemplateRegistrationEvent
extends AbstractCommContainer {
    private ArrayList registrations = new ArrayList();

    public TemplateRegistrationEvent(WhiteboardContext context) {
        super(context, "Empty TemplateRegistrationEvent");
    }

    public TemplateRegistrationEvent(WhiteboardContext context, boolean added, String name, Short id, RegisteredTemplate obj) {
        super(context, "_TemplateRegistrationEvent");
        this.registrations.add(new RegistrationContainer(added, name, id, obj));
    }

    public void add(boolean added, String name, Short id, RegisteredTemplate template) {
        this.registrations.add(new RegistrationContainer(added, name, id, template));
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        short id = 0;
        String name = null;
        String className = null;
        boolean added = false;
        try {
            super.streamToObject(istr);
            while (istr.available() > 0) {
                id = WBUtils.readShort(istr, "Temp reg ID");
                name = WBUtils.readUTF(istr, "Temp reg name");
                className = WBUtils.readUTF(istr, "Temp reg classname");
                added = WBUtils.readBoolean(istr, "Temp reg added");
                if (added) {
                    this.context.getTemplateRegistry().loadTemplate(id, name, className);
                    continue;
                }
                this.context.getTemplateRegistry().removeTemplate(name);
            }
        }
        catch (IOException ioe) {
            LogSupport.exception((Object)this, (String)"streamToObject", (Throwable)ioe, (boolean)true, (String)("Id: " + id + ", Name: " + name + ", Class: " + className + ", Added: " + added));
        }
        return null;
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        RegistrationContainer rc2 = null;
        try {
            super.objectToStream(ostr);
            for (RegistrationContainer rc2 : this.registrations) {
                if (rc2.id != null) {
                    ostr.writeShort(rc2.id.shortValue());
                } else {
                    ostr.writeShort(0);
                }
                ostr.writeUTF(rc2.registeredTemplateName);
                ostr.writeUTF(rc2.getClassName());
                ostr.writeBoolean(rc2.added);
            }
        }
        catch (IOException ioe) {
            if (rc2 == null) {
                LogSupport.exception((Object)this, (String)"objectToStream", (Throwable)ioe, (boolean)true, (String)"Null rc");
            }
            LogSupport.exception((Object)this, (String)"objectToStream", (Throwable)ioe, (boolean)true, (String)("Id: " + rc2.id + ", Name: " + rc2.registeredTemplateName + ", Class: " + rc2.getClassName() + ", Added: " + rc2.added));
        }
    }

    @Override
    public String streamToString(WBInputStream istr) {
        StringBuffer buf = new StringBuffer(super.streamToString(istr));
        try {
            while (istr.available() > 0) {
                short id = WBUtils.readShort(istr, "Temp reg string id");
                String name = WBUtils.readUTF(istr, "Temp reg string name");
                String className = WBUtils.readUTF(istr, "Temp reg string classname");
                boolean added = WBUtils.readBoolean(istr, "Temp reg string added");
                buf.append("TemplateRegistrationEvent: ");
                if (added) {
                    buf.append("add");
                } else {
                    buf.append("remove");
                }
                buf.append(" Template: " + name + ", from class: " + className + " (ID=" + id + ")");
                if (istr.available() <= 0) continue;
                buf.append("\n");
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"streamToString", (Throwable)ex, (boolean)true);
            buf.append("\n  Exception: " + ex.getMessage());
        }
        return buf.toString();
    }

    public class RegistrationContainer {
        public boolean added;
        public String registeredTemplateName;
        public Short id;
        public RegisteredTemplate template;

        public RegistrationContainer(boolean added, String name, Short id, RegisteredTemplate template) {
            this.added = added;
            this.registeredTemplateName = name;
            this.id = id;
            this.template = template;
        }

        public String getClassName() {
            return this.template.getClass().getName();
        }
    }
}

