/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.util.log.LogSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class TemplateClassLoader
extends ClassLoader {
    ClassLoader parent = this.getClass().getClassLoader();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readClassFile(String className, String classPath) {
        byte[] inputBytes = null;
        int bytesRead = 0;
        File classFile = null;
        FileInputStream fileStream = null;
        String fileName = className.replace('.', File.separatorChar);
        String pathName = classPath + fileName + ".class";
        try {
            classFile = new File(pathName);
            fileStream = new FileInputStream(classFile);
            bytesRead = (int)classFile.length();
            inputBytes = new byte[bytesRead];
            try {
                bytesRead = fileStream.read(inputBytes);
            }
            catch (IOException e) {
                LogSupport.error((String)"Exception trying to read the class file");
            }
        }
        catch (FileNotFoundException e) {
            LogSupport.error((String)("File " + classFile.toString() + " doesn't exist"));
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (Exception e) {}
            }
        }
        return inputBytes;
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> newClass = this.findLoadedClass(name);
        if (newClass == null) {
            newClass = this.parent != null ? this.parent.loadClass(name) : this.findSystemClass(name);
        }
        if (resolve) {
            this.resolveClass(newClass);
        }
        return newClass;
    }
}

