/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.dataModel.WBNodeProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class NodeList
extends ArrayList {
    private static final boolean DEBUG_INDEX = false;
    private WBNode parent = null;
    private int maxKnownIndex = -1;

    public NodeList(WBNode parent) {
        this.parent = parent;
    }

    public NodeList(WBNode parent, Collection c) {
        super(c);
        this.parent = parent;
    }

    public NodeList(WBNode parent, int initialCapacity) {
        super(initialCapacity);
        this.parent = parent;
    }

    @Override
    public synchronized int indexOf(Object object) {
        if (!(object instanceof WBNode)) {
            return super.indexOf(object);
        }
        WBNode node = (WBNode)object;
        if (this.maxKnownIndex >= this.size()) {
            this.maxKnownIndex = 0;
        }
        if (node.nodeIndex < 0 || node.nodeIndex > this.maxKnownIndex || node != this.get(node.nodeIndex)) {
            node.nodeIndex = -1;
            int index = this.maxKnownIndex + 1;
            while (index < this.size()) {
                WBNode nodeAtIndex = (WBNode)this.get(index);
                nodeAtIndex.nodeIndex = index;
                this.maxKnownIndex = index++;
            }
        }
        if (node.nodeIndex < 0) {
            node.nodeIndex = super.indexOf(node);
        }
        return node.nodeIndex;
    }

    public WBNode getParent() {
        return this.parent;
    }

    public Iterator realIterator() {
        return new Iterator(){
            Object object;
            Iterator iter;
            {
                this.iter = NodeList.this.iterator();
            }

            @Override
            public boolean hasNext() {
                while (this.iter.hasNext()) {
                    this.object = this.iter.next();
                    if (this.object instanceof WBNodeProxy) continue;
                    return true;
                }
                return false;
            }

            public Object next() {
                return this.object;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                this.iter.remove();
                NodeList nodeList = NodeList.this;
                synchronized (nodeList) {
                    NodeList.this.maxKnownIndex = -1;
                }
            }
        };
    }

    @Override
    public synchronized boolean add(Object o) {
        boolean added = super.add(o);
        if (o == this.getParent()) {
            throw new RuntimeException("Circular Reference");
        }
        if (o instanceof WBNode) {
            ((WBNode)o).nodeIndex = this.size() - 1;
        }
        return added;
    }

    @Override
    public synchronized boolean remove(Object o) {
        boolean removed = super.remove(o);
        if (removed && o instanceof WBNode && ((WBNode)o).nodeIndex >= 0) {
            this.maxKnownIndex = ((WBNode)o).nodeIndex - 1;
            ((WBNode)o).nodeIndex = -1;
        } else {
            this.maxKnownIndex = -1;
        }
        return removed;
    }

    @Override
    public synchronized boolean addAll(Collection c) {
        boolean added = super.addAll(c);
        return added;
    }

    @Override
    public synchronized boolean addAll(int index, Collection c) {
        boolean added = super.addAll(index, c);
        if (index <= this.maxKnownIndex) {
            this.maxKnownIndex = index - 1;
        }
        return added;
    }

    @Override
    public synchronized boolean removeAll(Collection c) {
        boolean removed = super.removeAll(c);
        this.maxKnownIndex = -1;
        return removed;
    }

    @Override
    public synchronized boolean retainAll(Collection c) {
        boolean retained = super.retainAll(c);
        this.maxKnownIndex = -1;
        return retained;
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.maxKnownIndex = -1;
    }

    @Override
    public synchronized Object set(int index, Object element) {
        Object object = super.set(index, element);
        if (element instanceof WBNode) {
            ((WBNode)element).nodeIndex = index;
        }
        return object;
    }

    @Override
    public synchronized void add(int index, Object element) {
        super.add(index, element);
        if (element == this.getParent()) {
            throw new RuntimeException("Circular Reference");
        }
        if (element instanceof WBNode) {
            ((WBNode)element).nodeIndex = index;
        }
        if (index <= this.maxKnownIndex) {
            this.maxKnownIndex = index - 1;
        }
    }

    @Override
    public synchronized Object remove(int index) {
        Object object = super.remove(index);
        if (index <= this.maxKnownIndex) {
            if (object instanceof WBNode) {
                this.maxKnownIndex = index != ((WBNode)object).nodeIndex ? -1 : index - 1;
                ((WBNode)object).nodeIndex = -1;
            } else {
                this.maxKnownIndex = -1;
            }
        }
        return object;
    }

    public void streamToObject(WBInputStream istr, WBNode parent) throws Exception {
        int nodeCount = WBUtils.readShort(istr, "WBNodeList reads count");
        super.clear();
        super.ensureCapacity(nodeCount);
        for (int i = 0; i < nodeCount; ++i) {
            WBNodeProxy proxy = (WBNodeProxy)parent.getContext().getNodeProxy().streamToObject(istr);
            proxy.setOriginator(istr.getOriginatorId());
            istr.getContext().getObjectManager().setObjectInMap(proxy, proxy.getObjectID(), false);
            proxy.setParent(parent);
            this.add(proxy);
        }
    }

    public void objectToStream(WBOutputStream ostr) throws Exception {
        ostr.writeShort(this.size());
        for (WBNode node : this) {
            if (node instanceof WBNode) {
                WBNodeProxy.nodeToStream(ostr, node);
                continue;
            }
            if (!(node instanceof WBNodeProxy)) continue;
            node.objectToStream(ostr);
        }
    }

    public String streamToString(WBInputStream istr) {
        StringBuffer buf = new StringBuffer();
        try {
            int nodeCount = WBUtils.readShort(istr, "WBNodeList string reads count");
            for (int i = 0; i < nodeCount; ++i) {
                buf.append(this.parent.getContext().getNodeProxy().streamToString(istr));
                if (i >= nodeCount - 1) continue;
                buf.append(", ");
            }
        }
        catch (Exception e) {
            buf.append(" exception: " + e.getMessage());
        }
        return buf.toString();
    }

    @Override
    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("NodeList: realSize=" + this.size() + ", maxKnownIndex: " + this.maxKnownIndex);
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            buf.append(", " + iter.next());
        }
        return buf.toString();
    }
}

