/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.MediaRefCount;
import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.dataModel.MediaData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class MediaItem
implements Comparable {
    private int refCount = 0;
    private HashMap screensReferencing = null;
    private MediaData mediaData = null;
    private HashSet screenUIDs = null;
    private boolean mustCalculateScreenUIDs = true;
    private int mediaIsInTransit = 0;

    public MediaItem(MediaData mediaData) {
        this.setMediaData(mediaData);
    }

    public MediaData getMediaData() {
        return this.mediaData;
    }

    void setMediaData(MediaData mediaData) {
        this.mediaData = mediaData;
    }

    public int getRefCount() {
        return this.refCount;
    }

    public int getScreenReferencingCount() {
        return this.screensReferencing == null ? 0 : this.screensReferencing.size();
    }

    public boolean isDefined() {
        return this.mediaData.getMedia() != null;
    }

    public boolean isInTransit() {
        return this.mediaIsInTransit > 0;
    }

    public void incrementInTransit() {
        ++this.mediaIsInTransit;
    }

    public boolean decrementInTransit() {
        --this.mediaIsInTransit;
        return this.isDefined();
    }

    public int addScreen(Long screenUID) {
        if (screenUID != null) {
            MediaRefCount ref;
            if (this.screensReferencing == null) {
                this.screensReferencing = new HashMap(3);
            }
            if ((ref = (MediaRefCount)this.screensReferencing.get(screenUID)) == null) {
                ref = new MediaRefCount();
                this.screensReferencing.put(screenUID, ref);
            }
            ref.addRef();
        }
        ++this.refCount;
        return this.refCount;
    }

    public int removeScreen(Long screenUID) {
        MediaRefCount ref;
        if (screenUID != null && this.screensReferencing != null && (ref = (MediaRefCount)this.screensReferencing.get(screenUID)) != null) {
            if (ref.removeRef()) {
                this.screensReferencing.remove(screenUID);
            }
            if (this.screensReferencing.isEmpty()) {
                this.screensReferencing = null;
            }
        }
        --this.refCount;
        return this.refCount;
    }

    public HashMap getScreenMap() {
        return this.screensReferencing;
    }

    public int compareTo(Object o) {
        if (o instanceof MediaItem) {
            return this.mediaData.compareTo(((MediaItem)o).getMediaData());
        }
        throw new ClassCastException("Cannot compare '" + o.getClass().getName() + "' to '" + this.getClass().getName());
    }

    public boolean equals(Object o) {
        return o instanceof MediaItem ? this.compareTo(o) == 0 : false;
    }

    public int hashCode() {
        return this.mediaData.hashCode();
    }

    public boolean calculateScreenUIDs() {
        return this.mustCalculateScreenUIDs;
    }

    public void setScreenUIDs(HashSet screenUIDs) {
        this.screenUIDs = screenUIDs;
    }

    public HashSet getScreenUIDs() {
        return this.screenUIDs;
    }

    public void setCalculateScreenUIDs(boolean mustCalculateScreenUIDs) {
        this.mustCalculateScreenUIDs = mustCalculateScreenUIDs;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.mediaData.toString() + " refs=" + this.refCount + ", inTransitCount: " + this.mediaIsInTransit + "\n");
        if (this.screensReferencing != null) {
            for (Map.Entry entry : this.screensReferencing.entrySet()) {
                buf.append(", ref: " + WBUtils.uniqueIDAsHex((Long)entry.getKey()) + "/" + ((MediaRefCount)entry.getValue()).getRefCount());
            }
        }
        return buf.toString();
    }
}

