/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import com.elluminate.groupware.whiteboard.dataModel.Validator;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DisplayModel
extends DefaultTreeModel {
    private ArrayList<JTree> viewers = new ArrayList();
    private JTree[] viewersArray = null;
    private WhiteboardContext context = null;

    public DisplayModel(DisplayNode root, WhiteboardContext context) {
        this(root, false, context);
    }

    public DisplayModel(DisplayNode root, boolean asksAllowsChildren, WhiteboardContext context) {
        super(root, asksAllowsChildren);
        if (root == null) {
            throw new IllegalArgumentException("root is null");
        }
        this.root = root;
        this.asksAllowsChildren = asksAllowsChildren;
        this.context = context;
        root.setDisplayModel(this);
    }

    public DisplayNode getDisplayRoot() {
        return (DisplayNode)this.getRoot();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        this.context.getDataModel().valueForPathChanged(path, newValue);
    }

    public synchronized void addViewer(JTree viewer) {
        this.viewers.add(viewer);
        this.viewersArray = null;
    }

    public synchronized void removeViewer(JTree viewer) {
        this.viewers.remove(viewer);
        this.viewersArray = null;
    }

    public synchronized JTree[] getViewers() {
        if (this.viewersArray == null) {
            this.viewersArray = new JTree[this.viewers.size()];
            this.viewersArray = this.viewers.toArray(this.viewersArray);
        }
        return this.viewersArray;
    }

    public int getViewersCount() {
        return this.viewers == null ? 0 : this.viewers.size();
    }

    public boolean validate() {
        boolean valid = true;
        if (this.getRoot() instanceof DisplayNode) {
            DisplayNode root = (DisplayNode)this.getRoot();
            if (root.getDisplayModel() != this) {
                Validator.log(this.getClass().getName() + ": root does not have valid DisplayModel.");
            }
            valid &= root.validate();
        } else {
            Validator.log(this.getClass().getName() + ": root is not a DisplayNode.");
            valid = Validator.setValid(valid, false);
        }
        return valid;
    }
}

