/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.conference.ViewedScreensListener;
import com.elluminate.groupware.whiteboard.conference.Viewing;
import com.elluminate.groupware.whiteboard.dataModel.DataModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.util.log.LogSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ViewedScreens {
    public static final boolean DEBUG_VIEWED_SCREENS = false;
    HashMap viewedByScreen = new HashMap();
    LinkedList screensByImportance = new LinkedList();
    HashMap screensByClientId = new HashMap();
    LinkedList viewedScreenListeners = new LinkedList();
    WhiteboardContext context;

    public ViewedScreens(WhiteboardContext context) {
        this.context = context;
    }

    public int getUniqueScreenCount() {
        return this.viewedByScreen.size();
    }

    public int screenViewerCount(Long screenUID) {
        ScreenViewerList viewersList = (ScreenViewerList)this.viewedByScreen.get(screenUID);
        if (viewersList == null) {
            return -1;
        }
        return viewersList.size();
    }

    List getViewedScreens() {
        return this.screensByImportance;
    }

    public boolean isScreenViewed(Long screenUID) {
        return screenUID == null ? false : this.viewedByScreen.containsKey(screenUID);
    }

    public boolean isScreenViewedByClient(Long screenUID, Short clientId) {
        Set clientScreens = (Set)this.screensByClientId.get(clientId);
        return clientScreens != null && clientScreens.contains(screenUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processViewList(List viewlist) {
        Long leavingUID;
        Long joiningUID;
        Short clientId;
        HashSet<Long> bestSet = new HashSet<Long>();
        for (Viewing viewing : viewlist) {
            clientId = viewing.getClientId();
            joiningUID = viewing.getJoiningUID();
            leavingUID = viewing.getLeavingUID();
            if (leavingUID != null) {
                this.removeOneScreen(leavingUID, clientId);
                bestSet.add(leavingUID);
            }
            if (joiningUID == null) continue;
            this.addOneScreen(joiningUID, clientId);
            bestSet.add(joiningUID);
        }
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (this.screensByImportance.size() > 1) {
                Collections.sort(this.screensByImportance);
            }
        }
        for (Viewing viewing : viewlist) {
            ScreenViewerList viewersList;
            clientId = viewing.getClientId();
            joiningUID = viewing.getJoiningUID();
            leavingUID = viewing.getLeavingUID();
            if (leavingUID != null) {
                viewersList = (ScreenViewerList)this.viewedByScreen.get(leavingUID);
                for (ViewedScreensListener listener : this.viewedScreenListeners) {
                    listener.onRemoveViewedScreensChange(leavingUID, viewersList, clientId);
                }
            }
            if (joiningUID == null) continue;
            viewersList = (ScreenViewerList)this.viewedByScreen.get(joiningUID);
            for (ViewedScreensListener listener : this.viewedScreenListeners) {
                listener.onAddViewedScreensChange(joiningUID, viewersList, clientId);
            }
        }
        for (Long screenUID : bestSet) {
            this.context.getDataExporter().invalidateBestScreen(screenUID);
        }
        this.fireViewedChange();
    }

    public Iterator viewedScreenListIterator() {
        return new ScreenIterator(this.screensByImportance.iterator());
    }

    public Set getScreensForClient(Short clientId) {
        return (Set)this.screensByClientId.get(clientId);
    }

    public boolean isEmpty() {
        return this.screensByClientId.isEmpty();
    }

    public void removeViewer(Short clientId) {
        Set clientsSet = (Set)this.screensByClientId.get(clientId);
        if (clientsSet != null) {
            Object[] screenUIDs = clientsSet.toArray();
            for (int i = 0; i < screenUIDs.length; ++i) {
                while (this.isScreenViewedByClient((Long)screenUIDs[i], clientId)) {
                    this.removeViewedScreen((Long)screenUIDs[i], clientId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeViewedScreen(Long screenUID, Short clientId) {
        if (this.removeOneScreen(screenUID, clientId)) {
            DataModel dataModel = this.context.getDataModel();
            synchronized (dataModel) {
                if (this.screensByImportance.size() > 1) {
                    Collections.sort(this.screensByImportance);
                }
            }
            ScreenViewerList viewersList = (ScreenViewerList)this.viewedByScreen.get(screenUID);
            for (ViewedScreensListener listener : this.viewedScreenListeners) {
                listener.onRemoveViewedScreensChange(screenUID, viewersList, clientId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeOneScreen(Long screenUID, Short clientId) {
        ScreenViewerList viewersList;
        if (screenUID == null) {
            return false;
        }
        Set clientsSet = (Set)this.screensByClientId.get(clientId);
        if (clientsSet == null) {
            return false;
        }
        clientsSet.remove(screenUID);
        if (clientsSet.isEmpty()) {
            this.screensByClientId.remove(clientId);
        }
        if ((viewersList = (ScreenViewerList)this.viewedByScreen.get(screenUID)) == null) {
            return true;
        }
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            viewersList.remove(clientId);
            if (viewersList.isEmpty()) {
                this.viewedByScreen.remove(screenUID);
                this.screensByImportance.remove(viewersList);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addViewedScreen(Long screenUID, Short clientId) {
        if (this.addOneScreen(screenUID, clientId)) {
            DataModel dataModel = this.context.getDataModel();
            synchronized (dataModel) {
                if (this.screensByImportance.size() > 1) {
                    Collections.sort(this.screensByImportance);
                }
            }
            ScreenViewerList viewersList = (ScreenViewerList)this.viewedByScreen.get(screenUID);
            for (ViewedScreensListener listener : this.viewedScreenListeners) {
                listener.onAddViewedScreensChange(screenUID, viewersList, clientId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addOneScreen(Long screenUID, Short clientId) {
        if (screenUID == null) {
            return false;
        }
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            ScreenViewerList viewersList;
            HashSet<Long> clientsSet = (HashSet<Long>)this.screensByClientId.get(clientId);
            if (clientsSet == null) {
                clientsSet = new HashSet<Long>();
                this.screensByClientId.put(clientId, clientsSet);
            }
            clientsSet.add(screenUID);
            if (clientsSet.size() > 1) {
                // empty if block
            }
            if ((viewersList = (ScreenViewerList)this.viewedByScreen.get(screenUID)) == null) {
                viewersList = new ScreenViewerList(screenUID);
                this.viewedByScreen.put(screenUID, viewersList);
                this.screensByImportance.add(viewersList);
            }
            viewersList.add(clientId);
        }
        return true;
    }

    public void removeScreen(Long screenUID) {
        ScreenViewerList viewersList = (ScreenViewerList)this.viewedByScreen.get(screenUID);
        if (viewersList != null) {
            Short[] clients = new Short[viewersList.size()];
            clients = viewersList.toArray(clients);
            for (int i = 0; i < clients.length; ++i) {
                this.removeViewedScreen(screenUID, clients[i]);
            }
        }
    }

    public void clear() {
        Long[] screenUIDs = new Long[this.viewedByScreen.size()];
        screenUIDs = this.viewedByScreen.keySet().toArray(screenUIDs);
        for (int i = 0; i < screenUIDs.length; ++i) {
            this.removeScreen(screenUIDs[i]);
        }
    }

    public String toString() {
        Iterator iter2;
        StringBuffer buf = new StringBuffer("\nViewedScreens: viewedByScreen:\n");
        for (ScreenViewerList clientsList : this.viewedByScreen.values()) {
            buf.append("  Screen: " + WBUtils.objectName(clientsList.getUID(), this.context) + ", viewed by: ");
            iter2 = clientsList.iterator();
            while (iter2.hasNext()) {
                buf.append((Short)iter2.next());
                if (!iter2.hasNext()) continue;
                buf.append(", ");
            }
            buf.append("\n");
        }
        buf.append(" screensByImportance:\n");
        for (ScreenViewerList clientsList : this.screensByImportance) {
            buf.append("  Screen: " + WBUtils.objectName(clientsList.getUID(), this.context) + ", viewed by: ");
            iter2 = clientsList.iterator();
            while (iter2.hasNext()) {
                buf.append((Short)iter2.next());
                if (!iter2.hasNext()) continue;
                buf.append(", ");
            }
            buf.append("\n");
        }
        buf.append(" screensByClientId:\n");
        for (Map.Entry entry : this.screensByClientId.entrySet()) {
            buf.append("  ClientId: " + entry.getKey() + ": " + ((Set)entry.getValue()).size() + "\n");
            iter2 = ((Set)entry.getValue()).iterator();
            while (iter2.hasNext()) {
                buf.append(WBUtils.objectName((Long)iter2.next(), this.context));
                if (!iter2.hasNext()) continue;
                buf.append("\n   ");
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addViewedListener(ViewedScreensListener l) {
        LinkedList linkedList = this.viewedScreenListeners;
        synchronized (linkedList) {
            if (!this.viewedScreenListeners.contains(l)) {
                this.viewedScreenListeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeViewedListener(ViewedScreensListener l) {
        LinkedList linkedList = this.viewedScreenListeners;
        synchronized (linkedList) {
            this.viewedScreenListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireViewedChange() {
        LinkedList linkedList = this.viewedScreenListeners;
        synchronized (linkedList) {
            for (ViewedScreensListener listener : this.viewedScreenListeners) {
                listener.onViewedChange();
            }
        }
    }

    public class ScreenIterator
    implements Iterator {
        Iterator iter;

        public ScreenIterator(Iterator iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            ScreenViewerList viewerList = (ScreenViewerList)this.iter.next();
            return viewerList.getScreen();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    public class ScreenViewerList
    extends LinkedList
    implements Comparable {
        Long uid;

        public ScreenViewerList(Long uid) {
            this.uid = uid;
            if (uid == null) {
                throw new RuntimeException("create ScreenViewerList with null uid");
            }
        }

        public ScreenModel getScreen() {
            try {
                Object object = ViewedScreens.this.context.getObjectManager().getObjectFromMap(this.uid);
                if (object instanceof ScreenModel) {
                    return (ScreenModel)object;
                }
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"getScreen", (Throwable)ex, (boolean)true);
            }
            return null;
        }

        public Long getUID() {
            return this.uid;
        }

        public int compareTo(Object object) throws ClassCastException {
            if (object instanceof ScreenViewerList) {
                return ((ScreenViewerList)object).size() - this.size();
            }
            throw new ClassCastException("ScreenViewerList cannot compare to: " + object.getClass().getName());
        }
    }
}

