/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.conference.AvailableScreenEntry;
import com.elluminate.groupware.whiteboard.conference.ViewedScreens;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;

class ViewedScreen
implements Comparable {
    static final float NO_SPAN_CHANGE = -2.0f;
    static final float NO_TARGET = -1.0f;
    float span = -1.0f;
    ScreenModel screen = null;
    Long screenUID;
    AvailableScreenEntry target = null;
    ViewedScreens.ScreenViewerList viewedScreensViewers = null;

    public ViewedScreen(Long screenUID, ViewedScreens.ScreenViewerList viewedScreensViewers) {
        this.screenUID = screenUID;
        this.screen = null;
        this.viewedScreensViewers = viewedScreensViewers;
    }

    public int compareTo(Object other) {
        if (this.span < 0.0f) {
            this.span = this.calculateSpan(this.screen, this.span, this.viewedScreensViewers.size());
        }
        return WBUtils.comparison(this.span - ((ViewedScreen)other).span);
    }

    private float calculateSpan(ScreenModel screen, float oldSpan, float externalWeight) {
        float span = Float.MAX_VALUE;
        if (this.target == null || screen == null || this.target.screen.getParent() != screen.getParent() || externalWeight == 0.0f) {
            return -1.0f;
        }
        if (this.target != null) {
            float fwdSpan = (float)(this.target.screen.getIndex() - screen.getIndex()) * 1.0f;
            float bkwdSpan = -1.0f;
            if (this.target.prev != null) {
                bkwdSpan = (float)(screen.getIndex() - this.target.screen.getIndex()) * 2.0f;
            }
            if (fwdSpan >= 0.0f) {
                span = bkwdSpan >= 0.0f ? (fwdSpan > bkwdSpan ? bkwdSpan : fwdSpan) : fwdSpan;
            } else if (bkwdSpan >= 0.0f) {
                span = bkwdSpan;
            }
        }
        span /= (float)this.target.screen.getContext().getDataExporter().getViewedScreens().screenViewerCount(this.target.screen.getObjectID());
        if ((span /= externalWeight) != oldSpan) {
            return -2.0f;
        }
        return span;
    }

    public void dispose() {
        this.screen = null;
        this.target = null;
        this.viewedScreensViewers = null;
    }
}

