/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.comm.AbstractCommContainer;
import com.elluminate.groupware.whiteboard.conference.ClientIdentification;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.util.ShortList;
import com.elluminate.util.log.LogSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class UpdateClientIdentification
extends AbstractCommContainer {
    HashMap addressByClientMap = null;

    public UpdateClientIdentification(WhiteboardContext context) {
        this(context, null, null);
    }

    public UpdateClientIdentification(WhiteboardContext context, HashMap addressByClientMap, HashMap nameByClientMap) {
        super(context, "_UpdateClientIdentification");
        this.addressByClientMap = addressByClientMap;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("UpdateClientIdentification: name: " + this.getName() + ", id: " + this.getRegisteredID());
        return result.toString();
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ostr.writeShort(this.addressByClientMap.size());
        for (Map.Entry entry : this.addressByClientMap.entrySet()) {
            Short clientId = (Short)entry.getKey();
            Short clientAddress = (Short)entry.getValue();
            ostr.writeShort(clientAddress.shortValue());
            ostr.writeShort(clientId.shortValue());
            if (clientId.equals(ClientIdentification.CLIENT_LOCAL)) continue;
            String clientName = this.context.getIDProcessor().getClientName(clientId);
            if (clientName == null) {
                clientName = "";
            }
            ostr.writeUTF(clientName);
        }
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        int clientCount = WBUtils.readShort(istr, "UpdateClientIdentification reads clientCount");
        HashMap<Short, Short> addressByClientMap = new HashMap<Short, Short>(clientCount);
        HashMap<Short, String> nameByClientMap = new HashMap<Short, String>(clientCount);
        for (int i = 0; i < clientCount; ++i) {
            String clientName;
            Short clientAddress = ShortList.get((short)WBUtils.readShort(istr, "UpdateClientIdentification reads clientAddress"));
            Short clientId = ShortList.get((short)WBUtils.readShort(istr, "UpdateClientIdentification reads clientId"));
            if (clientId.equals(ClientIdentification.CLIENT_LOCAL)) {
                clientId = ClientIdentification.SERVER_ID;
                clientName = ClientIdentification.SERVER_NAME;
            } else {
                clientName = WBUtils.readUTF(istr, "UpdateClientIdentification reads clientName");
            }
            addressByClientMap.put(clientId, clientAddress);
            nameByClientMap.put(clientId, clientName);
        }
        this.context.getIDProcessor().updateClientIdentification(addressByClientMap, nameByClientMap);
        return null;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        StringBuffer buf = new StringBuffer(super.streamToString(istr));
        buf.append("\n");
        try {
            int participantCount = WBUtils.readShort(istr, "UpdateClientIdentification reads participantCount");
            for (int i = 0; i < participantCount; ++i) {
                Short clientAddress = WBUtils.readShort(istr, "UpdateClientIdentification reads clientAddress");
                Short clientId = WBUtils.readShort(istr, "UpdateClientIdentification reads clientId");
                String clientName = "";
                if (!clientId.equals(ClientIdentification.CLIENT_LOCAL)) {
                    clientName = WBUtils.readUTF(istr, "UpdateClientIdentification reads clientName");
                }
                buf.append("   client=Id= " + clientId + ", clientAddress= " + clientAddress + ", clientName='" + clientName + "'\n");
            }
        }
        catch (IOException ioe) {
            LogSupport.exception((Object)this, (String)"streamToString", (Throwable)ioe, (boolean)true);
            buf.append("\n  Exception: " + ioe.getMessage());
        }
        return buf.toString();
    }
}

