/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.acl.ACLEntry;
import com.elluminate.groupware.whiteboard.attributes.WBImage;
import com.elluminate.groupware.whiteboard.comm.AbstractCommContainer;
import com.elluminate.groupware.whiteboard.conference.ClientIdentification;
import com.elluminate.groupware.whiteboard.conference.ClientSendsScreenSynch;
import com.elluminate.groupware.whiteboard.conference.GroupManager;
import com.elluminate.groupware.whiteboard.conference.ParticipantData;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.DataModelData;
import com.elluminate.groupware.whiteboard.dataModel.ObjectIDs;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.ControllerPaneInterface;
import com.elluminate.groupware.whiteboard.tools.ImageToolModel;
import com.elluminate.util.ShortList;
import com.elluminate.util.log.LogSupport;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ServerSendsScreenSynch
extends AbstractCommContainer {
    public static final boolean DEBUG = false;
    private static final boolean DEBUG_MEDIA = false;
    private DataModelData clientObjects;
    private Short clientAddress;
    private Short clientId;
    private HashMap clientMedia;

    public ServerSendsScreenSynch(WhiteboardContext context) {
        this(context, new HashMap());
    }

    public ServerSendsScreenSynch(WhiteboardContext context, HashMap clientMedia) {
        super(context, "_ServerSendsScreenSynch");
        this.clientMedia = clientMedia;
    }

    public void noteClientServedScreens(DataModelData clientObjects, short clientAddress, Short clientId) {
        this.clientObjects = clientObjects;
        this.clientAddress = ShortList.get((short)clientAddress);
        this.clientId = clientId;
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        this.context.getDataExporter().blockCodecs();
        super.objectToStream(ostr);
        Short clientId = this.context.getIDProcessor().getClientId(this.clientAddress);
        ostr.writeLong(this.context.getConferenceUID());
        ostr.writeShort(clientId.shortValue());
        DataModelData serverObjects = new DataModelData(this.context, true, true, null, clientId);
        serverObjects.emitDataModel(ostr, true, true, true);
        DataModelData serverSends = new DataModelData(this.context, true, true, this.clientObjects, clientId);
        Collection serverScreens = serverSends.getScreenCollection();
        Collection serverTools = serverSends.getToolCollection();
        Collection proxySet = serverSends.getProxyCollection();
        this.context.getDataExporter().addParticipant(clientId, serverScreens, serverTools, proxySet);
        ParticipantData data = this.context.getDataExporter().getParticipantData(clientId);
        this.context.getDataExporter().emitViewedScreens(ostr, null, clientId);
        this.context.getDataExporter().initializeMedia(this.clientMedia, clientId);
        this.context.getMediaCache().emitDefinedMedia(ostr);
        this.context.getGroupManager().groupsToStream(ostr);
        GroupManager.GroupInfo groupInfo = this.context.getGroupManager().getGroupInfo(GroupManager.MAIN_GROUP_ID);
        Long targetScreen = this.context.getDataModel().getPublicScreens().getObjectID();
        if (groupInfo != null && groupInfo.isFollowInstructor()) {
            Object screenNode = this.context.getObjectManager().getObjectFromMap(groupInfo.getScreenUID());
            if (screenNode instanceof ScreenModel) {
                ScreenModel newTargetScreen = (ScreenModel)screenNode;
                if (newTargetScreen != null && newTargetScreen.getParent() != null) {
                    targetScreen = groupInfo.getScreenUID();
                }
            } else {
                LogSupport.message((Object)this, (String)"objectToStream", (String)("groupInfo.getScreenUID() did not return a screen: " + screenNode));
            }
        }
        ObjectUID.objectUIDToStream(targetScreen, ostr);
        Iterator iter = this.clientObjects.toolEntryIterator();
        while (iter.hasNext()) {
            ImageToolModel imageTool;
            WBImage image;
            WBNode node;
            Map.Entry entry = (Map.Entry)iter.next();
            ObjectIDs uid = (ObjectIDs)entry.getKey();
            if (uid == null || !((node = (WBNode)this.context.getObjectManager().getObjectFromMap(new Long(uid.getUID()))) instanceof ImageToolModel) || (image = (imageTool = (ImageToolModel)node).getImage()) == null || !image.hasImage() || data.isMediaSent(image.getMediaData().getMediaID())) continue;
            imageTool.addMediaRequest(clientId);
        }
        this.context.getDataExporter().unblockCodecs();
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        boolean recurseTheResynch = false;
        boolean clientRejoins = true;
        try {
            this.context.getDataExporter().blockCodecs();
            super.streamToObject(istr);
            long serverConferenceId = WBUtils.readLong(istr, "ServerSendsScreenSynch reads serverConferenceId");
            Short clientId = ShortList.get((short)WBUtils.readShort(istr, "ServerSendsScreenSych reads clientId"));
            this.context.getIDProcessor().addClient(ShortList.get((short)this.context.getClientList().getMyAddress()), clientId, this.context.getClientList().getMyDisplayName());
            istr.setOriginatorId(ClientIdentification.SERVER_ID);
            DataModelData serverObjects = new DataModelData(this.context, istr);
            if (this.context.getConferenceUID() != serverConferenceId) {
                serverObjects.clear();
                clientRejoins = true;
            }
            this.context.setConferenceUID(serverConferenceId);
            List deleteList = serverObjects.getDeleteList(true, false);
            for (WBNode node : deleteList) {
                WBNode nodeParent = node.getParent();
                if (node.getToolCount() > 0 || node.getScreenCount() > 0) {
                    recurseTheResynch = true;
                }
                nodeParent.remove(node);
                node.delete();
            }
            DataModelData clientObjects = new DataModelData(this.context, true, true, serverObjects, clientId);
            Collection clientServedScreens = clientObjects.getScreenCollection();
            Collection clientServedTools = clientObjects.getToolCollection();
            Collection clientProxySet = clientObjects.getProxyCollection();
            this.context.getDataExporter().addParticipant(istr.getOriginatorId(), clientServedScreens, clientServedTools, clientProxySet);
            this.context.getDataExporter().receiveViewedScreens(istr);
            HashMap serverMedia = this.context.getMediaCache().readDefinedMedia(istr);
            this.context.getDataExporter().initializeMedia(serverMedia, ClientIdentification.SERVER_ID);
            ParticipantData data = this.context.getDataExporter().getParticipantData(ClientIdentification.SERVER_ID);
            this.context.getGroupManager().streamToGroups(istr);
            Long targetUID = ObjectUID.objectUIDFromStream(istr);
            Iterator iter = serverObjects.toolEntryIterator();
            while (iter.hasNext()) {
                ImageToolModel imageTool;
                WBImage image;
                WBNode node;
                Map.Entry entry = (Map.Entry)iter.next();
                ObjectIDs uid = (ObjectIDs)entry.getKey();
                if (uid == null || !((node = (WBNode)this.context.getObjectManager().getObjectFromMap(new Long(uid.getUID()))) instanceof ImageToolModel) || (image = (imageTool = (ImageToolModel)node).getImage()).getMediaData() == null || image.getMediaData().getMedia() == null || data.isMediaSent(image.getMediaData().getMediaID())) continue;
                imageTool.addMediaRequest(ClientIdentification.SERVER_ID);
            }
            if (data != null) {
                data.getDataCodec().doWork();
            }
            if (this.context.getController() != null) {
                this.context.getController().changeGroup(this.context.getIDProcessor().getMyId(), ACLEntry.NULL_GROUP, ACLEntry.NULL_GROUP);
                GroupManager.GroupInfo groupInfo = this.context.getGroupManager().getGroupInfo();
            }
            this.context.gotoScreen(targetUID, false);
            if (this.context.getController() != null) {
                this.context.getDataExporter().getViewedScreens().removeViewer(clientId);
                ControllerPaneInterface controller = this.context.getController();
                if (targetUID != null) {
                    Long currentScreen = controller.getScreen().getObjectID();
                    controller.gotoUIScreen(targetUID, false);
                    if (currentScreen != null && currentScreen.equals(targetUID)) {
                        this.context.getDataExporter().addViewedScreen(targetUID);
                    }
                }
            }
            this.context.getDataProcessor().sendDirective((byte)4);
        }
        catch (IOException ioe) {
            LogSupport.exception((Object)this, (String)"streamToObject", (Throwable)ioe, (boolean)true);
        }
        this.context.getDataExporter().unblockCodecs();
        if (recurseTheResynch) {
            ClientSendsScreenSynch synch = new ClientSendsScreenSynch(this.context);
            synch.setOnline(this.context.getIDProcessor().getMyId(), this.context.getConferenceUID(), this.context.getClientList().getMyDisplayName());
            this.context.getDataProcessor().sendDirective((byte)6, synch);
        }
        return null;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        StringBuffer buf = new StringBuffer("\n" + super.streamToString(istr));
        try {
            long serverConferenceId = WBUtils.readLong(istr, "serverSendsScreenSynch tests previous serverConferenceId");
            buf.append(", serverConferenceId: " + serverConferenceId);
            Short clientID = ShortList.get((short)WBUtils.readShort(istr, "serverSendsScreenSynch reads clientID (test)"));
            buf.append(", clientID: " + clientID + "\n");
            buf.append(DataModelData.streamToString(istr));
            Long screenUID = null;
            screenUID = ObjectUID.objectUIDFromStream(istr);
            while (screenUID != null) {
                short clientId = WBUtils.readShort(istr, " DataExporter.receiveViewedScreen: read clientId");
                buf.append(" DataExporter.receiveViewedScreen: read screenUID+ " + screenUID);
                buf.append(": read clientId + " + clientId);
                buf.append("\n");
                screenUID = ObjectUID.objectUIDFromStream(istr);
            }
            HashMap serverMedia = this.context.getMediaCache().readDefinedMedia(istr);
            buf.append("media cache count = " + serverMedia.keySet().size() + "\n");
            Set mediaSet = serverMedia.keySet();
            for (Object next : mediaSet) {
                buf.append(next + ": " + serverMedia.get(next));
            }
            int groupCount = WBUtils.readShort(istr, "GroupManager.streamToGroups reads group count");
            buf.append("\ngroup count = " + groupCount);
            for (int i = 0; i < groupCount; ++i) {
                Short groupId = ShortList.get((short)WBUtils.readShort(istr, "GroupInfo reads groupId"));
                boolean followInstructor = WBUtils.readBoolean(istr, "GroupInfo reads followInstructor");
                screenUID = ObjectUID.objectUIDFromStream(istr);
                buf.append("\nGroup ID: " + groupId);
                buf.append(", Follow Instructor: " + followInstructor);
                buf.append(", Screen UID: " + screenUID);
            }
            Long targetUID = ObjectUID.objectUIDFromStream(istr);
            buf.append("  sent to screen: " + WBUtils.uniqueIDAsHex(targetUID));
        }
        catch (Exception e) {
            buf.append("\n  Exception: " + e.getMessage());
        }
        buf.append("\n*****************************************************************");
        return buf.toString();
    }
}

