/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.comm.AbstractCommContainer;
import com.elluminate.groupware.whiteboard.conference.ClientIdentification;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.interfaces.StreamableObject;
import com.elluminate.util.ShortList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class SendFollowInstructor
extends AbstractCommContainer {
    static final String SEND_FOLLOW_INSTRUCTOR_TEMPLATE_NAME = "_SendFollowInstructor";
    boolean setting = false;
    Long screenUID = null;
    Short groupId;

    public SendFollowInstructor(WhiteboardContext context) {
        super(context, SEND_FOLLOW_INSTRUCTOR_TEMPLATE_NAME);
    }

    public SendFollowInstructor(WhiteboardContext context, Short groupId, boolean setting) {
        this(context);
        this.groupId = groupId;
        this.setting = setting;
    }

    public SendFollowInstructor(WhiteboardContext context, Short groupId, boolean setting, Long screenUID) {
        this(context, groupId, setting);
        this.screenUID = screenUID;
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ostr.writeShort(this.groupId.shortValue());
        ostr.writeBoolean(this.setting);
        ObjectUID.objectUIDToStream(this.screenUID, ostr);
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        WhiteboardContext context = istr.getContext();
        super.streamToObject(istr);
        Short groupId = ShortList.get((short)WBUtils.readShort(istr, "SendFollowInstructor reads client groupId"));
        boolean setting = WBUtils.readBoolean(istr, "SendFollowInstructor reads setting");
        Long screenUID = ObjectUID.objectUIDFromStream(istr);
        if (context.getGroupManager() != null) {
            if (setting) {
                context.getGroupManager().setFollowInstructor(groupId, screenUID);
            } else {
                context.getGroupManager().clearFollowInstructor(groupId);
            }
        }
        if (context.isClient()) {
            if (context.getController() != null && context.getIDProcessor().getMyGroupId().equals(groupId)) {
                context.getController().setFollowInstructor(setting);
                if (setting) {
                    context.getController().gotoConferenceScreen(screenUID);
                }
            } else if (!context.isPlayback()) {
                context.gotoScreen(screenUID, false);
            }
        } else {
            LinkedList<Short> targetList = new LinkedList<Short>();
            Iterator iter = context.getIDProcessor().getClientIdEntryIterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                Short clientId = (Short)entry.getValue();
                Short clientGroup = context.getIDProcessor().getGroupId(clientId);
                if (clientId.equals(istr.getOriginatorId()) || clientId.equals(ClientIdentification.CLIENT_LOCAL)) continue;
                Short clientAddress = context.getIDProcessor().getClientAddress(clientId);
                targetList.add(clientAddress);
            }
            short[] targetArray = new short[targetList.size()];
            int index = 0;
            iter = targetList.iterator();
            while (iter.hasNext()) {
                targetArray[index++] = (Short)iter.next();
            }
            SendFollowInstructor sfi = new SendFollowInstructor(context, groupId, setting, screenUID);
            context.getDataProcessor().sendDirective((byte)5, (StreamableObject)sfi, targetArray);
        }
        return null;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        StringBuffer buf = new StringBuffer(super.streamToString(istr));
        try {
            Short groupId = ShortList.get((short)WBUtils.readShort(istr, "GoToScreen reads client groupId"));
            boolean setting = WBUtils.readBoolean(istr, "SendFollowInstructor reads setting");
            Long screenUID = ObjectUID.objectUIDFromStream(istr);
            buf.append(this.getName() + " reads follow instructor: " + screenUID + ", for group: " + groupId + ", set to: " + setting);
        }
        catch (Exception e) {
            buf.append(this.getName() + " gets Exception: " + e.getMessage());
        }
        return buf.toString();
    }
}

