/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.conference.AttributeChange;
import com.elluminate.groupware.whiteboard.conference.ParticipantData;
import com.elluminate.groupware.whiteboard.dataModel.DataModel;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.Validator;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.util.Debug;
import com.elluminate.util.log.LogSupport;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class ScreenExportData {
    static final boolean DEBUG_PRINT = false;
    private HashMap toolsToServe;
    private HashMap attributesToServe;
    private HashMap screenProxies = new HashMap(3);
    private HashMap toolProxies = new HashMap(3);
    private ParticipantData participantData = null;
    private WhiteboardContext context = null;
    private ScreenModel screen = null;

    public ScreenExportData(WhiteboardContext context, ParticipantData participantData, ScreenModel screen) {
        this.context = context;
        this.participantData = participantData;
        this.screen = screen;
        this.toolsToServe = null;
        this.attributesToServe = null;
    }

    public ScreenModel getScreen() {
        return this.screen;
    }

    public HashMap getScreenProxies() {
        return this.screenProxies;
    }

    public HashMap getToolProxies() {
        return this.toolProxies;
    }

    boolean addScreenProxy(WBNode node) {
        if (!node.isNodeReplacingProxy() && this.participantData.isContainerSent(node.getParent())) {
            this.participantData.addScreensWithProxies(node.getParent(), this);
            return this.screenProxies.put(node, new Integer(node.getIndex())) == null;
        }
        return false;
    }

    public boolean containsScreenProxy(WBNode node) {
        return this.screenProxies.containsKey(node);
    }

    public Integer getScreenProxyIndex(WBNode node) {
        return (Integer)this.screenProxies.get(node);
    }

    public void removeScreenProxy(WBNode node) {
        this.screenProxies.remove(node);
        this.cleanExportData();
    }

    public void cleanExportData() {
        if (this.toolProxies.isEmpty() && this.screenProxies.isEmpty()) {
            this.participantData.getScreensWithProxies().remove(this.screen);
            if ((this.toolsToServe == null || this.toolsToServe.isEmpty()) && (this.attributesToServe == null || this.attributesToServe.isEmpty())) {
                this.participantData.removeScreenExportData(this.screen);
            }
        }
    }

    boolean addTool(WBNode tool, boolean createProxy) {
        Long toolId;
        if (tool.isReparenting()) {
            if (createProxy) {
                this.toolProxies.put(tool.getObjectID(), new Integer(tool.getIndex()));
                this.participantData.addScreensWithProxies(this.screen, this);
            }
            tool.setNodeReparenting(false);
            return true;
        }
        if (this.toolsToServe == null) {
            this.toolsToServe = new HashMap();
        }
        if (this.toolsToServe.put(toolId = tool.getObjectID(), tool) == null) {
            if (this.attributesToServe != null) {
                if (this.attributesToServe.remove(toolId) == null) {
                    // empty if block
                }
                this.cleanExportData();
            }
            if (createProxy && !tool.isNodeReplacingProxy()) {
                this.addToolProxy(tool);
            }
            return true;
        }
        return false;
    }

    boolean addToolProxy(WBNode node) {
        WBNode toolParent = node.getParent();
        if (toolParent.isContainer() && this.participantData.isContainerSent(toolParent)) {
            this.toolProxies.put(node.getObjectID(), new Integer(node.getIndex()));
            this.participantData.addScreensWithProxies(this.screen, this);
            return true;
        }
        return false;
    }

    public boolean containsToolProxy(WBNode node) {
        return this.toolProxies.containsKey(node.getObjectID());
    }

    public Integer getToolProxyIndex(WBNode node) {
        return (Integer)this.toolProxies.get(node.getObjectID());
    }

    public void removeToolProxy(WBNode node) {
        if (this.toolProxies.remove(node.getObjectID()) == null) {
            LogSupport.message((Object)this, (String)"removeToolProxy", (String)("node not removed from toolProxies: " + node));
        }
        this.cleanExportData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeTool(WBNode tool) {
        boolean toolRemoved = false;
        Debug.lockEnter((Object)this, (String)"ScreenExportData.removeTool", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            Long toolId = tool.getObjectID();
            if (this.toolsToServe != null) {
                boolean bl = toolRemoved = this.toolsToServe.remove(toolId) != null;
                if (toolRemoved && this.toolsToServe.isEmpty()) {
                    this.toolsToServe = null;
                }
            }
            if (!toolRemoved && this.attributesToServe != null && this.attributesToServe.remove(tool.getObjectID()) != null && this.attributesToServe.isEmpty()) {
                this.attributesToServe = null;
            }
            this.toolProxies.remove(tool.getObjectID());
            if (this.participantData.isContainerSent(tool.getParent()) && this.toolProxies.isEmpty() && this.screenProxies.isEmpty()) {
                this.participantData.getScreensWithProxies().remove(this.screen);
            }
            this.cleanExportData();
        }
        Debug.lockLeave((Object)this, (String)"ScreenExportData.removeTool", (String)"DataModel", (Object)this.context.getDataModel());
        return toolRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttribute(AbstractAttribute attribute) {
        Debug.lockEnter((Object)this, (String)"ScreenExportData.addAttribute", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            AttributeChange attributeChange;
            Long objectId = attribute.getParent().getObjectID();
            if (attribute.getParent() instanceof AbstractToolModel && this.toolsToServe != null && this.toolsToServe.containsKey(objectId)) {
                Debug.lockLeave((Object)this, (String)"ScreenExportData.addAttribute", (String)"DataModel", (Object)this.context.getDataModel());
                return;
            }
            if (this.attributesToServe == null) {
                this.attributesToServe = new HashMap();
            }
            if ((attributeChange = (AttributeChange)this.attributesToServe.get(objectId)) == null) {
                attributeChange = new AttributeChange(this.context, objectId);
                this.attributesToServe.put(objectId, attributeChange);
            }
            attributeChange.addAttribute(attribute);
        }
        Debug.lockLeave((Object)this, (String)"ScreenExportData.addAttribute", (String)"DataModel", (Object)this.context.getDataModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAttribute(AbstractAttribute attribute) {
        boolean result = false;
        if (this.attributesToServe == null) {
            return false;
        }
        Debug.lockEnter((Object)this, (String)"ScreenExportData.removeAttribute", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            Long objectId = attribute.getParent().getObjectID();
            AttributeChange attributeChange = (AttributeChange)this.attributesToServe.get(objectId);
            if (attributeChange != null) {
                if (!attributeChange.removeAttribute(attribute)) {
                    LogSupport.message((Object)this, (String)"removeAttribute", (String)"Did not remove attribute change");
                } else {
                    result = true;
                }
                if (attributeChange.isEmpty()) {
                    if (this.attributesToServe.remove(objectId) == null) {
                        LogSupport.message((Object)this, (String)"removeAttribute", (String)("attribute not removed from screensWithData: " + attribute));
                    } else {
                        result = true;
                    }
                    if (this.attributesToServe.isEmpty()) {
                        this.attributesToServe = null;
                    }
                }
            }
            this.cleanExportData();
        }
        Debug.lockLeave((Object)this, (String)"ScreenExportData.removeAttribute", (String)"DataModel", (Object)this.context.getDataModel());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeAttributes(WBNode node) {
        boolean result = false;
        Debug.lockEnter((Object)this, (String)"ScreenExportData.removeAttributes", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (this.attributesToServe != null) {
                boolean bl = result = this.attributesToServe.remove(node.getObjectID()) != null;
                if (this.attributesToServe.isEmpty()) {
                    this.attributesToServe = null;
                }
            }
        }
        Debug.lockLeave((Object)this, (String)"ScreenExportData.removeAttributes", (String)"DataModel", (Object)this.context.getDataModel());
        return result;
    }

    public boolean hasWork() {
        return this.attributesToServe != null && !this.attributesToServe.isEmpty() || this.toolsToServe != null && !this.toolsToServe.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAttributeChange(AttributeChange attributeChange) {
        boolean result = false;
        Debug.lockEnter((Object)this, (String)"ScreenExportData.removeAttributeChange", (String)"DataModel", (Object)this.context.getDataModel());
        try {
            DataModel dataModel = this.context.getDataModel();
            synchronized (dataModel) {
                block9: {
                    if (this.attributesToServe != null && !this.attributesToServe.isEmpty()) break block9;
                    Debug.lockLeave((Object)this, (String)"ScreenExportData.removeAttributeChange", (String)"DataModel", (Object)this.context.getDataModel());
                    boolean bl = false;
                    return bl;
                }
                boolean bl = result = this.attributesToServe.remove(attributeChange.getParent().getObjectID()) != null;
                if (this.attributesToServe.isEmpty()) {
                    this.attributesToServe = null;
                }
                this.cleanExportData();
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"ScreenExportData.removeAttributeChange", (String)"DataModel", (Object)this.context.getDataModel());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeChange getBestAttributeChange() {
        if (this.attributesToServe == null || this.attributesToServe.isEmpty()) {
            return null;
        }
        AttributeChange attributeChange = null;
        Debug.lockEnter((Object)this, (String)"ScreenExportData.getBestAttributeChange", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            Iterator iter = this.attributesToServe.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Long objectId = (Long)entry.getKey();
                try {
                    this.context.getObjectManager().getObjectFromMap(objectId);
                    attributeChange = (AttributeChange)entry.getValue();
                    if (attributeChange.getParent() == null || attributeChange.getParent().isDeleted()) {
                        LogSupport.message((Object)this, (String)"getBestAttributeChange", (String)("ScreenExportData finds attributes for deleted node: " + attributeChange));
                        iter.remove();
                    }
                    Debug.lockLeave((Object)this, (String)"ScreenExportData.attributeChange", (String)"DataModel", (Object)this.context.getDataModel());
                    return attributeChange;
                }
                catch (Exception ex) {
                    LogSupport.exception((Object)this, (String)"getBestAttributeChange", (Throwable)ex, (boolean)true);
                }
            }
        }
        Debug.lockLeave((Object)this, (String)"ScreenExportData.attributeChange", (String)"DataModel", (Object)this.context.getDataModel());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WBNode getBestTool() {
        WBNode result = null;
        Debug.lockEnter((Object)this, (String)"ScreenExportData.getBestTool", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (this.toolsToServe != null && !this.toolsToServe.isEmpty()) {
                for (Map.Entry entry : this.toolsToServe.entrySet()) {
                    try {
                        WBNode tool = (WBNode)entry.getValue();
                        if (result != null && tool.getIndex() <= result.getIndex()) continue;
                        result = tool;
                        break;
                    }
                    catch (Exception ex) {
                        LogSupport.exception((Object)this, (String)"getBestTool", (Throwable)ex, (boolean)true);
                    }
                }
            }
        }
        Debug.lockLeave((Object)this, (String)"ScreenExportData.getBestTool", (String)"DataModel", (Object)this.context.getDataModel());
        if (result.isProxy()) {
            Validator.log("getBestTool returns: " + WBUtils.objectName(result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTool(AbstractToolModel tool) {
        if (this.toolsToServe == null) {
            return false;
        }
        boolean result = false;
        Debug.lockEnter((Object)this, (String)"ScreenExportData.hasTool", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            result = this.toolsToServe.containsKey(tool.getObjectID());
        }
        Debug.lockLeave((Object)this, (String)"ScreenExportData.hasTool", (String)"DataModel", (Object)this.context.getDataModel());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        boolean printedScreen = false;
        StringBuffer buf = new StringBuffer("  SCREEN: " + this.screen.getScreenName());
        Debug.lockEnter((Object)this, (String)"ScreenExportData.toString", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            buf.append("\n ScreenExportData: ToolsToServe");
            if (this.toolsToServe != null) {
                Set tools = this.toolsToServe.keySet();
                for (Long objectId : tools) {
                    WBNode tool = (WBNode)this.toolsToServe.get(objectId);
                    if (!printedScreen && tool.findScreenParent() != null) {
                        buf.append(": for Screen - " + WBUtils.objectName(tool.findScreenParent()));
                        printedScreen = true;
                    } else {
                        buf.append(": within data for Screen -" + this.screen.getScreenName());
                        printedScreen = true;
                    }
                    buf.append("\n  Tool:" + WBUtils.uniqueIDAsHex(objectId) + ", " + WBUtils.objectName(tool));
                }
            }
            buf.append("\n ScreenExportData: AttributesToServe\n");
            if (this.attributesToServe != null) {
                Set attributes = this.attributesToServe.keySet();
                for (Long objectId : attributes) {
                    AttributeChange attributeChange = (AttributeChange)this.attributesToServe.get(objectId);
                    buf.append("\n  Node:" + WBUtils.uniqueIDAsHex(objectId) + ", attributes: " + attributeChange.toString());
                }
            }
            buf.append("\n ScreenExportData: ScreenProxies\n");
            if (this.screenProxies != null) {
                for (Map.Entry entry : this.screenProxies.entrySet()) {
                    WBNode node = (WBNode)entry.getKey();
                    buf.append("Node: " + WBUtils.objectName(node) + ", index: " + entry.getValue() + "\n");
                }
            }
            buf.append("\n ScreenExportData: ToolProxies\n");
            if (this.toolProxies != null) {
                for (Map.Entry entry : this.toolProxies.entrySet()) {
                    Long uid = (Long)entry.getKey();
                    buf.append("Node: " + WBUtils.objectName(uid, this.context) + ", index: " + entry.getValue() + "\n");
                }
            }
            if (buf.length() > 0) {
                buf.append("\n");
            }
        }
        Debug.lockLeave((Object)this, (String)"ScreenExportData.toString", (String)"DataModel", (Object)this.context.getDataModel());
        return buf.toString();
    }

    public boolean validate(Short clientId, ScreenModel hostScreen) {
        if (this.toolsToServe == null) {
            return true;
        }
        boolean valid = true;
        if (this.screen == null) {
            Validator.log("Validate ScreenExportData: screen is null");
            valid = Validator.setValid(valid, false);
        } else {
            if (this.screen.getParent() == null) {
                Validator.log("Validate ScreenExportData: screen parent is null");
                valid = Validator.setValid(valid, false);
            }
            if (this.screen.getScreenName() == null) {
                Validator.log("Validate ScreenExportData: screen name is null");
                valid = Validator.setValid(valid, false);
            }
        }
        if (!valid) {
            Thread.dumpStack();
        }
        for (Map.Entry entry : this.toolsToServe.entrySet()) {
            Long objectID = (Long)entry.getKey();
            AbstractToolModel tool = (AbstractToolModel)entry.getValue();
            try {
                RegisteredTemplate template = (RegisteredTemplate)this.context.getObjectManager().getObjectFromMap(objectID);
                if (template == null) {
                    Validator.log("Validate ScreenExportData.tools(" + clientId + ", screen: " + hostScreen.getScreenName() + "): null template for tool: " + WBUtils.objectName(tool));
                    valid = Validator.setValid(valid, false);
                    continue;
                }
                if (template != tool) {
                    Validator.log("Validate ScreenExportData.tools(" + clientId + ", screen: " + hostScreen.getScreenName() + "): key reference does not equal value's tool: " + WBUtils.objectName(tool));
                    valid = Validator.setValid(valid, false);
                    continue;
                }
                valid &= tool.validate();
            }
            catch (Exception e) {
                Validator.log("Exception(" + clientId + "): " + e.getMessage() + "while evaluation ObjectID of Tool in ScreenExportData.tools(" + clientId + ", screen: " + hostScreen.getScreenName());
                valid = Validator.setValid(valid, false);
            }
        }
        if (!valid) {
            Validator.log("Validate ScreenExportData(" + clientId + ") ERROR.");
        }
        return valid;
    }
}

