/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.comm.AbstractCommContainer;
import com.elluminate.groupware.whiteboard.conference.ClientIdentification;
import com.elluminate.groupware.whiteboard.conference.Viewing;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.util.ShortList;
import com.elluminate.util.log.LogSupport;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class NoteScreenViewing
extends AbstractCommContainer
implements Cloneable {
    private static final int SINGLE_ENTRY_LENGTH = 2;
    private static final int BLOCK_LENGTH = 8;
    private static final Long LONG_ZERO = new Long(0L);
    private HashMap clientJoinMap = new HashMap();
    private HashMap clientLeaveMap = new HashMap();
    private byte[] compiledOutput = null;
    private HashMap leaveJoinMap = new HashMap();

    public NoteScreenViewing(WhiteboardContext context) {
        super(context, "_NoteScreenViewing");
    }

    public void addViewing(Long leavingUID, Long joiningUID, Short clientId) {
        ScreenRef leaveRefJoin;
        Long joinUID;
        Long leaveUID = leavingUID == null ? LONG_ZERO : new Long(leavingUID);
        Long l = joinUID = joiningUID == null ? LONG_ZERO : new Long(joiningUID);
        if (leaveUID.equals(joinUID)) {
            return;
        }
        HashMap joinMap = this.get(this.clientJoinMap, clientId);
        HashMap leaveMap = this.get(this.clientLeaveMap, clientId);
        ScreenRef joinRefJoin = this.incrementRefCount(joinMap, joinUID);
        ScreenRef leaveRefLeave = this.incrementRefCount(leaveMap, leaveUID);
        ScreenRef joinRefLeave = (ScreenRef)joinMap.get(leaveUID);
        if (joinRefLeave != null) {
            if (--joinRefLeave.count == 0) {
                joinMap.remove(leaveUID);
            }
            if (--leaveRefLeave.count == 0) {
                leaveMap.remove(leaveUID);
            }
        }
        if ((leaveRefJoin = (ScreenRef)leaveMap.get(joinUID)) != null) {
            if (--leaveRefJoin.count == 0) {
                leaveMap.remove(joinUID);
            }
            if (--joinRefJoin.count == 0) {
                joinMap.remove(joinUID);
            }
        }
    }

    private ScreenRef incrementRefCount(Map map, Long uid) {
        ScreenRef ref = (ScreenRef)map.get(uid);
        if (ref == null) {
            ref = new ScreenRef(uid);
            map.put(uid, ref);
        } else {
            ++ref.count;
        }
        return ref;
    }

    private HashMap get(Map map, Object key) {
        HashMap m = (HashMap)map.get(key);
        if (m == null) {
            m = new HashMap();
            map.put(key, m);
        }
        return m;
    }

    private void buildOutput() {
        for (Map.Entry clientJoinEntry : this.clientJoinMap.entrySet()) {
            Short clientId = (Short)clientJoinEntry.getKey();
            HashMap joinMap = (HashMap)clientJoinEntry.getValue();
            HashMap leaveMap = (HashMap)this.clientLeaveMap.get(clientJoinEntry.getKey());
            Iterator screenJoinIter = joinMap.values().iterator();
            Iterator screenLeaveIter = leaveMap.values().iterator();
            ScreenRef screenJoinRef = null;
            ScreenRef screenLeaveRef = null;
            while (screenJoinIter.hasNext() && screenLeaveIter.hasNext()) {
                if (screenJoinRef == null || screenJoinRef.count == 0) {
                    screenJoinRef = (ScreenRef)screenJoinIter.next();
                }
                if (screenLeaveRef == null || screenLeaveRef.count == 0) {
                    screenLeaveRef = (ScreenRef)screenLeaveIter.next();
                }
                this.buildView(clientId, screenJoinRef.screenUID, screenLeaveRef.screenUID);
                --screenJoinRef.count;
                if (screenJoinRef.count == 0) {
                    screenJoinIter.remove();
                }
                --screenLeaveRef.count;
                if (screenLeaveRef.count != 0) continue;
                screenLeaveIter.remove();
            }
        }
        this.clientJoinMap.clear();
        this.clientLeaveMap.clear();
    }

    private void buildView(Short clientId, Long joinUID, Long leaveUID) {
        RefCount refCount;
        Viewing viewing = new Viewing(leaveUID, joinUID);
        TreeMap<Short, RefCount> clientRefMap = (TreeMap<Short, RefCount>)this.leaveJoinMap.get(viewing);
        if (clientRefMap == null) {
            clientRefMap = new TreeMap<Short, RefCount>();
            this.leaveJoinMap.put(viewing, clientRefMap);
        }
        if ((refCount = (RefCount)clientRefMap.get(clientId)) == null) {
            refCount = new RefCount(1, clientId);
            clientRefMap.put(clientId, refCount);
        } else {
            refCount.addCount(1);
        }
    }

    @Override
    public Object clone() {
        NoteScreenViewing nsv = new NoteScreenViewing(this.context);
        for (Map.Entry entry : this.leaveJoinMap.entrySet()) {
            TreeMap tree = new TreeMap();
            for (Map.Entry treeEntry : ((TreeMap)entry.getValue()).entrySet()) {
                tree.put(treeEntry.getKey(), ((RefCount)treeEntry.getValue()).clone());
            }
            nsv.leaveJoinMap.put(entry.getKey(), tree);
        }
        return nsv;
    }

    public boolean isEmpty() {
        return this.clientJoinMap.isEmpty();
    }

    public int entryCount() {
        return this.clientJoinMap.size();
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        LinkedList<Viewing> viewList = new LinkedList<Viewing>();
        WhiteboardContext context = istr.getContext();
        try {
            super.streamToObject(istr);
            block2: while (istr.available() >= 8) {
                Short clientId = ShortList.get((short)WBUtils.readClientId(istr, "NoteScreenViewing reads clientId"));
                Long leavingUID = ObjectUID.objectUIDFromStream(istr);
                Long joiningUID = ObjectUID.objectUIDFromStream(istr);
                if (!context.isClient() && !context.isMe(clientId)) {
                    context.getDataExporter().addAggregateScreenViewing(clientId, leavingUID, joiningUID);
                    continue;
                }
                this.noteViewing(viewList, leavingUID, joiningUID, clientId);
                while (istr.available() >= 2) {
                    short prevClientId = clientId;
                    clientId = ShortList.get((short)WBUtils.readClientId(istr, "NoteScreenViewing reads clientId List"));
                    if (clientId.equals(ClientIdentification.LIST_EOL)) continue block2;
                    if (clientId.equals(ClientIdentification.LIST_SPAN)) {
                        clientId = ShortList.get((short)WBUtils.readClientId(istr, "NoteScreenViewing reads clientId List Span"));
                        for (prevClientId = (short)(prevClientId + 1); prevClientId <= clientId; prevClientId = (short)(prevClientId + 1)) {
                            this.noteViewing(viewList, leavingUID, joiningUID, ShortList.get((short)prevClientId));
                        }
                        continue;
                    }
                    this.noteViewing(viewList, leavingUID, joiningUID, clientId);
                }
            }
            if (!viewList.isEmpty()) {
                context.getDataExporter().processViewList(viewList);
            }
        }
        catch (IOException ioe) {
            LogSupport.exception((Object)this, (String)"streamToObject", (Throwable)ioe, (boolean)true);
        }
        return null;
    }

    private void noteViewing(List viewList, Long leavingUID, Long joiningUID, Short clientId) {
        if (this.context.getIDProcessor().isLocalClient(clientId)) {
            return;
        }
        viewList.add(new Viewing(leavingUID, joiningUID, clientId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        NoteScreenViewing noteScreenViewing = this;
        synchronized (noteScreenViewing) {
            if (this.compiledOutput == null) {
                ByteArrayOutputStream bostr = new ByteArrayOutputStream();
                DataOutputStream dstr = new DataOutputStream(new BufferedOutputStream(bostr));
                this.buildOutput();
                Iterator iter = this.leaveJoinMap.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry leaveJoinEntry = iter.next();
                    NoteScreenViewing.emitMapEntry(dstr, (Viewing)leaveJoinEntry.getKey(), (TreeMap)leaveJoinEntry.getValue());
                    if (!iter.hasNext()) continue;
                    dstr.writeShort(-4);
                }
                dstr.close();
                this.compiledOutput = bostr.toByteArray();
            }
        }
        ostr.write(this.compiledOutput);
    }

    private static void emitMapEntry(DataOutputStream dstr, Viewing viewing, TreeMap clientRefMap) throws IOException {
        short thisId = -4;
        Collection values = clientRefMap.values();
        Iterator iter = values.iterator();
        RefCount refCount = (RefCount)iter.next();
        short lastId = refCount.getCLientId();
        dstr.writeShort(lastId);
        ObjectUID.objectUIDToStream(viewing.getLeavingUID(), dstr);
        ObjectUID.objectUIDToStream(viewing.getJoiningUID(), dstr);
        refCount.decCount(1);
        if (refCount.getCount() == 0) {
            iter.remove();
        }
        while (clientRefMap.size() > 0) {
            int span = 0;
            while (iter.hasNext()) {
                refCount = (RefCount)iter.next();
                refCount.decCount(1);
                if (refCount.getCount() == 0) {
                    iter.remove();
                }
                if ((thisId = (short)refCount.getCLientId()) == lastId + span + 1) {
                    ++span;
                    continue;
                }
                lastId = NoteScreenViewing.emitSpan(dstr, lastId, thisId, span);
                span = 0;
            }
            if (span > 0 && thisId != -4) {
                lastId = NoteScreenViewing.emitSpan(dstr, lastId, (short)-4, span);
            }
            if (!(iter = values.iterator()).hasNext()) continue;
            dstr.writeShort(-4);
        }
    }

    private static short emitSpan(DataOutputStream dstr, short lastId, short thisId, int span) throws IOException {
        short result = (short)(lastId + span);
        if (span > 2) {
            dstr.writeShort(-3);
        }
        if (span > 0) {
            dstr.writeShort(result);
        }
        if (thisId != -4) {
            dstr.writeShort(thisId);
        }
        return thisId;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        StringBuffer buf = new StringBuffer(super.streamToString(istr));
        try {
            Short clientId = ShortList.get((short)WBUtils.readShort(istr, "NoteScreenviewing string reads clientId"));
            Long leavingObjectUID = ObjectUID.objectUIDFromStream(istr);
            Long joiningObjectUID = ObjectUID.objectUIDFromStream(istr);
            buf.append(this.getName() + ": leaving: " + WBUtils.uniqueIDAsHex(leavingObjectUID) + ", joining: " + WBUtils.uniqueIDAsHex(joiningObjectUID) + ", for clientId: " + clientId + "\n");
        }
        catch (IOException ioe) {
            LogSupport.exception((Object)this, (String)"streamToString", (Throwable)ioe, (boolean)true);
            buf.append("\n  Exception: " + ioe.getMessage() + "\n");
        }
        return buf.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("NoteScreenViewing: joins: " + this.clientJoinMap.size() + ", leaves: " + this.clientLeaveMap.size() + "\n");
        Set joinKeys = this.clientJoinMap.keySet();
        Set leaveKeys = this.clientLeaveMap.keySet();
        HashSet clientSet = new HashSet(joinKeys);
        clientSet.addAll(leaveKeys);
        LinkedList clientList = new LinkedList(clientSet);
        Collections.sort(clientList);
        for (Short clientId : clientList) {
            Map.Entry entry;
            Iterator iter;
            buf.append(clientId.toString() + ": joins: ");
            HashMap joinScreens = (HashMap)this.clientJoinMap.get(clientId);
            if (joinScreens != null) {
                iter = joinScreens.entrySet().iterator();
                while (iter.hasNext()) {
                    entry = iter.next();
                    buf.append("uid: " + WBUtils.uniqueIDAsHex((Long)entry.getKey()) + "/" + ((ScreenRef)entry.getValue()).count);
                    if (!iter.hasNext()) continue;
                    buf.append(", ");
                }
            }
            buf.append("\n     leaves: ");
            HashMap leaveScreens = (HashMap)this.clientLeaveMap.get(clientId);
            if (leaveScreens != null) {
                iter = leaveScreens.entrySet().iterator();
                while (iter.hasNext()) {
                    entry = iter.next();
                    buf.append("uid: " + WBUtils.uniqueIDAsHex((Long)entry.getKey()) + "/" + ((ScreenRef)entry.getValue()).count);
                    if (!iter.hasNext()) continue;
                    buf.append(", ");
                }
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    class RefCount
    implements Cloneable {
        private Short clientId;
        private int count = 0;

        public RefCount(int count, Short clientId) {
            this.count = count;
            this.clientId = clientId;
        }

        public void addCount(int add) {
            this.count += add;
        }

        public Object clone() {
            return new RefCount(this.count, this.clientId);
        }

        public void decCount(int dec) {
            this.count -= dec;
        }

        public Short getCLientId() {
            return this.clientId;
        }

        public int getCount() {
            return this.count;
        }

        public String toString() {
            return "RefCount: " + this.count + ", clientId: " + this.clientId;
        }
    }

    class ScreenRef {
        Long screenUID;
        int count;

        public ScreenRef(Long screenUID) {
            this.screenUID = screenUID;
            this.count = 1;
        }
    }
}

