/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.comm.AbstractCommContainer;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.dataModel.WBNodeProxy;
import com.elluminate.groupware.whiteboard.interfaces.AttributeList;
import com.elluminate.groupware.whiteboard.interfaces.UniqueObjectID;
import com.elluminate.util.log.LogSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public class AddObject
extends AbstractCommContainer {
    private ArrayList objects = new ArrayList();

    public AddObject(WhiteboardContext context) {
        super(context, "_AddObject");
    }

    public void add(RegisteredTemplate object) {
        if (object.getRegisteredID() == null) {
            RegisteredTemplate rt = this.context.getTemplateRegistry().getTemplate(object.getName());
            if (rt != null) {
                object.setRegisteredID(rt.getRegisteredID());
            } else {
                LogSupport.error((String)("AddObject: Cannot getTemplate for: " + object.getName()));
            }
        }
        this.objects.add(object);
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        try {
            super.streamToObject(istr);
            while (istr.available() > 0) {
                this.processStream(istr);
            }
        }
        catch (IOException ioe) {
            LogSupport.exception((Object)this, (String)"streamToObject", (Throwable)ioe, (boolean)true);
        }
        return null;
    }

    public void processStream(WBInputStream istr) throws Exception {
        RegisteredTemplate template = AddObject.recoverObject(istr, this.context);
        AddObject.addObject(template, istr.getOriginatorId(), this.context);
    }

    public static RegisteredTemplate recoverObject(WBInputStream istr, WhiteboardContext context) throws Exception {
        RegisteredTemplate template = context.getTemplateRegistry().templateFactory(istr);
        if (template instanceof WBNode) {
            ((WBNode)template).setOriginator(istr.getOriginatorId());
        }
        return template;
    }

    public static void recoverObjectString(WBInputStream istr, StringBuffer buf) {
        RegisteredTemplate rt = istr.getContext().getTemplateRegistry().templateLocator(istr);
        if (rt != null) {
            buf.append(rt.streamToString(istr));
        }
    }

    public static void addObject(RegisteredTemplate rt, Short originator, WhiteboardContext context) {
        Object oldNode = null;
        if (rt instanceof WBNode) {
            WBNode node = (WBNode)rt;
            try {
                WBNode oldWBNode;
                oldNode = context.getObjectManager().getObjectFromMap(node.getObjectID());
                if (oldNode instanceof WBNode && (oldWBNode = (WBNode)oldNode).getParent() == null) {
                    LogSupport.message((String)("addObject: Attempt of merge with unconnected node: " + oldNode));
                    oldWBNode.delete();
                    oldNode = null;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (oldNode == null || oldNode instanceof WBNodeProxy) {
                if (oldNode != null) {
                    context.getObjectManager().setObjectInMap(node, node.getObjectID(), true);
                } else {
                    context.getObjectManager().setObjectInMap(node);
                }
                if (node instanceof AttributeList) {
                    AddObject.linkAttributeList(node, context);
                }
                AddObject.linkObject(node, context, oldNode);
            } else {
                ((WBNode)oldNode).merge(node);
            }
        } else {
            throw new RuntimeException("Object to add does not implement UniqueObjectID: " + rt);
        }
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        if (this.objects.size() == 0) {
            throw new Exception("AddObject with no object.");
        }
        Iterator itr = this.objects.iterator();
        super.objectToStream(ostr);
        while (itr.hasNext()) {
            WBNode rt = (WBNode)itr.next();
            rt.objectToStream(ostr);
        }
    }

    private static void linkObject(RegisteredTemplate rt, WhiteboardContext context, Object oldNode) {
        try {
            if (rt instanceof ScreenRoot) {
                context.getDataModel().addScreenGroup((ScreenRoot)rt);
                ((ScreenRoot)rt).processDeferredProxies();
            } else if (rt instanceof WBNode) {
                WBNode tObj = (WBNode)rt;
                WBNode parent = (WBNode)context.getObjectManager().getObjectFromMap(tObj.getParentUID());
                tObj.setParent(null);
                if (parent == null) {
                    context.getObjectManager().removeObject(tObj);
                    tObj.delete();
                } else {
                    parent.add(tObj, oldNode);
                }
            }
        }
        catch (Exception ex) {
            LogSupport.exception(AddObject.class, (String)"linkObject", (Throwable)ex, (boolean)false, (String)WBUtils.objectName(rt));
        }
    }

    private static void linkAttributeList(AttributeList pObj, WhiteboardContext context) {
        ListIterator iter = pObj.getAttributeList().listIterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof UniqueObjectID)) continue;
            context.getObjectManager().setObjectInMap((UniqueObjectID)obj);
        }
    }

    @Override
    public String streamToString(WBInputStream istr) {
        StringBuffer buf = new StringBuffer(super.streamToString(istr));
        try {
            while (istr.available() > 0) {
                RegisteredTemplate rt = this.context.getTemplateRegistry().templateLocator(istr);
                if (rt != null) {
                    buf.append(rt.streamToString(istr));
                    continue;
                }
                return "Out-of-sync with " + istr.available() + " bytes left after: " + buf.toString();
            }
        }
        catch (IOException ioe) {
            LogSupport.exception((Object)this, (String)"streamToString", (Throwable)ioe, (boolean)true);
            buf.append("\n  Exception: " + ioe.getMessage());
        }
        return buf.toString();
    }
}

