/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.comm.AbstractCommContainer;
import com.elluminate.groupware.whiteboard.conference.DataCodec;
import com.elluminate.groupware.whiteboard.conference.ParticipantData;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.util.ShortList;
import com.elluminate.util.log.LogSupport;
import java.io.IOException;

public class AcknowledgeBlock
extends AbstractCommContainer {
    short blockNumber = 0;

    public AcknowledgeBlock(WhiteboardContext context) {
        super(context, "_AckBlock");
    }

    public AcknowledgeBlock(WhiteboardContext context, short blockNumber) {
        this(context);
        this.blockNumber = blockNumber;
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        try {
            DataCodec codec;
            super.streamToObject(istr);
            short blockNumber = WBUtils.readShort(istr, "AckBlock reads blockNumber");
            Short clientId = ShortList.get((short)WBUtils.readShort(istr, "AckBlock reads target clientId"));
            ParticipantData data = this.context.getDataExporter().getParticipantData(clientId);
            if (data != null && (codec = data.getDataCodec()) != null) {
                codec.acknowledgeBlock(blockNumber);
            }
        }
        catch (IOException ioe) {
            LogSupport.exception((Object)this, (String)"streamToObject", (Throwable)ioe, (boolean)true);
        }
        return null;
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ostr.writeShort(this.blockNumber);
        ostr.writeShort(this.context.getIDProcessor().getMyId().shortValue());
    }

    @Override
    public String streamToString(WBInputStream istr) {
        StringBuffer buf = new StringBuffer(super.streamToString(istr));
        try {
            short blockNumber = WBUtils.readShort(istr, "AckBlock reads blockNumber");
            short clientId = WBUtils.readShort(istr, "AckBlock reads clientId");
            buf.append("Acknowledge Negotiated Block: " + blockNumber + " from clientId: " + clientId + "\n");
        }
        catch (IOException ioe) {
            LogSupport.exception((Object)this, (String)"streamToString", (Throwable)ioe, (boolean)true);
            buf.append("\n  Exception: " + ioe.getMessage());
        }
        return buf.toString();
    }
}

