/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.attributes.subattributes;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.attributes.subattributes.AbstractSubAttribute;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import java.io.IOException;
import org.jdom.Attribute;
import org.jdom.Content;

public class StyleRunSubAttribute
extends AbstractSubAttribute {
    static final String toolName = "StyleRunSubAttribute";
    private int offset = 0;
    private int length = 0;

    public StyleRunSubAttribute(WhiteboardContext context) {
        super(context, toolName);
    }

    public StyleRunSubAttribute(WhiteboardContext context, String name) {
        super(context, name);
    }

    public StyleRunSubAttribute(WhiteboardContext context, String name, int offs, int len, int id) {
        super(context, name, id);
        this.length = len;
        this.offset = offs;
    }

    public void setLength(int len) {
        this.length = len;
    }

    public void setOffset(int offs) {
        this.offset = offs;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public void merge(AbstractAttribute newAttribute) {
        if (newAttribute instanceof StyleRunSubAttribute) {
            super.merge(newAttribute);
            this.setAttributeNotificationSuppression();
            StyleRunSubAttribute newSubAttr = (StyleRunSubAttribute)newAttribute;
            this.setOffset(newSubAttr.getOffset());
            this.setLength(newSubAttr.getLength());
            this.clearAttributeNotificationSuppression(true);
        }
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        int offs = WBUtils.readInt(istr, "StyleRunSubAttribute Offset");
        int len = WBUtils.readInt(istr, "StyleRunSubAttribute Length");
        this.setOffset(offs);
        this.setLength(len);
        return null;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        try {
            String baseResp = super.streamToString(istr);
            int offs = WBUtils.readInt(istr, "StyleRunSubAttribute Offset");
            int len = WBUtils.readInt(istr, "StyleRunSubAttribute Length");
            return baseResp + this.getName() + ": Offset=" + Integer.toHexString(offs) + ", Length=" + Integer.toHexString(len);
        }
        catch (IOException ioe) {
            return this.getName() + " IOException: " + ioe.getMessage();
        }
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ostr.writeInt(this.getOffset());
        ostr.writeInt(this.getLength());
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        String lenString;
        super.elementToObject(element, progress);
        int offs = 0;
        int len = 0;
        String offsString = element.getAttributeValue("offset");
        if (offsString != null && !offsString.equals("")) {
            try {
                offs = Integer.parseInt(offsString);
            }
            catch (Exception e) {
                throw new Exception(this.getName() + ": Invalid integer value for offset: " + offsString);
            }
        }
        if ((lenString = element.getAttributeValue("length")) != null && !lenString.equals("")) {
            try {
                len = Integer.parseInt(lenString);
            }
            catch (Exception e) {
                throw new Exception(this.getName() + ": Invalid integer value for length: " + lenString);
            }
        }
        this.setOffset(offs);
        this.setLength(len);
        return null;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) throws Exception {
        WBElement tf = new WBElement(this.getName());
        super.objectToElement(parent, tf, progress);
        tf.setAttribute(new Attribute("offset", Integer.toString(this.offset)));
        tf.setAttribute(new Attribute("length", Integer.toString(this.length)));
        parent.addContent((Content)tf);
        return null;
    }

    @Override
    public WBElement objectToElement(WBElement parent, WBElement tf, ProgressUpdate progress) throws Exception {
        super.objectToElement(parent, tf, progress);
        tf.setAttribute(new Attribute("offset", Integer.toString(this.offset)));
        tf.setAttribute(new Attribute("length", Integer.toString(this.length)));
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + ", offset: " + this.offset + ", length: " + this.length;
    }
}

