/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.attributes;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import java.awt.BasicStroke;
import java.io.DataInputStream;
import java.io.IOException;
import org.jdom.Attribute;
import org.jdom.Content;

public class ToolStroke
extends AbstractAttribute
implements Cloneable {
    float lineWidth = 2.0f;
    int endCap = 1;
    int lineJoin = 1;
    float miterLimit = 10.0f;
    float[] dashArray = null;
    float dashPhase = 0.0f;
    Object stroke = null;
    private static final String toolName = "ToolStroke";

    public ToolStroke() {
        this(null);
    }

    public ToolStroke(WhiteboardContext context) {
        this(context, toolName);
    }

    public ToolStroke(WhiteboardContext context, String name) {
        super(context, name);
        this.editorUIName = "com.elluminate.groupware.whiteboard.module.ui.attributeEditors.ToolStrokeEditorUI";
    }

    public ToolStroke(WhiteboardContext context, float width) {
        this(context);
        this.lineWidth = width;
    }

    public ToolStroke(WhiteboardContext context, float width, int cap, int join, float miterLimit) {
        this(context);
        this.lineWidth = width;
        this.endCap = cap;
        this.lineJoin = join;
        this.miterLimit = miterLimit;
    }

    public ToolStroke(WhiteboardContext context, float width, int cap, int join) {
        this(context, width, cap, join, 10.0f);
    }

    public ToolStroke(WhiteboardContext context, float width, int cap, int join, float miterLimit, float[] dash, float dash_phase) {
        this(context, width, cap, join, miterLimit);
        this.dashArray = dash;
        this.dashPhase = dash_phase;
    }

    public ToolStroke(WhiteboardContext context, WBElement element, ProgressUpdate update) {
        this(context);
    }

    public ToolStroke(WhiteboardContext context, DataInputStream istr) {
        this(context);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ToolStroke str = (ToolStroke)super.clone();
        str.dashArray = this.dashArray == null ? null : (float[])this.dashArray.clone();
        return str;
    }

    @Override
    public void delete() {
        super.delete();
    }

    public void setStroke(float width, int cap, int join, float miterLimit, float[] dash_array, float dash_phase) {
        this.notifyVisibleChange();
        this.lineWidth = width;
        this.endCap = cap;
        this.lineJoin = join;
        this.miterLimit = miterLimit;
        this.dashArray = dash_array;
        this.dashPhase = dash_phase;
        this.stroke = null;
        this.setAttributeChanged();
        this.notifySizingChange();
        this.notifyAttributeChange();
    }

    public void setStroke(Object str) {
        this.notifyVisibleChange();
        this.lineWidth = ((BasicStroke)str).getLineWidth();
        this.endCap = ((BasicStroke)str).getEndCap();
        this.lineJoin = ((BasicStroke)str).getLineJoin();
        this.miterLimit = ((BasicStroke)str).getMiterLimit();
        this.dashArray = ((BasicStroke)str).getDashArray();
        this.dashPhase = ((BasicStroke)str).getDashPhase();
        this.stroke = null;
        this.setAttributeChanged();
        this.notifySizingChange();
        this.notifyAttributeChange();
    }

    private float[] calculateDashes(float width, int cap, float[] dashArray) {
        if (dashArray == null || dashArray.length == 0) {
            return dashArray;
        }
        float[] newDashes = new float[dashArray.length];
        for (int i = 1; i < dashArray.length; i += 2) {
            newDashes[i - 1] = dashArray[i - 1] + width;
            newDashes[i] = cap != 0 ? dashArray[i] + width * 2.0f : dashArray[i] + width;
        }
        return newDashes;
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        float lineWidth = WBUtils.readFloat(istr, "ToolStroke width");
        int endCap = WBUtils.readInt(istr, "ToolStroke cap");
        int lineJoin = WBUtils.readInt(istr, "ToolStroke join");
        float miterLimit = WBUtils.readFloat(istr, "ToolStroke mitre");
        int dashCount = WBUtils.readInt(istr, "ToolStroke count");
        float[] dashArray = null;
        if (dashCount > 0) {
            dashArray = new float[dashCount];
            for (int i = 0; i < dashCount; ++i) {
                dashArray[i] = WBUtils.readFloat(istr, "ToolStroke dash");
            }
            this.dashPhase = WBUtils.readFloat(istr, "ToolStroke phase");
        } else {
            this.dashPhase = 0.0f;
        }
        this.setStroke(lineWidth, endCap, lineJoin, miterLimit, dashArray, this.dashPhase);
        return null;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        try {
            float lineWidth = WBUtils.readFloat(istr, "ToolStroke width");
            int endCap = WBUtils.readInt(istr, "ToolStroke cap");
            int lineJoin = WBUtils.readInt(istr, "ToolStroke join");
            float miterLimit = WBUtils.readFloat(istr, "ToolStroke mitre");
            int dashCount = WBUtils.readInt(istr, "ToolStroke count");
            float[] dashArray = null;
            float dashPhase = 0.0f;
            if (dashCount > 0) {
                dashArray = new float[dashCount];
                for (int i = 0; i < dashCount; ++i) {
                    dashArray[i] = WBUtils.readFloat(istr, "ToolStroke dash");
                }
                dashPhase = WBUtils.readFloat(istr, "ToolStroke phase");
            }
            return this.getName() + ": Width=" + lineWidth + ", Cap=" + endCap + ", Join=" + lineJoin + ", Miter=" + miterLimit + (dashCount > 0 ? ", Dash=(" + dashArray[0] + ", " + dashArray[1] + ")" : "") + ", Phase=" + dashPhase;
        }
        catch (IOException ioe) {
            return this.getName() + " IOException: " + ioe.getMessage();
        }
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ostr.writeFloat(this.lineWidth);
        ostr.writeInt(this.endCap);
        ostr.writeInt(this.lineJoin);
        ostr.writeFloat(this.miterLimit);
        if (this.dashArray == null) {
            ostr.writeInt(0);
        } else {
            ostr.writeInt(this.dashArray.length);
            for (int i = 0; i < this.dashArray.length; ++i) {
                ostr.writeFloat(this.dashArray[i]);
            }
            ostr.writeFloat(this.dashPhase);
        }
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) {
        String dashPhaseString;
        String dashArrayString;
        String miterString;
        String joinString;
        String capString;
        float lineWidth = 2.0f;
        int endCap = 1;
        int lineJoin = 1;
        float miterLimit = 10.0f;
        float[] dashArray = null;
        float dashPhase = 0.0f;
        String widthString = element.getAttributeValue("WIDTH");
        if (widthString != null && !widthString.equals("")) {
            lineWidth = Float.valueOf(widthString).floatValue();
        }
        if ((capString = element.getAttributeValue("CAP")) != null && !capString.equals("")) {
            endCap = Integer.valueOf(capString);
        }
        if ((joinString = element.getAttributeValue("JOIN")) != null && !joinString.equals("")) {
            lineJoin = Integer.valueOf(joinString);
        }
        if ((miterString = element.getAttributeValue("MITER")) != null && !miterString.equals("")) {
            miterLimit = Float.valueOf(miterString).floatValue();
        }
        if ((dashArrayString = element.getAttributeValue("DASHARRAY")) != null && !dashArrayString.equals("") && !dashArrayString.equalsIgnoreCase("null")) {
            dashArray = new float[2];
            dashArray[0] = Float.valueOf(dashArrayString.substring(0, dashArrayString.indexOf(44) - 1)).floatValue();
            dashArrayString = dashArrayString.substring(dashArrayString.indexOf(44) + 1);
            dashArray[1] = Float.valueOf(dashArrayString).floatValue();
        }
        if ((dashPhaseString = element.getAttributeValue("DASHPHASE")) != null && !dashPhaseString.equals("")) {
            dashPhase = Float.valueOf(dashPhaseString).floatValue();
        }
        this.setStroke(lineWidth, endCap, lineJoin, miterLimit, dashArray, dashPhase);
        return null;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) {
        WBElement ts = new WBElement(this.getName());
        if (this.lineWidth != 2.0f) {
            ts.setAttribute(new Attribute("WIDTH", Float.toString(this.lineWidth)));
        }
        if (this.endCap != 1) {
            ts.setAttribute(new Attribute("CAP", Integer.toString(this.endCap)));
        }
        if (this.lineJoin != 1) {
            ts.setAttribute(new Attribute("JOIN", Integer.toString(this.lineJoin)));
        }
        if (this.miterLimit != 10.0f) {
            ts.setAttribute(new Attribute("MITER", Float.toString(this.miterLimit)));
        }
        if (this.dashArray != null) {
            ts.setAttribute(new Attribute("DASHARRAY", this.dashArrayToXML(this.dashArray)));
            ts.setAttribute(new Attribute("DASHPHASE", Float.toString(this.dashPhase)));
        }
        parent.addContent((Content)ts);
        return null;
    }

    @Override
    public String toString() {
        try {
            return super.toString() + ": Width=" + this.getWidth() + ", Cap=" + this.getCap() + ", Join=" + this.getLineJoin() + ", Miter=" + this.getMiterLimit() + (this.getDashArray() != null ? ", Dash=(" + this.getDashArray()[0] + ", " + this.getDashArray()[1] + ")" : "") + ", Phase=" + this.getDashPhase();
        }
        catch (Exception ex) {
            return super.toString() + ": Exception in toString: " + ex.getMessage();
        }
    }

    private String dashArrayToXML(float[] dashes) {
        if (dashes == null) {
            return "null";
        }
        return Float.toString(dashes[0]) + "," + Float.toString(dashes[1]);
    }

    @Override
    public void merge(AbstractAttribute newAttribute) {
        if (newAttribute instanceof ToolStroke) {
            this.setAttributeNotificationSuppression();
            ToolStroke newStroke = (ToolStroke)newAttribute;
            this.setStroke(newStroke.getStroke());
            this.clearAttributeNotificationSuppression(true);
        }
    }

    public Object getStroke() {
        if (this.stroke == null) {
            this.stroke = new BasicStroke(this.lineWidth, this.endCap, this.lineJoin, this.miterLimit, this.calculateDashes(this.lineWidth, this.endCap, this.dashArray), this.dashPhase);
        }
        return this.stroke;
    }

    public float getWidth() {
        return this.lineWidth;
    }

    public int getCap() {
        return this.endCap;
    }

    public int getLineJoin() {
        return this.lineJoin;
    }

    public float getMiterLimit() {
        return this.miterLimit;
    }

    public float[] getDashArray() {
        return this.dashArray;
    }

    public float getDashPhase() {
        return this.dashPhase;
    }
}

