/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.attributes;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.tools.ImageToolModel;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;

public class ToolImageAlpha
extends AbstractAttribute
implements Cloneable {
    private static final String toolName = "Alpha";
    private boolean showFrame = false;

    public ToolImageAlpha(WhiteboardContext context) {
        this(context, toolName);
    }

    public ToolImageAlpha(WhiteboardContext context, String name) {
        super(context, name);
        this.setOptional(true);
        this.editorUIName = "com.elluminate.groupware.whiteboard.module.ui.attributeEditors.ToolImageAlphaEditorUI";
    }

    public ToolImageAlpha(WhiteboardContext context, WBElement element, ProgressUpdate update) {
        this(context);
    }

    public ToolImageAlpha(WhiteboardContext context, DataInputStream istr) {
        this(context);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Object getColor() {
        return ((ImageToolModel)this.getParent()).getColor().getColor();
    }

    public void setColor(Object rgbaObject, int alpha) {
        ((ImageToolModel)this.getParent()).getColor().setColor(rgbaObject, alpha);
    }

    public int getAlpha() {
        if (this.getParent() != null && ((ImageToolModel)this.getParent()).getColor() != null) {
            return ((ImageToolModel)this.getParent()).getColor().getAlpha();
        }
        return 0;
    }

    public void setAlpha(int alpha) {
        ((ImageToolModel)this.getParent()).getColor().setAlpha(alpha);
    }

    public boolean isFrameVisible() {
        return this.showFrame;
    }

    public void setFrameVisible(boolean showFrame) {
        if (showFrame != this.showFrame) {
            this.setAttributeChanged();
        } else {
            this.clearAttributeChanged();
        }
        this.showFrame = showFrame;
        ((ImageToolModel)this.getParent()).setFrameVisible(showFrame);
        if (this.isAttributeChanged()) {
            this.notifyAttributeChange();
        }
    }

    @Override
    public void merge(AbstractAttribute newAttribute) {
        this.setFrameVisible(((ToolImageAlpha)newAttribute).isFrameVisible());
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        this.setFrameVisible(WBUtils.readBoolean(istr, "ToolImageAlpha reads hasBorder"));
        return null;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        return "hasBorder: " + this.showFrame;
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ostr.writeBoolean(this.showFrame);
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) {
        if (this.parent instanceof ImageToolModel) {
            String alphaString;
            ImageToolModel iTool = (ImageToolModel)this.parent;
            String borderString = element.getAttributeValue("BORDER");
            if (borderString != null && !borderString.equals("")) {
                iTool.setFrameVisible(borderString.equalsIgnoreCase("true"));
            }
            if ((alphaString = element.getAttributeValue("A")) != null && !alphaString.equals("")) {
                try {
                    iTool.setFillAlpha(Integer.parseInt(alphaString));
                }
                catch (Exception ex) {
                    LogSupport.exception((Object)this, (String)"elementToObject", (Throwable)ex, (boolean)true);
                }
            }
        }
        return null;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) {
        return null;
    }

    @Override
    public String toString() {
        return this.getName() + ": alpha: " + this.getAlpha() + ", color: " + this.getColor();
    }
}

