/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.attributes;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.attributes.StringsProperties;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.IOException;
import org.jdom.Attribute;

public class ScreenName
extends AbstractAttribute
implements Cloneable {
    private String screenName = "Screen";
    private boolean aSystemGeneratedName = false;
    public static final String DEFAULT_SCREEN_NAME;

    public ScreenName(WhiteboardContext context) {
        super(context, "ScreenName");
        this.setOptional(true);
    }

    public ScreenName(WhiteboardContext context, WBElement element, ProgressUpdate update) {
        this(context);
    }

    public ScreenName(WhiteboardContext context, DataInputStream istr) {
        this(context);
    }

    public ScreenName(WhiteboardContext context, String name, boolean systemGenerated) {
        this(context);
        this.setScreenName(name);
        this.setASystemGeneratedScreenName(systemGenerated);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void delete() {
        super.delete();
    }

    @Override
    public boolean usesHeader() {
        return true;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public void merge(AbstractAttribute newAttribute) {
        if (newAttribute instanceof ScreenName) {
            this.setAttributeNotificationSuppression();
            ScreenName newName = (ScreenName)newAttribute;
            this.setOriginator(newAttribute.getOriginator());
            this.setASystemGeneratedScreenName(newName.aSystemGeneratedName);
            this.setScreenName(newName.getScreenName());
            this.clearAttributeNotificationSuppression(true);
        }
    }

    public String getScreenName() {
        return this.screenName;
    }

    public void setScreenName(String name) {
        this.setScreenName(name, true);
    }

    public void setASystemGeneratedScreenName(String name) {
        this.setASystemGeneratedScreenName(true);
        this.setScreenName(name);
    }

    public boolean isASystemGeneratedScreenName() {
        return this.aSystemGeneratedName;
    }

    private void setScreenName(String screenName, boolean notify) {
        boolean wasSystemName = this.isASystemGeneratedScreenName();
        if ("".equals(screenName)) {
            this.setASystemGeneratedScreenName(true);
            this.screenName = DEFAULT_SCREEN_NAME;
        } else {
            if (this.screenName.equals(screenName)) {
                return;
            }
            this.screenName = screenName;
        }
        if (this.isTheShowingScreen()) {
            this.context.getController().setControllerTitle(this.parent.getRoot().getScreenName());
        }
        this.setAttributeChanged();
        if (notify) {
            this.notifyVisibleChange();
            if (!this.isASystemGeneratedScreenName() || wasSystemName != this.isASystemGeneratedScreenName()) {
                this.notifyAttributeChange();
            }
        } else {
            this.clearAttributeChanged();
        }
    }

    private boolean isTheShowingScreen() {
        return this.context.getController() != null && this.parent != null && this.parent.isConferenceNode() && this.context.getController().getScreen() != null && (this.context.getController().getScreen().getRoot() == this.parent || this.context.getController().getScreen() == this.parent);
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        String screenName = WBUtils.readUTF(istr, "ScreenName");
        boolean aGeneratedName = WBUtils.readBoolean(istr, "ScreenName");
        if (this.getParent() != null && this.getParent().getDisplayPeer() != null) {
            ScreenModel sm = (ScreenModel)this.getParent();
            sm.setScreenName(screenName, aGeneratedName);
        } else {
            this.setASystemGeneratedScreenName(aGeneratedName);
            this.setScreenName(screenName);
        }
        return null;
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ostr.writeUTF(this.screenName);
        ostr.writeBoolean(this.aSystemGeneratedName);
    }

    @Override
    public String streamToString(WBInputStream istr) {
        try {
            return this.getName() + WBUtils.readUTF(istr, "ScreenName") + WBUtils.readBoolean(istr, "ScreenName");
        }
        catch (IOException ioe) {
            return this.getName() + " IOException: " + ioe.getMessage();
        }
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        boolean foundId = false;
        boolean foundName = false;
        String id = "1";
        for (Attribute attrib : element.getAttributes()) {
            try {
                if (attrib.getName().equalsIgnoreCase("name")) {
                    this.setOriginator();
                    this.setScreenName(attrib.getValue().trim());
                    foundName = true;
                    break;
                }
                if (attrib.getName().equalsIgnoreCase("id")) {
                    id = attrib.getValue().trim();
                    foundId = true;
                }
                if (!attrib.getName().equalsIgnoreCase("generatedName")) continue;
                this.setASystemGeneratedScreenName(Boolean.parseBoolean(attrib.getValue().trim()));
            }
            catch (Exception e) {
                throw new Exception(this.getName() + " Invalid data in ScreenName: " + e.getMessage());
            }
        }
        if (foundName || foundId) {
            if (foundId && !foundName) {
                this.setOriginator();
                this.setScreenName("Screen " + id);
            }
        } else if (!this.isOptional()) {
            LogSupport.error((String)("Screen: " + this.getParent().getName() + " has no name, at line: " + element.getInstanceCount()));
        }
        return null;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) {
        parent.setAttribute("name", this.screenName);
        parent.setAttribute("generatedName", Boolean.toString(this.aSystemGeneratedName));
        return null;
    }

    @Override
    public String toString() {
        return this.getScreenName();
    }

    public void setASystemGeneratedScreenName(boolean flag) {
        this.aSystemGeneratedName = flag;
    }

    static {
        I18n i18n = I18n.create((Object)new Object(){});
        DEFAULT_SCREEN_NAME = i18n.getString((PropertiesEnum)StringsProperties.SCREENNAME_DEFAULTBLANKNAME);
    }
}

