/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.attributes;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.attributes.PointerImageData;
import com.elluminate.groupware.whiteboard.attributes.ScreenName;
import com.elluminate.groupware.whiteboard.attributes.StringsProperties;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.tools.PointerToolModel;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.platform.Platform;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.image.gif.AnimationFrame;
import com.elluminate.util.image.gif.AnimationInstance;
import com.elluminate.util.image.gif.GifFile;
import com.elluminate.util.image.gif.ImageObject;
import com.elluminate.util.log.LogSupport;
import java.awt.Image;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;

public class PointerImageAttribute
extends AbstractAttribute
implements Cloneable {
    private String imageName = "";
    private PointerImageData pointerImageData = null;
    private String triedImage = "";
    private boolean animate = false;
    private AnimationInstance animationInstance = null;

    public PointerImageAttribute(WhiteboardContext context) {
        super(context, "PointerImageAttribute");
        this.setOptional(true);
        this.editorUIName = "com.elluminate.groupware.whiteboard.module.ui.attributeEditors.PointerImageEditorUI";
        this.imageName = i18n.getString((PropertiesEnum)StringsProperties.POINTERIMAGEATTRIBUTE_DEFAULTNAME);
    }

    public PointerImageAttribute(WhiteboardContext context, WBElement element, ProgressUpdate update) {
        this(context);
    }

    public PointerImageAttribute(WhiteboardContext context, DataInputStream istr) {
        this(context);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PointerImageAttribute attribute = (PointerImageAttribute)super.clone();
        attribute.pointerImageData = null;
        attribute.animationInstance = null;
        return attribute;
    }

    @Override
    public void delete() {
        super.delete();
        if (this.pointerImageData != null) {
            this.pointerImageData.flush();
        }
    }

    @Override
    public boolean usesHeader() {
        return true;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public void merge(AbstractAttribute newAttribute) {
        if (newAttribute instanceof ScreenName) {
            this.setAttributeNotificationSuppression();
            PointerImageAttribute newPointerImage = (PointerImageAttribute)newAttribute;
            this.setOriginator(newAttribute.getOriginator());
            this.setPointerImageName(newPointerImage.getImageName());
            this.clearAttributeNotificationSuppression(true);
        }
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setPointerImageName(String name) {
        this.setPointerImageName(name, true);
    }

    public PointerImageData getPointerImage() {
        if (this.context.getController() != null) {
            if (this.pointerImageData == null || !this.imageName.equals(this.triedImage)) {
                this.pointerImageData = PointerImageAttribute.getPointerImage(this.imageName);
                this.animate = this.pointerImageData.getImage().getFrameCount() > 1;
                this.animationInstance = new Animation(this.pointerImageData.getImage());
            } else {
                return this.pointerImageData;
            }
        }
        this.triedImage = this.imageName;
        return this.pointerImageData;
    }

    public Image getImage() {
        return this.animationInstance.getAnimationFrame(this.pointerImageData.getImage()).getImage();
    }

    public void imageRendered() {
        if (this.animationInstance != null && this.animate) {
            this.animationInstance.imageRendered(this.pointerImageData.getImage());
        }
    }

    public static StringTokenizer getPointerNames() {
        StringTokenizer tokens = new StringTokenizer(i18n.getString((PropertiesEnum)StringsProperties.POINTERIMAGEATTRIBUTE_IMAGENAMES), ",");
        return tokens;
    }

    public static PointerImageData getPointerImage(String imageName) {
        PointerImageData data = null;
        ImageObject pointerImageObject = null;
        ImageObject buttonImageObject = null;
        ImageIcon buttonImage = null;
        try {
            pointerImageObject = PointerImageAttribute.getImageObject("PointerImageAttribute." + imageName);
        }
        catch (Exception ex) {
            System.out.println();
            LogSupport.exception((Object)i18n, (String)("Constructor: Cannot find image for: PointerImageAttribute." + imageName), (Throwable)ex, (boolean)false);
        }
        try {
            buttonImageObject = PointerImageAttribute.getImageObject("PointerImageAttribute.Animated" + imageName + "Button");
        }
        catch (Exception ex) {
            buttonImageObject = pointerImageObject;
            LogSupport.exception((Object)i18n, (String)("Constructor: Cannot find image for: PointerImageAttribute.Animated" + imageName), (Throwable)ex, (boolean)false);
        }
        try {
            buttonImage = i18n.getIcon("PointerImageAttribute." + imageName + "Button");
        }
        catch (Exception ex) {
            buttonImage = null;
            LogSupport.exception((Object)i18n, (String)("Constructor: Cannot find image for: PointerImageAttribute." + imageName), (Throwable)ex, (boolean)false);
        }
        try {
            String hotspotString = i18n.getStringLegacy("PointerImageAttribute." + imageName + "HotSpot");
            StringTokenizer tokenizer = new StringTokenizer(hotspotString);
            int x = Integer.parseInt(tokenizer.nextToken(","));
            int y = Integer.parseInt(tokenizer.nextToken());
            data = new PointerImageData(pointerImageObject, buttonImage, buttonImageObject, x, y);
        }
        catch (Exception ex1) {
            System.out.println("Cannot find hotSpot for: PointerImageAttribute." + imageName + "HotSpot");
            ex1.printStackTrace();
        }
        return data;
    }

    private static ImageObject getImageObject(String imageName) {
        try {
            ImageObject imageObject;
            byte[] imageData = i18n.getBytes(imageName);
            String imageFile = i18n.getStringLegacy(imageName);
            if (Platform.getMimeType((String)imageFile).equals("image/gif")) {
                try {
                    imageObject = new ImageObject(new GifFile(imageData, imageName), imageName);
                }
                catch (InterruptedException ie) {
                    imageObject = null;
                }
            } else {
                imageObject = new ImageObject(new ImageIcon(imageData).getImage(), imageName);
            }
            return imageObject;
        }
        catch (Exception ioe) {
            LogSupport.exception(null, (String)("getImageObject: " + imageName), (Throwable)ioe, (boolean)true);
            return null;
        }
    }

    private void setPointerImageName(String pointerImageName, boolean notify) {
        this.imageName = "".equals(pointerImageName) ? i18n.getString((PropertiesEnum)StringsProperties.POINTERIMAGEATTRIBUTE_DEFAULTNAME) : pointerImageName;
        this.getPointerImage();
        this.setAttributeChanged();
        if (notify) {
            this.notifyVisibleChange();
        }
        if (notify) {
            this.notifyAttributeChange();
        } else {
            this.clearAttributeChanged();
        }
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        String screenName = WBUtils.readUTF(istr, "PointerImageAttribute");
        this.setPointerImageName(screenName);
        return null;
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ostr.writeUTF(this.imageName);
    }

    @Override
    public String streamToString(WBInputStream istr) {
        try {
            return this.getName() + WBUtils.readUTF(istr, "PointerImageAttribute");
        }
        catch (IOException ioe) {
            return this.getName() + " IOException: " + ioe.getMessage();
        }
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        return null;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) {
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.getImageName();
    }

    class Animation
    extends AnimationInstance {
        Animation(ImageObject imageObject) {
            super(imageObject);
        }

        protected boolean canAnimate() {
            return PointerImageAttribute.this.animate;
        }

        protected void animate(int xOffset, int yOffset, int width, int height) {
            PointerToolModel pointerTool = (PointerToolModel)PointerImageAttribute.this.getParent();
            if (pointerTool == null || !pointerTool.isDeleted()) {
                PointerImageAttribute.this.context.getController().repaint(pointerTool);
            }
        }

        protected AnimationFrame getFrame() {
            return PointerImageAttribute.this.animationInstance.getAnimationFrame(PointerImageAttribute.this.pointerImageData.getImage());
        }
    }
}

