/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard;

import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.whiteboard.WhiteboardChairListener;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.acl.ACLEntry;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.Connection;
import com.elluminate.util.ShortList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class ChairManager {
    HashMap chairs = new HashMap();
    LinkedList listeners = new LinkedList();
    WhiteboardContext context;

    public ChairManager(WhiteboardContext context) {
        this.context = context;
    }

    public void addChairListener(WhiteboardChairListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeChairListener(WhiteboardChairListener l) {
        this.listeners.remove(l);
    }

    void fireChairListeners(Short clientId, Short jinxAddress, boolean add) {
        if (this.context.isOnline()) {
            Chair chair = ChairProtocol.getChair((Connection)this.context.getClientList().getConnection());
            this.context.setChair(chair.isMe());
            this.context.getIDProcessor().setChair(chair);
        } else {
            this.context.setChair(this.context.isChair());
            this.context.getIDProcessor().setChair(null);
        }
        this.context.getACLManager().changeRole(ACLEntry.CHAIR_ROLE);
        for (WhiteboardChairListener l : this.listeners) {
            l.onWhiteboardChairChange(clientId, jinxAddress, add);
        }
    }

    public void updateChair() {
        this.updateChair(ChairProtocol.getChair((ClientList)this.context.getClientList()));
    }

    public void updateChair(Chair chair) {
        Short jinxAddress;
        short[] addresses = chair.getAddresses();
        HashMap<Short, Short> updateLocalChairs = new HashMap<Short, Short>();
        for (int i = 0; i < addresses.length; ++i) {
            jinxAddress = ShortList.get((short)addresses[i]);
            Short clientId = this.context.getIDProcessor().getClientId(jinxAddress);
            if (clientId == null) continue;
            updateLocalChairs.put(clientId, jinxAddress);
        }
        LinkedList newChairs = new LinkedList(updateLocalChairs.keySet());
        newChairs.removeAll(this.chairs.keySet());
        for (Short clientId : newChairs) {
            jinxAddress = this.context.getIDProcessor().getClientAddress(clientId);
            if (jinxAddress == null) continue;
            this.fireChairListeners(clientId, jinxAddress, true);
        }
        LinkedList oldChairs = new LinkedList(this.chairs.keySet());
        oldChairs.removeAll(updateLocalChairs.keySet());
        for (Short clientId : oldChairs) {
            jinxAddress = this.context.getIDProcessor().getClientAddress(clientId);
            if (jinxAddress == null) continue;
            this.fireChairListeners(clientId, jinxAddress, false);
        }
        this.chairs = updateLocalChairs;
    }

    public Iterator chairClientIterator() {
        return this.chairs.keySet().iterator();
    }

    public Iterator chairJinxIterator() {
        return this.chairs.values().iterator();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ChairManager:\n");
        for (Map.Entry entry : this.chairs.entrySet()) {
            buf.append("\tclientId: " + (Short)entry.getKey() + ", jinxAddress: " + (Short)entry.getValue() + "\n");
        }
        return buf.toString();
    }
}

