/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.profile;

import com.elluminate.jinx.Bytes;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

public class VCardItemID {
    public static final byte VCARD_VER_21 = 33;
    public static final byte VCARD_VER_30 = 48;
    public static final byte VC_MORE_MASK = -128;
    public static final byte VC_GROUP_MASK = 64;
    public static final byte VC_CONTENT_MASK = 32;
    public static final byte VC_ITEM_MASK = 31;
    public static final byte VC_PARAM_MASK = 127;
    public static final byte VC_N = 0;
    public static final byte VC_FN = 1;
    public static final byte VC_NICKNAME = 2;
    public static final byte VC_PHOTO = 3;
    public static final byte VC_ADR = 4;
    public static final byte VC_TEL = 5;
    public static final byte VC_EMAIL = 6;
    public static final byte VC_TITLE = 7;
    public static final byte VC_ROLE = 8;
    public static final byte VC_LOGO = 9;
    public static final byte VC_ORG = 10;
    public static final byte VC_AGENT = 11;
    public static final byte VC_NOTE = 12;
    public static final byte VC_URL = 13;
    public static final byte VC_VERSION = 14;
    public static final byte VC_BDAY = 15;
    public static final byte VC_CATEGORIES = 16;
    public static final byte VC_GEO = 17;
    public static final byte VC_LABEL = 18;
    public static final byte VC_MAILER = 19;
    public static final byte VC_TZ = 20;
    public static final byte VC_PRODID = 21;
    public static final byte VC_REV = 22;
    public static final byte VC_SORT_STRING = 23;
    public static final byte VC_SOUND = 24;
    public static final byte VC_UID = 25;
    public static final byte VC_CLASS = 26;
    public static final byte VC_KEY = 27;
    public static final byte VC_BEGIN = 28;
    public static final byte VC_END = 29;
    public static final byte VC_EXTENSION = 31;
    public static final byte VC_P_ENC_DEFAULT = 0;
    public static final byte VC_P_ENC_8BIT = 1;
    public static final byte VC_P_ENC_B64 = 2;
    public static final byte VC_P_ENC_QP = 3;
    public static final byte VC_P_VAL_DEFAULT = 16;
    public static final byte VC_P_VAL_INLINE = 17;
    public static final byte VC_P_VAL_URL = 18;
    public static final byte VC_P_TYPE_GIF = 32;
    public static final byte VC_P_TYPE_CGM = 33;
    public static final byte VC_P_TYPE_WMF = 34;
    public static final byte VC_P_TYPE_BMP = 35;
    public static final byte VC_P_TYPE_MET = 36;
    public static final byte VC_P_TYPE_PMB = 37;
    public static final byte VC_P_TYPE_DIB = 38;
    public static final byte VC_P_TYPE_PICT = 39;
    public static final byte VC_P_TYPE_TIFF = 40;
    public static final byte VC_P_TYPE_PS = 41;
    public static final byte VC_P_TYPE_PDF = 42;
    public static final byte VC_P_TYPE_JPEG = 43;
    public static final byte VC_P_TYPE_MPEG = 44;
    public static final byte VC_P_TYPE_MPEG2 = 45;
    public static final byte VC_P_TYPE_AVI = 46;
    public static final byte VC_P_TYPE_QTIME = 47;
    public static final byte VC_P_TYPE_DOM = 48;
    public static final byte VC_P_TYPE_INTL = 49;
    public static final byte VC_P_TYPE_POSTAL = 50;
    public static final byte VC_P_TYPE_PARCEL = 51;
    public static final byte VC_P_TYPE_HOME = 52;
    public static final byte VC_P_TYPE_WORK = 53;
    public static final byte VC_P_TYPE_PREF = 54;
    public static final byte VC_P_TYPE_VOICE = 55;
    public static final byte VC_P_TYPE_FAX = 56;
    public static final byte VC_P_TYPE_MSG = 57;
    public static final byte VC_P_TYPE_CELL = 58;
    public static final byte VC_P_TYPE_PAGER = 59;
    public static final byte VC_P_TYPE_BBS = 60;
    public static final byte VC_P_TYPE_MODEM = 61;
    public static final byte VC_P_TYPE_CAR = 62;
    public static final byte VC_P_TYPE_ISDN = 63;
    public static final byte VC_P_TYPE_VIDEO = 64;
    public static final byte VC_P_TYPE_AOL = 65;
    public static final byte VC_P_TYPE_APPLELINK = 66;
    public static final byte VC_P_TYPE_ATTMAIL = 67;
    public static final byte VC_P_TYPE_CIS = 68;
    public static final byte VC_P_TYPE_EWORLD = 69;
    public static final byte VC_P_TYPE_INTERNET = 70;
    public static final byte VC_P_TYPE_IBMMAIL = 71;
    public static final byte VC_P_TYPE_MCIMAIL = 72;
    public static final byte VC_P_TYPE_POWERSHARE = 73;
    public static final byte VC_P_TYPE_PRODIGY = 74;
    public static final byte VC_P_TYPE_TLX = 75;
    public static final byte VC_P_TYPE_X400 = 76;
    public static final byte VC_P_TYPE_WAVE = 77;
    public static final byte VC_P_TYPE_PCM = 78;
    public static final byte VC_P_TYPE_AIFF = 79;
    public static final byte VC_P_TYPE_X509 = 80;
    public static final byte VC_P_TYPE_PGP = 81;
    public static final byte VC_P_CHARSET = 112;
    public static final byte VC_P_LANGUAGE = 113;
    public static final byte VC_P_EXT = 127;
    public static final byte MIN_TYPE = 32;
    public static final byte MAX_TYPE = 81;
    private static HashMap VC_NAMES = new HashMap();
    private static HashMap VC_VALUES = new HashMap();
    private static HashMap VC_P_NAMES = new HashMap();
    private static HashMap VC_P_VALUES = new HashMap();
    private static HashMap VC_P_ALT = new HashMap();
    private static HashMap VC_P_REV_VALUES = new HashMap();
    private static HashMap VC_P_REV_NAMES = new HashMap();
    private static final String[] EMPTY = new String[0];
    private byte id;
    private String ext = null;
    private LinkedList params = null;
    private String group = null;

    private static void item(byte enc, String nm) {
        Byte key = Bytes.get((byte)enc);
        VC_NAMES.put(key, nm);
        VC_VALUES.put(nm, key);
    }

    private static void define(byte enc, String nm, String val) {
        VCardItemID.define(enc, nm, val, val);
    }

    private static void define(byte enc, String nm, String val, String alt) {
        Byte key = Bytes.get((byte)enc);
        VC_P_NAMES.put(key, nm);
        VC_P_REV_NAMES.put(nm, key);
        if (val != null) {
            VC_P_VALUES.put(key, val);
            VC_P_REV_VALUES.put(val, key);
        }
        if (alt != null) {
            VC_P_ALT.put(key, alt);
            if (!alt.equals(val)) {
                VC_P_REV_VALUES.put(alt, key);
            }
        }
    }

    public VCardItemID(String name) {
        Byte enc;
        int sep = name.indexOf(59);
        String item = null;
        String parse = null;
        if (sep < 0) {
            item = name.toUpperCase();
        } else {
            item = name.substring(0, sep).toUpperCase();
            parse = name.substring(sep + 1);
        }
        sep = item.indexOf(46);
        if (sep > 0) {
            this.group = item.substring(0, sep);
            item = item.substring(sep + 1);
        }
        if ((enc = (Byte)VC_VALUES.get(item)) != null) {
            this.id = enc;
        } else {
            this.id = (byte)31;
            this.ext = item;
        }
        while (parse != null) {
            Param param = null;
            sep = parse.indexOf(59);
            if (sep < 0) {
                item = parse.toUpperCase();
                parse = null;
            } else {
                item = parse.substring(0, sep).toUpperCase();
                parse = parse.substring(sep + 1);
            }
            sep = item.indexOf(61);
            if (sep < 0) {
                Byte id = (Byte)VC_P_REV_VALUES.get(item);
                if (id != null) {
                    param = new Param(id);
                }
                if (param == null) continue;
                if (this.params == null) {
                    this.params = new LinkedList();
                }
                this.params.addLast(param);
                continue;
            }
            String pnm = item.substring(0, sep);
            String pval = item.substring(sep + 1);
            while (pval != null) {
                String p1val;
                sep = pval.indexOf(44);
                if (sep < 0) {
                    p1val = pval;
                    pval = null;
                } else {
                    p1val = pval.substring(0, sep);
                    pval = pval.substring(sep + 1);
                }
                if (pnm.equals("CHARSET")) {
                    param = new ValParam(112, p1val);
                } else if (pnm.equals("LANGUAGE")) {
                    param = new ValParam(113, p1val);
                } else if (VC_P_REV_NAMES.containsKey(pnm) && VC_P_REV_VALUES.containsKey(p1val)) {
                    Byte id = (Byte)VC_P_REV_VALUES.get(p1val);
                    param = new Param(id);
                } else {
                    param = new ExtParam(pnm, p1val);
                }
                if (param == null) continue;
                if (this.params == null) {
                    this.params = new LinkedList();
                }
                this.params.addLast(param);
            }
        }
    }

    public String getName() {
        StringBuffer buf = new StringBuffer();
        if (this.group != null) {
            buf.append(this.group);
            buf.append('.');
        }
        if (this.id == 31) {
            buf.append(this.ext);
        } else {
            buf.append(VC_NAMES.get(Bytes.get((byte)this.id)));
        }
        if (this.params != null) {
            for (Param p : this.params) {
                buf.append(p.toString());
            }
        }
        return buf.toString();
    }

    public byte getID() {
        return this.id;
    }

    public String getCharset() {
        ValParam p = (ValParam)this.find("CHARSET");
        if (p == null) {
            return System.getProperty("file.encoding", "ASCII7");
        }
        return p.getValue();
    }

    public String getLanguage() {
        ValParam p = (ValParam)this.find("LANGUAGE");
        if (p == null) {
            return null;
        }
        return p.getValue();
    }

    public String getEncoding() {
        Param encoding = this.find("ENCODING");
        if (encoding == null) {
            return null;
        }
        return encoding.getValue();
    }

    public byte getEncodingID() {
        Param encoding = this.find("ENCODING");
        if (encoding == null) {
            return 0;
        }
        return encoding.getID();
    }

    public String getLocation() {
        Param loc = this.find("VALUE");
        if (loc == null) {
            return null;
        }
        return loc.getValue();
    }

    public String[] getType() {
        ArrayList<String> list = null;
        if (this.params == null) {
            return EMPTY;
        }
        for (Param p : this.params) {
            if (!p.getName().equalsIgnoreCase("TYPE")) continue;
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(p.getValue());
        }
        return list.toArray(EMPTY);
    }

    public boolean checkType(String type, boolean dft) {
        Byte key = (Byte)VC_P_REV_VALUES.get(type.toUpperCase());
        if (key == null) {
            return false;
        }
        byte pid = key;
        boolean found = false;
        if (this.params != null) {
            for (Param p : this.params) {
                byte id = p.getID();
                if (id < 32 || id > 81) continue;
                if (p.getID() == pid) {
                    return true;
                }
                found = true;
            }
        }
        if (!found) {
            return dft;
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    private Param find(String nm) {
        if (this.params == null) {
            return null;
        }
        for (Param p : this.params) {
            if (!nm.equalsIgnoreCase(p.getName())) continue;
            return p;
        }
        return null;
    }

    static {
        VCardItemID.item((byte)0, "N");
        VCardItemID.item((byte)1, "FN");
        VCardItemID.item((byte)2, "NICKNAME");
        VCardItemID.item((byte)3, "PHOTO");
        VCardItemID.item((byte)4, "ADR");
        VCardItemID.item((byte)5, "TEL");
        VCardItemID.item((byte)6, "EMAIL");
        VCardItemID.item((byte)7, "TITLE");
        VCardItemID.item((byte)8, "ROLE");
        VCardItemID.item((byte)9, "LOGO");
        VCardItemID.item((byte)10, "ORG");
        VCardItemID.item((byte)11, "AGENT");
        VCardItemID.item((byte)12, "NOTE");
        VCardItemID.item((byte)13, "URL");
        VCardItemID.item((byte)14, "VERSION");
        VCardItemID.item((byte)15, "BDAY");
        VCardItemID.item((byte)16, "CATEGORIES");
        VCardItemID.item((byte)17, "GEO");
        VCardItemID.item((byte)18, "LABEL");
        VCardItemID.item((byte)19, "MAILER");
        VCardItemID.item((byte)20, "TZ");
        VCardItemID.item((byte)21, "PROGID");
        VCardItemID.item((byte)22, "REV");
        VCardItemID.item((byte)23, "SORT-STRING");
        VCardItemID.item((byte)24, "SOUND");
        VCardItemID.item((byte)25, "UID");
        VCardItemID.item((byte)26, "CLASS");
        VCardItemID.item((byte)27, "KEY");
        VCardItemID.item((byte)28, "BEGIN");
        VCardItemID.item((byte)29, "END");
        VCardItemID.define((byte)1, "ENCODING", "8BIT", null);
        VCardItemID.define((byte)2, "ENCODING", "BASE64", "B");
        VCardItemID.define((byte)3, "ENCODING", "QUOTED-PRINTABLE", "Q");
        VCardItemID.define((byte)17, "VALUE", "INLINE");
        VCardItemID.define((byte)18, "VALUE", "URL", "URI");
        VCardItemID.define((byte)32, "TYPE", "GIF");
        VCardItemID.define((byte)33, "TYPE", "CGM");
        VCardItemID.define((byte)34, "TYPE", "WMF");
        VCardItemID.define((byte)35, "TYPE", "BMP");
        VCardItemID.define((byte)36, "TYPE", "MET");
        VCardItemID.define((byte)37, "TYPE", "PMB");
        VCardItemID.define((byte)38, "TYPE", "DIB");
        VCardItemID.define((byte)39, "TYPE", "PICT");
        VCardItemID.define((byte)40, "TYPE", "TIFF");
        VCardItemID.define((byte)41, "TYPE", "PS");
        VCardItemID.define((byte)42, "TYPE", "PDF");
        VCardItemID.define((byte)43, "TYPE", "JPEG");
        VCardItemID.define((byte)44, "TYPE", "MPEG");
        VCardItemID.define((byte)45, "TYPE", "MPEG2");
        VCardItemID.define((byte)46, "TYPE", "AVI");
        VCardItemID.define((byte)47, "TYPE", "QTIME");
        VCardItemID.define((byte)48, "TYPE", "DOM");
        VCardItemID.define((byte)49, "TYPE", "INTL");
        VCardItemID.define((byte)50, "TYPE", "POSTAL");
        VCardItemID.define((byte)51, "TYPE", "PARCEL");
        VCardItemID.define((byte)52, "TYPE", "HOME");
        VCardItemID.define((byte)53, "TYPE", "WORK");
        VCardItemID.define((byte)54, "TYPE", "PREF");
        VCardItemID.define((byte)55, "TYPE", "VOICE");
        VCardItemID.define((byte)56, "TYPE", "FAX");
        VCardItemID.define((byte)57, "TYPE", "MSG");
        VCardItemID.define((byte)58, "TYPE", "CELL");
        VCardItemID.define((byte)59, "TYPE", "PAGER");
        VCardItemID.define((byte)60, "TYPE", "BBS");
        VCardItemID.define((byte)61, "TYPE", "MODEM");
        VCardItemID.define((byte)62, "TYPE", "CAR");
        VCardItemID.define((byte)63, "TYPE", "ISDN");
        VCardItemID.define((byte)64, "TYPE", "VIDEO");
        VCardItemID.define((byte)65, "TYPE", "AOL");
        VCardItemID.define((byte)66, "TYPE", "APPLELINK");
        VCardItemID.define((byte)67, "TYPE", "ATTMAIL");
        VCardItemID.define((byte)68, "TYPE", "CIS");
        VCardItemID.define((byte)69, "TYPE", "EWORLD");
        VCardItemID.define((byte)70, "TYPE", "INTERNET");
        VCardItemID.define((byte)71, "TYPE", "IBMMAIL");
        VCardItemID.define((byte)72, "TYPE", "MCIMAIL");
        VCardItemID.define((byte)73, "TYPE", "POWERSHARE");
        VCardItemID.define((byte)74, "TYPE", "PRODIGY");
        VCardItemID.define((byte)75, "TYPE", "TLX");
        VCardItemID.define((byte)76, "TYPE", "X400");
        VCardItemID.define((byte)77, "TYPE", "WAVE");
        VCardItemID.define((byte)78, "TYPE", "PCM");
        VCardItemID.define((byte)79, "TYPE", "AIFF");
        VCardItemID.define((byte)80, "TYPE", "X509");
        VCardItemID.define((byte)81, "TYPE", "PGP");
        VCardItemID.define((byte)112, "CHARSET", null);
        VCardItemID.define((byte)113, "LANGUAGE", null);
    }

    private class ExtParam
    extends ValParam {
        private String name;

        public ExtParam(String nm, String val) {
            super((byte)127, val);
            this.name = nm;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void send(DataOutputStream ostr, boolean more) throws IOException {
            super.send(ostr, more);
            ostr.writeUTF(this.name);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ this.name.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            try {
                ExtParam p = (ExtParam)o;
                return super.equals(o) && this.value.equals(p.value);
            }
            catch (Throwable t) {
                return false;
            }
        }
    }

    private class Param {
        protected byte encoding;

        public Param(byte enc) {
            this.encoding = enc;
        }

        public byte getID() {
            return this.encoding;
        }

        public String getName() {
            return (String)VC_P_NAMES.get(Bytes.get((byte)this.encoding));
        }

        public String getValue() {
            return this.getValue((byte)33);
        }

        public String getValue(byte ver) {
            switch (ver) {
                case 33: {
                    return (String)VC_P_VALUES.get(Bytes.get((byte)this.encoding));
                }
                case 48: {
                    return (String)VC_P_ALT.get(Bytes.get((byte)this.encoding));
                }
            }
            throw new IllegalArgumentException("Unknown vCard version " + ver);
        }

        public void send(DataOutputStream ostr, boolean more) throws IOException {
            if (more) {
                ostr.writeByte(this.encoding | 0xFFFFFF80);
            } else {
                ostr.writeByte(this.encoding);
            }
        }

        public void print(PrintWriter prt, byte ver) {
            prt.print(";" + this.getName() + "=" + this.getValue(ver));
        }

        public String toString() {
            return this.toString((byte)33);
        }

        public String toString(byte ver) {
            return ";" + this.getName() + "=" + this.getValue(ver);
        }

        public int hashCode() {
            return this.encoding;
        }

        public boolean equals(Object o) {
            try {
                Param p = (Param)o;
                return p.encoding == this.encoding;
            }
            catch (Throwable t) {
                return false;
            }
        }
    }

    private class ValParam
    extends Param {
        protected String value;

        public ValParam(byte enc, String val) {
            super(enc);
            this.value = val;
        }

        @Override
        public String getValue(byte ver) {
            return this.value;
        }

        @Override
        public void send(DataOutputStream ostr, boolean more) throws IOException {
            super.send(ostr, more);
            ostr.writeUTF(this.value);
        }

        @Override
        public int hashCode() {
            return this.encoding ^ this.value.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            try {
                ExtParam p = (ExtParam)o;
                return p.encoding == this.encoding && this.value.equals(p.value);
            }
            catch (Throwable t) {
                return false;
            }
        }
    }
}

