/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.profile;

import com.elluminate.groupware.profile.ProfileItem;
import com.elluminate.groupware.profile.ProfileItemID;
import java.awt.Image;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;

public class TextProfileItem
extends ProfileItem {
    public static final String MIME = "text/plain";
    public static final byte ITEM_TYPE = 1;
    protected String value;

    public TextProfileItem(ProfileItemID id, String value) {
        super(id, (byte)1, MIME);
        this.value = value;
    }

    public TextProfileItem(ProfileItemID id, DataInputStream str) throws IOException {
        super(id, (byte)1, MIME);
        this.value = str.readUTF();
    }

    public TextProfileItem(Element e) throws JDOMException {
        super(ProfileItemID.get(e), (byte)1, MIME);
        String s = e.getTextTrim();
        if (s.equals("")) {
            throw new JDOMException("No 'text' attribute or embedded text in 'text/plain' element.");
        }
        this.value = s;
    }

    @Override
    public byte[] getRaw() {
        throw new RuntimeException();
    }

    @Override
    public void send(DataOutputStream ostr) throws IOException {
        ostr.writeByte(this.kind);
        this.id.send(ostr);
        ostr.writeUTF(this.value);
    }

    @Override
    public void sendDeferred(DataOutputStream ostr) throws IOException {
        this.send(ostr);
    }

    @Override
    public String getText() {
        return this.value;
    }

    @Override
    public Image getImage() {
        return null;
    }

    @Override
    public void write(Element parent) {
        Element e = new Element(this.id.getName());
        e.setAttribute("mime", MIME);
        e.setText(this.value);
        parent.addContent((Content)e);
    }

    public String toString() {
        return this.id + "(" + MIME + ")=" + this.value;
    }

    public boolean equals(Object o) {
        try {
            TextProfileItem tpi = (TextProfileItem)o;
            return this.id == tpi.id && this.value.equals(tpi.value);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public int hashCode() {
        return this.id.hashCode() ^ this.value.hashCode();
    }
}

